window.onload = function() {
  //<editor-fold desc="Changeable Configuration Block">

  // the following lines will be replaced by docker/configurator, when it runs in a docker-container
  window.ui = SwaggerUIBundle({
      spec: {
  "openapi": "3.0.0",
  "servers": [
    {
      "description": "runZero Console",
      "url": "https://console.runzero.com/api/v1.0"
    }
  ],
  "info": {
    "description": "runZero API. API use is rate limited, you can make as many calls per day as you have licensed assets.",
    "version": "4.0.250826.0",
    "title": "runZero API",
    "contact": {
      "email": "support@runzero.com"
    },
    "license": {
      "name": "Commercial",
      "url": "https://www.runzero.com/legal/terms"
    }
  },
  "tags": [
    {
      "name": "Account",
      "description": "Requires Account key (starts with CT), or OAuth"
    },
    {
      "name": "Organization",
      "description": "Requires Organization key (starts with OT), Account key (starts with CT), or OAuth"
    },
    {
      "name": "Export",
      "description": "Requires Export token (starts with ET), Organization key (starts with OT), Account key (starts with CT), or OAuth"
    },
    {
      "name": "Import",
      "description": "Requires Organization key (starts with OT), Account key (starts with CT), or OAuth"
    },
    {
      "name": "Public",
      "description": "Unauthenticated"
    }
  ],
  "security": [
    {
      "bearerAuth": []
    },
    {
      "oauthDefaults": []
    }
  ],
  "paths": {
    "/releases/agent/version": {
      "get": {
        "tags": [
          "Public"
        ],
        "operationId": "getLatestAgentVersion",
        "security": [],
        "summary": "Returns latest agent version",
        "responses": {
          "200": {
            "description": "component version",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ComponentVersion"
                }
              }
            }
          }
        }
      }
    },
    "/releases/scanner/version": {
      "get": {
        "tags": [
          "Public"
        ],
        "operationId": "getLatestScannerVersion",
        "security": [],
        "summary": "Returns latest scanner version",
        "responses": {
          "200": {
            "description": "component version",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ComponentVersion"
                }
              }
            }
          }
        }
      }
    },
    "/releases/platform/version": {
      "get": {
        "tags": [
          "Public"
        ],
        "operationId": "getLatestPlatformVersion",
        "security": [],
        "summary": "Returns latest platform version",
        "responses": {
          "200": {
            "description": "component version",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ComponentVersion"
                }
              }
            }
          }
        }
      }
    },
    "/health": {
      "get": {
        "tags": [
          "Public"
        ],
        "operationId": "getHealthCheck",
        "security": [],
        "summary": "Returns a health check status (cloud and self-hosted)",
        "responses": {
          "200": {
            "description": "health status and current version",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/HealthCheckResponse"
                }
              }
            }
          }
        }
      }
    },
    "/import/org/{orgID}/assets": {
      "post": {
        "parameters": [
          {
            "name": "orgID",
            "in": "path",
            "required": true,
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "description": "The ID of the organization to import the assets into"
          }
        ],
        "tags": [
          "Organization",
          "Import"
        ],
        "operationId": "importCustomIntegrationAssets",
        "summary": "Import assets described by a registered custom integration",
        "description": "Assets can be discovered, imported, and merged by runZero scan tasks, first-party integrations, and third-party\ndefined custom integrations. See [/account/custom-integrations](#/account/getAccountCustomIntegrations). Currently only assets for custom integrations are importable here.\n",
        "requestBody": {
          "required": true,
          "content": {
            "multipart/form-data": {
              "schema": {
                "$ref": "#/components/schemas/NewAssetImport"
              },
              "encoding": {
                "assetData": {
                  "contentType": "application/gzip"
                }
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "import task created. The task ID should be checked for its status.",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/export/org/assets.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        },
        {
          "$ref": "#/components/parameters/pageSize"
        },
        {
          "$ref": "#/components/parameters/startKey"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetsJSON",
        "summary": "Exports the asset inventory",
        "responses": {
          "200": {
            "description": "Filtered asset results. <ul><li>When the `page_size` query parameter is not set in the request, the response will be a JSON array of assets.</li><li>When the `page_size` query parameter is present in the request, the response will be an object with an assets array and a `next_key` string for pagination.</li></ul>",
            "content": {
              "application/json": {
                "schema": {
                  "oneOf": [
                    {
                      "type": "array",
                      "items": {
                        "$ref": "#/components/schemas/Asset"
                      }
                    },
                    {
                      "type": "object",
                      "properties": {
                        "assets": {
                          "type": "array",
                          "items": {
                            "$ref": "#/components/schemas/Asset"
                          }
                        },
                        "next_key": {
                          "type": "string",
                          "description": "The key to use for the next page of results"
                        }
                      }
                    }
                  ]
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetsJSONL",
        "summary": "Asset inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered asset results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetsCSV",
        "summary": "Asset inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered asset results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets.nmap.xml": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetsNmapXML",
        "summary": "Asset inventory as Nmap-style XML",
        "responses": {
          "200": {
            "description": "filtered asset results",
            "content": {
              "text/xml": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/services.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        },
        {
          "$ref": "#/components/parameters/pageSize"
        },
        {
          "$ref": "#/components/parameters/startKey"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesJSON",
        "summary": "Service inventory as JSON",
        "responses": {
          "200": {
            "description": "Filtered service results. <ul><li>When the `page_size` query parameter is not set in the request, the response will be a JSON array of services.</li><li>When the `page_size` query parameter is present in the request, the response will be an object with a services array and a `next_key` string for pagination.</li></ul>",
            "content": {
              "application/json": {
                "schema": {
                  "oneOf": [
                    {
                      "type": "array",
                      "items": {
                        "$ref": "#/components/schemas/Service"
                      }
                    },
                    {
                      "type": "object",
                      "properties": {
                        "services": {
                          "type": "array",
                          "items": {
                            "$ref": "#/components/schemas/Service"
                          }
                        },
                        "next_key": {
                          "type": "string",
                          "description": "The key to use for the next page of results"
                        }
                      }
                    }
                  ]
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/services.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesJSONL",
        "summary": "Service inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered service results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/services.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesCSV",
        "summary": "Service inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered service results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/sites.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSitesJSON",
        "summary": "Export all sites",
        "responses": {
          "200": {
            "description": "all sites",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Site"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/sites.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSitesJSONL",
        "summary": "Site list as JSON line-delimited",
        "responses": {
          "200": {
            "description": "all sites",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/sites.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSitesCSV",
        "summary": "Site list as CSV",
        "responses": {
          "200": {
            "description": "all sites",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/wireless.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        },
        {
          "$ref": "#/components/parameters/pageSize"
        },
        {
          "$ref": "#/components/parameters/startKey"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportWirelessJSON",
        "summary": "Wireless inventory as JSON",
        "responses": {
          "200": {
            "description": "Filtered wireless results. <ul><li>When the `page_size` query parameter is not set in the request, the response will be a JSON array of wireless.</li><li>When the `page_size` query parameter is present in the request, the response will be an object with a wireless array and a `next_key` string for pagination.</li></ul>",
            "content": {
              "application/json": {
                "schema": {
                  "oneOf": [
                    {
                      "type": "array",
                      "items": {
                        "$ref": "#/components/schemas/Wireless"
                      }
                    },
                    {
                      "type": "object",
                      "properties": {
                        "wireless": {
                          "type": "array",
                          "items": {
                            "$ref": "#/components/schemas/Wireless"
                          }
                        },
                        "next_key": {
                          "type": "string",
                          "description": "The key to use for the next page of results"
                        }
                      }
                    }
                  ]
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/wireless.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportWirelessJSONL",
        "summary": "Wireless inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered wireless results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/wireless.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportWirelessCSV",
        "summary": "Wireless inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered wireless results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/software.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        },
        {
          "$ref": "#/components/parameters/pageSize"
        },
        {
          "$ref": "#/components/parameters/startKey"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSoftwareJSON",
        "summary": "Exports the software inventory",
        "responses": {
          "200": {
            "description": "Filtered software results. <ul><li>When the `page_size` query parameter is not set in the request, the response will be a JSON array of software.</li><li>When the `page_size` query parameter is present in the request, the response will be an object with a software array and a `next_key` string for pagination.</li></ul>",
            "content": {
              "application/json": {
                "schema": {
                  "oneOf": [
                    {
                      "type": "array",
                      "items": {
                        "$ref": "#/components/schemas/Software"
                      }
                    },
                    {
                      "type": "object",
                      "properties": {
                        "software": {
                          "type": "array",
                          "items": {
                            "$ref": "#/components/schemas/Software"
                          }
                        },
                        "next_key": {
                          "type": "string",
                          "description": "The key to use for the next page of results"
                        }
                      }
                    }
                  ]
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/software.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSoftwareJSONL",
        "summary": "Software inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered software results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/software.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSoftwareCSV",
        "summary": "Software inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered software results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/vulnerabilities.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        },
        {
          "$ref": "#/components/parameters/pageSize"
        },
        {
          "$ref": "#/components/parameters/startKey"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportVulnerabilitiesJSON",
        "summary": "Export the vulnerability inventory as JSON",
        "responses": {
          "200": {
            "description": "Filtered vulnerability results. <ul><li>When the `page_size` query parameter is not set in the request, the response will be a JSON array of vulnerabilities.</li><li>When the `page_size` query parameter is present in the request, the response will be an object with an vulnerabilites array and a `next_key` string for pagination.</li></ul>",
            "content": {
              "application/json": {
                "schema": {
                  "oneOf": [
                    {
                      "type": "array",
                      "items": {
                        "$ref": "#/components/schemas/Vulnerability"
                      }
                    },
                    {
                      "type": "object",
                      "properties": {
                        "vulnerabilities": {
                          "type": "array",
                          "items": {
                            "$ref": "#/components/schemas/Vulnerability"
                          }
                        },
                        "next_key": {
                          "type": "string",
                          "description": "The key to use for the next page of results"
                        }
                      }
                    }
                  ]
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/vulnerabilities.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportVulnerabilitiesJSONL",
        "summary": "Export the vulnerability inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered vulnerability results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/vulnerabilities.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportVulnerabilitiesCSV",
        "summary": "Export the vulnerability inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered vulnerability results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/certificates.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export",
          "Certificates"
        ],
        "operationId": "exportCertificatesCSV",
        "summary": "Export the certificate inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered certificate results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/certificates.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export",
          "Certificates"
        ],
        "operationId": "exportCertificatesJSON",
        "summary": "Export the certificate inventory as JSON",
        "responses": {
          "200": {
            "description": "filtered certificate results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Certificate"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/certificates.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export",
          "Certificates"
        ],
        "operationId": "exportCertificatesJSONL",
        "summary": "Export the certificate inventory as JSONL line-delimited",
        "responses": {
          "200": {
            "description": "filtered certificate results",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Certificate"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/users.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportDirectoryUsersJSON",
        "summary": "Exports the user inventory",
        "responses": {
          "200": {
            "description": "filtered user results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/DirectoryUser"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/users.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportDirectoryUsersJSONL",
        "summary": "User inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered user results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/users.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportDirectoryUsersCSV",
        "summary": "User inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered user results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/groups.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportDirectoryGroupsJSON",
        "summary": "Exports the group inventory",
        "responses": {
          "200": {
            "description": "filtered group results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/DirectoryGroup"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/groups.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportDirectoryGroupsJSONL",
        "summary": "Group inventory as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered group results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/groups.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportDirectoryGroupsCSV",
        "summary": "Group inventory as CSV",
        "responses": {
          "200": {
            "description": "filtered group results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/findings.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportFindingsCSV",
        "summary": "Export findings as CSV",
        "responses": {
          "200": {
            "description": "filtered findings",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/findings.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportFindingsJSON",
        "summary": "Export findings as JSON",
        "responses": {
          "200": {
            "description": "filtered findings",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Finding"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/findings.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportFindingsJSONL",
        "summary": "Export findings as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered findings",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Finding"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/subnet.stats.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSubnetUtilizationStatsCSV",
        "summary": "Subnet utilization statistics as as CSV",
        "parameters": [
          {
            "in": "query",
            "name": "mask",
            "description": "an optional subnet mask size (ex:24)",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "subnet utilization stats as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/snmp.arpcache.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportSNMPARPCacheCSV",
        "summary": "SNMP ARP cache data as CSV",
        "responses": {
          "200": {
            "description": "SNMP ARP cache data as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/tasks.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportTasksJSON",
        "summary": "Exports organization tasks",
        "responses": {
          "200": {
            "description": "filtered task results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Task"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/tasks.jsonl": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportTasksJSONL",
        "summary": "Organization tasks as JSON line-delimited",
        "responses": {
          "200": {
            "description": "filtered task results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/assets/type.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetTopTypesCSV",
        "summary": "Top asset types as CSV",
        "responses": {
          "200": {
            "description": "top asset types and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/assets/os.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetTopOSCSV",
        "summary": "Top asset operating systems as CSV",
        "responses": {
          "200": {
            "description": "top operating systems and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/assets/hw.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetTopHWCSV",
        "summary": "Top asset hardware products as CSV",
        "responses": {
          "200": {
            "description": "top asset hardware platforms and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/assets/tags.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportAssetTopTagsCSV",
        "summary": "Top asset tags as CSV",
        "responses": {
          "200": {
            "description": "top asset tags and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/services/tcp.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesTopTCPCSV",
        "summary": "Top TCP services as CSV",
        "responses": {
          "200": {
            "description": "top TCP services and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/services/udp.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesTopUDPCSV",
        "summary": "Top UDP services as CSV",
        "responses": {
          "200": {
            "description": "top UDP services and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/services/protocols.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesTopProtocolsCSV",
        "summary": "Top service protocols as CSV",
        "responses": {
          "200": {
            "description": "top service protocols and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/services/products.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Export"
        ],
        "operationId": "exportServicesTopProductsCSV",
        "summary": "Top service products as CSV",
        "responses": {
          "200": {
            "description": "top service products and counts as csv",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/metrics": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "operationId": "exportAssetMetricsJSON",
        "summary": "Export asset metrics",
        "responses": {
          "200": {
            "description": "asset metrics",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "additionalProperties": {
                    "type": "object",
                    "properties": {
                      "site_id": {
                        "type": "string"
                      },
                      "metrics": {
                        "type": "object"
                      }
                    }
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getOrganization",
        "summary": "Get organization details",
        "responses": {
          "200": {
            "description": "organization details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Organization"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateOrganization",
        "summary": "Update organization details",
        "requestBody": {
          "description": "organization options",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/OrgOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "organization details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Organization"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/key": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getKey",
        "summary": "Get API key details",
        "responses": {
          "200": {
            "description": "api key details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/APIKey"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeKey",
        "summary": "Remove the current API key",
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/key/rotate": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "rotateKey",
        "summary": "Rotate the API key secret and return the updated key",
        "responses": {
          "200": {
            "description": "api key details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/APIKey"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/agents": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getAgents",
        "summary": "Get all agents. Legacy path for /org/explorers",
        "responses": {
          "200": {
            "description": "array of agents",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Agent"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/agents/{agent_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getAgent",
        "summary": "Get details for a single agent. Legacy path for /org/explorers/{explorer_id}",
        "parameters": [
          {
            "in": "path",
            "name": "agent_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the agent"
          }
        ],
        "responses": {
          "200": {
            "description": "agent details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Agent"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeAgent",
        "summary": "Remove and uninstall an agent. Legacy path for /org/explorers/{explorer_id}",
        "parameters": [
          {
            "in": "path",
            "name": "agent_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the agent to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateAgentSettings",
        "summary": "Update the settings associated with the agent. Legacy path for /org/explorers/{explorer_id}",
        "parameters": [
          {
            "in": "path",
            "name": "agent_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the agent to update"
          }
        ],
        "requestBody": {
          "description": "The updated settings to apply to the agent",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AgentPatchedSettings"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "agent details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Agent"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/agents/{agent_id}/update": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "upgradeAgent",
        "summary": "Force an agent to update and restart. Legacy path for /org/explorers/{explorer_id}/update",
        "parameters": [
          {
            "in": "path",
            "name": "agent_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the agent to update"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/explorers": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getExplorers",
        "summary": "Get all explorers",
        "description": "Get all explorers. This is the same call as legacy path /org/agents",
        "responses": {
          "200": {
            "description": "array of agents",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Explorer"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/explorers/{explorer_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getExplorer",
        "summary": "Get details for a single explorer.",
        "description": "Get details for a single explorer. This is the same call as legacy path /org/agents/{agent_id}",
        "parameters": [
          {
            "in": "path",
            "name": "explorer_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the explorer"
          }
        ],
        "responses": {
          "200": {
            "description": "explorer details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Explorer"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeExplorer",
        "summary": "Remove and uninstall an explorer",
        "description": "Remove and uninstall an explorer. This is the same call as legacy path /org/agents/{agent_id}",
        "parameters": [
          {
            "in": "path",
            "name": "explorer_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the explorer to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateExplorerSettings",
        "summary": "Update the settings associated with the Explorer",
        "description": "Update the settings associated with the Explorer. This is the same call as legacy path /org/agents/{agent_id}",
        "parameters": [
          {
            "in": "path",
            "name": "explorer_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the explorer to update"
          }
        ],
        "requestBody": {
          "description": "The updated settings to apply to the Explorer",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/ExplorerPatchedSettings"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "explorer details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Explorer"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/explorers/{explorer_id}/update": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "upgradeExplorer",
        "summary": "Force an explorer to update and restart",
        "description": "Force an explorer to update and restart. This is the same call as legacy path /org/agents/{agent_id}/update",
        "parameters": [
          {
            "in": "path",
            "name": "explorer_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the explorer to update"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/hosted-zones": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getHostedZones",
        "summary": "Get all hosted zones",
        "description": "Get all hosted zones. Hosted Zones are only available to Enterprise licensed customers.",
        "responses": {
          "200": {
            "description": "array of hosted zones",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/HostedZone"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/hosted-zones/{hosted_zone_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getHostedZone",
        "summary": "Get details for a single hosted zone.",
        "description": "Get details for a single Hosted Zone. Hosted Zones are only available to Enterprise licensed customers.",
        "parameters": [
          {
            "in": "path",
            "name": "hosted_zone_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the hosted zone"
          }
        ],
        "responses": {
          "200": {
            "description": "hosted zone details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/HostedZone"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/sites": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getSites",
        "summary": "Get all sites",
        "responses": {
          "200": {
            "description": "array of sites",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Site"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Organization"
        ],
        "operationId": "createSite",
        "summary": "Create a new site",
        "requestBody": {
          "description": "site definition",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/SiteOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "site details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Site"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/sites/{site_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getSite",
        "summary": "Get site details",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site"
          }
        ],
        "responses": {
          "200": {
            "description": "site details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Site"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeSite",
        "summary": "Remove a site and associated assets",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateSite",
        "summary": "Update a site definition",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to update"
          }
        ],
        "requestBody": {
          "description": "site object",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/SiteOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "site details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Site"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/sites/{site_id}/import": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "put": {
        "tags": [
          "Organization"
        ],
        "operationId": "importScanData",
        "summary": "Import a scan data file into a site",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to import scan data into"
          }
        ],
        "requestBody": {
          "content": {
            "application/octet-stream": {
              "schema": {
                "type": "string",
                "format": "binary"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "import task",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/LicenseExpiredError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/ProcessingError"
          }
        }
      }
    },
    "/org/sites/{site_id}/import/nessus": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "put": {
        "tags": [
          "Organization"
        ],
        "operationId": "importNessusScanData",
        "summary": "Import a Nessus scan data file into a site",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to import Nessus scan data into"
          }
        ],
        "requestBody": {
          "content": {
            "application/octet-stream": {
              "schema": {
                "type": "string",
                "format": "binary"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "import task",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/LicenseExpiredError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/ProcessingError"
          }
        }
      }
    },
    "/org/sites/{site_id}/import/packet": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "put": {
        "tags": [
          "Organization"
        ],
        "operationId": "importPacketData",
        "summary": "Import a packet capture file into a site",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to import packet capture into"
          }
        ],
        "requestBody": {
          "content": {
            "application/octet-stream": {
              "schema": {
                "type": "string",
                "format": "binary"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "import task",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/LicenseExpiredError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/ProcessingError"
          }
        }
      }
    },
    "/org/sites/{site_id}/scan": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "put": {
        "tags": [
          "Organization"
        ],
        "operationId": "createScan",
        "summary": "Create a scan task for a given site",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to scan"
          }
        ],
        "requestBody": {
          "content": {
            "text/json": {
              "schema": {
                "$ref": "#/components/schemas/ScanOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "a created scan task",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/LicenseExpiredError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/ProcessingError"
          }
        }
      }
    },
    "/org/sites/{site_id}/sample": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "put": {
        "tags": [
          "Organization"
        ],
        "operationId": "createSample",
        "summary": "Create a traffic sampling task for a given site",
        "parameters": [
          {
            "in": "path",
            "name": "site_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID or name of the site to scan"
          }
        ],
        "requestBody": {
          "content": {
            "text/json": {
              "schema": {
                "$ref": "#/components/schemas/SampleOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "a created scan task",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/LicenseExpiredError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/ProcessingError"
          }
        }
      }
    },
    "/org/assets": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        },
        {
          "$ref": "#/components/parameters/search"
        },
        {
          "$ref": "#/components/parameters/fields"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getAssets",
        "summary": "Get all assets",
        "responses": {
          "200": {
            "description": "array of assets",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Asset"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/assets/{asset_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getAsset",
        "summary": "Get asset details",
        "parameters": [
          {
            "in": "path",
            "name": "asset_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the asset to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "asset details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Asset"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeAsset",
        "summary": "Remove an asset",
        "parameters": [
          {
            "in": "path",
            "name": "asset_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the asset to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/bulk/delete": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeBulkAssets",
        "summary": "Removes multiple assets by ID",
        "requestBody": {
          "description": "list of asset IDs to remove",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetIDs"
              }
            }
          }
        },
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/assets/{asset_id}/comments": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateAssetComments",
        "summary": "Update asset comments",
        "parameters": [
          {
            "in": "path",
            "name": "asset_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the asset to update"
          }
        ],
        "requestBody": {
          "description": "comments to apply to the asset",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetComments"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "asset details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Asset"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/{asset_id}/tags": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateAssetTags",
        "summary": "Update asset tags",
        "parameters": [
          {
            "in": "path",
            "name": "asset_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the asset to update"
          }
        ],
        "requestBody": {
          "description": "tags to apply to the asset",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetTags"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "asset details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Asset"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/{asset_id}/criticality": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateAssetCriticality",
        "summary": "Update asset criticality",
        "parameters": [
          {
            "in": "path",
            "name": "asset_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the asset to update"
          }
        ],
        "requestBody": {
          "description": "comments to apply to the asset",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetCriticality"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "asset details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Asset"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/merge": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "mergeAssets",
        "summary": "Merge multiple assets",
        "requestBody": {
          "description": "List of Asset IDs to merge",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetIDs"
              }
            }
          }
        },
        "responses": {
          "200": {
            "$ref": "#/components/responses/StatusMessage"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/bulk/tags": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateBulkAssetTags",
        "summary": "Update tags across multiple assets based on a search query",
        "requestBody": {
          "description": "search query to filter and tags to apply",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetTagsWithSearch"
              }
            }
          }
        },
        "responses": {
          "200": {
            "$ref": "#/components/responses/StatusMessage"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/bulk/clearTags": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "clearBulkAssetTags",
        "summary": "Clear all tags across multiple assets based on a search query",
        "requestBody": {
          "description": "search query to filter",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/Search"
              }
            }
          }
        },
        "responses": {
          "200": {
            "$ref": "#/components/responses/StatusMessage"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/bulk/criticality": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateBulkAssetCriticality",
        "summary": "Update criticality across multiple assets based on a search query",
        "requestBody": {
          "description": "search query to filter and criticality to apply",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetCriticalityWithSearch"
              }
            }
          }
        },
        "responses": {
          "200": {
            "$ref": "#/components/responses/StatusMessage"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/assets/{asset_id}/owners": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateAssetOwners",
        "summary": "Update asset owners",
        "parameters": [
          {
            "in": "path",
            "name": "asset_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the asset to update"
          }
        ],
        "requestBody": {
          "description": "list of ownerships to apply to the asset",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetOwnerships"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "asset details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Asset"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/assets/bulk/owners": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateBulkAssetOwners",
        "summary": "Update asset owners across multiple assets based on a search query",
        "requestBody": {
          "description": "search query to filter and ownerships to apply",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetOwnershipsWithSearch"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "updated asset count",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "updated_asset_count": {
                      "type": "integer",
                      "example": 10
                    }
                  }
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/assets/bulk/clearOwners": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "clearBulkAssetOwners",
        "summary": "Clear all owners across multiple assets based on a search query",
        "requestBody": {
          "description": "search query to filter",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/Search"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "updated asset count",
            "content": {
              "application/json": {
                "schema": {
                  "type": "object",
                  "properties": {
                    "updated_asset_count": {
                      "type": "integer",
                      "example": 10
                    }
                  }
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "403": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/custom-integrations/{custom_integration_id}/bulk/remove": {
      "parameters": [
        {
          "in": "path",
          "name": "custom_integration_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the custom integration"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "bulkRemoveCustomIntegration",
        "summary": "Remove custom integration from a list of assets",
        "requestBody": {
          "description": "list of asset IDs to remove",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetIDs"
              }
            }
          }
        },
        "responses": {
          "204": {
            "description": "empty response"
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestParamError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/assets/{asset_id}/custom-integrations/{custom_integration_id}/remove": {
      "parameters": [
        {
          "in": "path",
          "name": "asset_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the asset to update"
        },
        {
          "in": "path",
          "name": "custom_integration_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the custom integration"
        }
      ],
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeCustomIntegration",
        "summary": "Remove single custom integration from asset",
        "responses": {
          "204": {
            "description": "empty response"
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestParamError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/assets/{asset_id}/sources/{source_id}/remove": {
      "parameters": [
        {
          "in": "path",
          "name": "asset_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the asset to update"
        },
        {
          "in": "path",
          "name": "source_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the source"
        }
      ],
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeAssetSource",
        "summary": "Remove single source from asset",
        "responses": {
          "204": {
            "description": "empty response"
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestParamError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/custom-integrations": {
      "get": {
        "tags": [
          "Org"
        ],
        "operationId": "getOrgCustomIntegrations",
        "summary": "Get all custom integrations",
        "responses": {
          "200": {
            "description": "An array of all custom integrations",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/custom-integrations/{customIntegrationId}": {
      "parameters": [
        {
          "in": "path",
          "name": "customIntegrationId",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the custom integration"
        }
      ],
      "get": {
        "tags": [
          "Org"
        ],
        "operationId": "getOrgCustomIntegration",
        "summary": "Get single custom integration",
        "responses": {
          "200": {
            "description": "The custom integration with given ID",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/org/services": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getServices",
        "summary": "Get all services",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of services",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Service"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/services/{service_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getService",
        "summary": "Get service details",
        "parameters": [
          {
            "in": "path",
            "name": "service_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the service to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "service details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Service"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeService",
        "summary": "Remove a service",
        "parameters": [
          {
            "in": "path",
            "name": "service_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the service to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/wireless": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getWirelessLANs",
        "summary": "Get all wireless LANs",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of wireless LANs",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Wireless"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/wireless/{wireless_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getWirelessLAN",
        "summary": "Get wireless LAN details",
        "parameters": [
          {
            "in": "path",
            "name": "wireless_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the wireless LAN to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "wireless details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Wireless"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "delete": {
        "tags": [
          "Organization"
        ],
        "operationId": "removeWirelessLAN",
        "summary": "Remove a wireless LAN",
        "parameters": [
          {
            "in": "path",
            "name": "wireless_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the wireless LAN to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/tasks": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getTasks",
        "summary": "Get all tasks (last 1000)",
        "parameters": [
          {
            "in": "query",
            "name": "status",
            "description": "an optional status string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of tasks",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Task"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/org/tasks/{task_id}": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getTask",
        "summary": "Get task details",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "task details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "patch": {
        "tags": [
          "Organization"
        ],
        "operationId": "updateTask",
        "summary": "Update task parameters",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task to update"
          }
        ],
        "requestBody": {
          "description": "task object",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/TaskOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "task details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/tasks/{task_id}/data": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getTaskScanData",
        "summary": "Returns a temporary task scan data url",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task"
          }
        ],
        "responses": {
          "303": {
            "description": "Redirection to scan data",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/URL"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/tasks/{task_id}/changes": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getTaskChangeReport",
        "summary": "Returns a temporary task change report data url",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task"
          }
        ],
        "responses": {
          "303": {
            "description": "Redirection to scan data",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/URL"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/tasks/{task_id}/log": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Organization"
        ],
        "operationId": "getTaskLog",
        "summary": "Returns a temporary task log data url",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task"
          }
        ],
        "responses": {
          "303": {
            "description": "Redirection to scan data",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/URL"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/tasks/{task_id}/stop": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "stopTask",
        "summary": "Signal that a task should be stopped or canceled.This will also remove recurring and scheduled tasks",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task to stop"
          }
        ],
        "responses": {
          "200": {
            "description": "task information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/org/tasks/{task_id}/hide": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "post": {
        "tags": [
          "Organization"
        ],
        "operationId": "hideTask",
        "summary": "Signal that a completed task should be hidden",
        "parameters": [
          {
            "in": "path",
            "name": "task_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the task to hide"
          }
        ],
        "responses": {
          "200": {
            "description": "task information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Task"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/orgs": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountOrganizations",
        "summary": "Get all organization details",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of organizations",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Organization"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountOrganization",
        "summary": "Create a new organization",
        "requestBody": {
          "description": "organization definition",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/OrgOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "organization details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Organization"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/orgs/{org_id}": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountOrganization",
        "summary": "Get organization details",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "organization information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Organization"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountOrganization",
        "summary": "Update organization details",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          }
        ],
        "requestBody": {
          "description": "organization options",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/OrgOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "organization details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Organization"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountOrganization",
        "summary": "Remove this organization",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/orgs/{org_id}/exportToken": {
      "delete": {
        "deprecated": true,
        "tags": [
          "Account"
        ],
        "operationId": "deleteAccountOrganizationExportTokenDeprecated",
        "summary": "Removes the export token from the specified organization",
        "description": "This API has been deprecated.  Please use `DELETE /account/orgs/{org_id}/exportTokens/{key_id}` instead.  This API will fail if more than one export tokens exist for the given organization.",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/orgs/{org_id}/exportToken/rotate": {
      "patch": {
        "deprecated": true,
        "tags": [
          "Account"
        ],
        "operationId": "rotateAccountOrganizationExportTokenDeprecated",
        "summary": "Rotates an organization export token and returns the updated token",
        "description": "This API has been deprecated.  Please use `PATCH /account/orgs/{org_id}/exportTokens/{key_id}/rotate` instead.  This API will fail if more than one export tokens exist for the given organization.",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "export token details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ExportToken"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/orgs/{org_id}/exportTokens": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountOrganizationExportTokens",
        "summary": "Get all active export tokens for an organization",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve export tokens for"
          }
        ],
        "responses": {
          "200": {
            "description": "array of export tokens",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/ExportToken"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountOrganizationExportToken",
        "summary": "Create a new export token for an organization",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to create an export token for"
          }
        ],
        "requestBody": {
          "description": "export token parameters",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/ExportTokenOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "export token details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ExportToken"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/orgs/{org_id}/exportTokens/{key_id}": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountOrganizationExportToken",
        "summary": "Get export token details",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          },
          {
            "in": "path",
            "name": "key_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the export token ID to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "export token details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ExportToken"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "deleteAccountOrganizationExportToken",
        "summary": "Removes the export token from the specified organization",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          },
          {
            "in": "path",
            "name": "key_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the export token ID to remove"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/orgs/{org_id}/exportTokens/{key_id}/rotate": {
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "rotateAccountOrganizationExportToken",
        "summary": "Rotates an organization export token and returns the updated token",
        "parameters": [
          {
            "in": "path",
            "name": "org_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the organization to retrieve"
          },
          {
            "in": "path",
            "name": "key_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the export token ID to rotate"
          }
        ],
        "responses": {
          "200": {
            "description": "export token details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ExportToken"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/license": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountLicense",
        "summary": "Get license details",
        "responses": {
          "200": {
            "description": "license information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/License"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/sites": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountSites",
        "summary": "Get all sites details across all organizations",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of sites",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Site"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/credentials": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountCredentials",
        "summary": "Get all account credentials",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of credentials",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Credential"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountCredential",
        "summary": "Create a new credential",
        "requestBody": {
          "description": "credential parameters",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/CredentialOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "credential details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Credential"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/credentials/{credential_id}": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountCredential",
        "summary": "Get credential details",
        "parameters": [
          {
            "in": "path",
            "name": "credential_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the credential to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "credential details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Credential"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountCredential",
        "summary": "Remove this credential",
        "parameters": [
          {
            "in": "path",
            "name": "credential_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the credential to delete"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/keys": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountKeys",
        "summary": "Get all active API keys",
        "responses": {
          "200": {
            "description": "array of keys",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/APIKey"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountKey",
        "summary": "Create a new key",
        "requestBody": {
          "description": "key parameters",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/APIKeyOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "key details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/APIKey"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/keys/{key_id}": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountKey",
        "summary": "Get key details",
        "parameters": [
          {
            "in": "path",
            "name": "key_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the key to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "api key information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/APIKey"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountKey",
        "summary": "Remove this key",
        "parameters": [
          {
            "in": "path",
            "name": "key_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the key to retrieve"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/keys/{key_id}/rotate": {
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "rotateAccountKey",
        "summary": "Rotates the key secret",
        "parameters": [
          {
            "in": "path",
            "name": "key_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the key to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "key details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/APIKey"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/events.json": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "exportEventsJSON",
        "summary": "System event log as JSON",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "fields",
            "description": "an optional list of fields to export, comma-separated",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "$ref": "#/components/parameters/pageSize"
          },
          {
            "$ref": "#/components/parameters/startKey"
          }
        ],
        "responses": {
          "200": {
            "description": "Filtered event results. <ul><li>When the `page_size` query parameter is not set in the request, the response will be a JSON array of events.</li><li>When the `page_size` query parameter is present in the request, the response will be an object with an events array and a `next_key` string for pagination.</li></ul>",
            "content": {
              "application/json": {
                "schema": {
                  "oneOf": [
                    {
                      "type": "array",
                      "items": {
                        "$ref": "#/components/schemas/Event"
                      }
                    },
                    {
                      "type": "object",
                      "properties": {
                        "events": {
                          "type": "array",
                          "items": {
                            "$ref": "#/components/schemas/Event"
                          }
                        },
                        "next_key": {
                          "type": "string",
                          "description": "The key to use for the next page of results"
                        }
                      }
                    }
                  ]
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/events.jsonl": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "exportEventsJSONL",
        "summary": "System event log as JSON line-delimited",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "fields",
            "description": "an optional list of fields to export, comma-separated",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "filtered event results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Event"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/tasks": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountTasks",
        "summary": "Get all task details across all organizations (up to 1000)",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of tasks",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Task"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/tasks/templates": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountScanTemplates",
        "summary": "Get all scan templates across all organizations (up to 1000)",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of scan templates",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/ScanTemplate"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "422": {
            "description": "failed to parse search string"
          }
        }
      },
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountScanTemplate",
        "summary": "Create a new scan template",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/ScanTemplateOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "scan template",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ScanTemplate"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountScanTemplate",
        "summary": "Update scan template",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/ScanTemplate"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "scan template",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ScanTemplate"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "description": "scan template or permissions not found"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          }
        }
      }
    },
    "/account/tasks/templates/{scan_template_id}": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountScanTemplate",
        "summary": "Get scan template details",
        "parameters": [
          {
            "in": "path",
            "name": "scan_template_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the scan template to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "scan template",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ScanTemplate"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "description": "scan template not found"
          },
          "422": {
            "description": "invalid scan template id"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountScanTemplate",
        "summary": "Remove scan template",
        "parameters": [
          {
            "in": "path",
            "name": "scan_template_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the scan template to remove"
          }
        ],
        "responses": {
          "200": {
            "description": "scan template",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/ScanTemplate"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "description": "scan template not found"
          },
          "422": {
            "description": "invalid request"
          }
        }
      }
    },
    "/account/agents": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountAgents",
        "summary": "Get all agents across all organizations",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "array of tasks",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/Agent"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/users": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountUsers",
        "summary": "Get all users",
        "responses": {
          "200": {
            "description": "array of users",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/User"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountUser",
        "summary": "Create a new user account",
        "requestBody": {
          "description": "user parameters",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/UserOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "key details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/users/invite": {
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountUserInvite",
        "summary": "Create a new user account and send an email invite",
        "requestBody": {
          "description": "user invite parameters",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/UserInviteOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "key details",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      }
    },
    "/account/users/{user_id}": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountUser",
        "summary": "Get user details",
        "parameters": [
          {
            "in": "path",
            "name": "user_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the user to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "user information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountUser",
        "summary": "Remove this user",
        "parameters": [
          {
            "in": "path",
            "name": "user_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the user to delete"
          }
        ],
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountUser",
        "summary": "Update a user's details",
        "parameters": [
          {
            "in": "path",
            "name": "user_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the user to retrieve"
          }
        ],
        "requestBody": {
          "description": "user parameters",
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/UserOptions"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "user information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/users/{user_id}/resetMFA": {
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "resetAccountUserMFA",
        "summary": "Resets the user's MFA tokens",
        "parameters": [
          {
            "in": "path",
            "name": "user_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the user to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "user information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/users/{user_id}/resetLockout": {
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "resetAccountUserLockout",
        "summary": "Resets the user's lockout status",
        "parameters": [
          {
            "in": "path",
            "name": "user_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the user to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "user information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/users/{user_id}/resetPassword": {
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "resetAccountUserPassword",
        "summary": "Sends the user a password reset email",
        "parameters": [
          {
            "in": "path",
            "name": "user_id",
            "schema": {
              "type": "string",
              "format": "uuid"
            },
            "required": true,
            "description": "UUID of the user to retrieve"
          }
        ],
        "responses": {
          "200": {
            "description": "user information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/User"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/groups": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountGroups",
        "summary": "Get all groups",
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Group"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountGroup",
        "summary": "Create a new group",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/GroupPost"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Group"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountGroup",
        "summary": "Update an existing group",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/GroupPut"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Group"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/groups/{group_id}": {
      "parameters": [
        {
          "in": "path",
          "name": "group_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the group"
        }
      ],
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountGroup",
        "summary": "Get group details",
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/Group"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountGroup",
        "summary": "Remove this group",
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/sso/groups": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountGroupMappings",
        "summary": "Get all SSO group mappings",
        "responses": {
          "200": {
            "description": "group mapping information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/GroupMapping"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountGroupMapping",
        "summary": "Create a new SSO group mapping",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/GroupMapping"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/GroupMapping"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountGroupMapping",
        "summary": "Update an existing SSO group mapping",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/GroupMapping"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/GroupMapping"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/sso/groups/{group_mapping_id}": {
      "parameters": [
        {
          "in": "path",
          "name": "group_mapping_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the SSO group mapping"
        }
      ],
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountGroupMapping",
        "summary": "Get SSO group mapping details",
        "responses": {
          "200": {
            "description": "group information",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/GroupMapping"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "removeAccountGroupMapping",
        "summary": "Remove this SSO group mapping",
        "responses": {
          "204": {
            "description": "empty response"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/assets/ownership-types": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountAssetOwnershipTypes",
        "summary": "Get all asset ownership types",
        "responses": {
          "200": {
            "description": "array of asset ownership types",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetOwnershipType"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountAssetOwnershipTypes",
        "summary": "Create new asset ownership types",
        "requestBody": {
          "required": true,
          "description": "array of asset ownership types",
          "content": {
            "application/json": {
              "schema": {
                "type": "array",
                "items": {
                  "$ref": "#/components/schemas/AssetOwnershipTypePost"
                }
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "array of asset ownership types",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetOwnershipType"
                  }
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountAssetOwnershipTypes",
        "summary": "Update asset ownership types",
        "requestBody": {
          "required": true,
          "description": "array of asset ownership types",
          "content": {
            "application/json": {
              "schema": {
                "type": "array",
                "items": {
                  "$ref": "#/components/schemas/AssetOwnershipType"
                }
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "array of asset ownership types",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetOwnershipType"
                  }
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "deleteAccountAssetOwnershipTypes",
        "summary": "Delete asset ownership types",
        "requestBody": {
          "required": true,
          "description": "Array of ids",
          "content": {
            "application/json": {
              "schema": {
                "type": "array",
                "items": {
                  "type": "string"
                },
                "example": [
                  "2318e078-4164-4e1b-92a5-11e353093f4b",
                  "a352c76b-0eb7-4dab-adea-66e8b6016565"
                ]
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "array of remaining asset ownership types",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetOwnershipType"
                  }
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/account/assets/ownership-types/{ownership_type_id}": {
      "parameters": [
        {
          "in": "path",
          "name": "ownership_type_id",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the asset ownership type"
        }
      ],
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountAssetOwnershipType",
        "summary": "Update a single asset ownership type",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/AssetOwnershipTypePost"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "updated asset ownership type",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/AssetOwnershipType"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "deleteAccountAssetOwnershipType",
        "summary": "Delete a single asset ownership type",
        "responses": {
          "200": {
            "description": "array of remaining asset ownership types",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetOwnershipType"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/account/custom-integrations": {
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountCustomIntegrations",
        "summary": "Get all custom integrations",
        "responses": {
          "200": {
            "description": "An array of all custom integrations",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountCustomIntegration",
        "summary": "Create a new custom integration",
        "requestBody": {
          "required": true,
          "description": "The description of the custom integration",
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/NewCustomIntegration"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "The custom integration created",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/account/custom-integrations/{customIntegrationId}": {
      "parameters": [
        {
          "in": "path",
          "name": "customIntegrationId",
          "schema": {
            "type": "string",
            "format": "uuid"
          },
          "required": true,
          "description": "UUID of the custom integration"
        }
      ],
      "get": {
        "tags": [
          "Account"
        ],
        "operationId": "getAccountCustomIntegration",
        "summary": "Get single custom integration",
        "responses": {
          "200": {
            "description": "The custom integration with given ID",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "patch": {
        "tags": [
          "Account"
        ],
        "operationId": "updateAccountCustomIntegration",
        "summary": "Update a single custom integration",
        "requestBody": {
          "required": true,
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/BaseCustomIntegration"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "The updated custom integration",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "put": {
        "tags": [
          "Account"
        ],
        "operationId": "createAccountCustomIntegrationAndID",
        "summary": "Replace custom integration at provided ID",
        "requestBody": {
          "required": true,
          "description": "single custom integration type",
          "content": {
            "application/json": {
              "schema": {
                "$ref": "#/components/schemas/NewCustomIntegration"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "The updated custom integration",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "422": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      },
      "delete": {
        "tags": [
          "Account"
        ],
        "operationId": "deleteAccountCustomIntegration",
        "summary": "Delete an custom integration",
        "responses": {
          "200": {
            "description": "The deleted custom integration",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/CustomIntegration"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          },
          "404": {
            "$ref": "#/components/responses/NotFoundError"
          },
          "500": {
            "$ref": "#/components/responses/InternalServerError"
          }
        }
      }
    },
    "/account/api/token": {
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "getAPIToken",
        "summary": "Generate an access token using an API client",
        "requestBody": {
          "description": "Client ID and secret",
          "required": true,
          "content": {
            "application/x-www-form-urlencoded": {
              "schema": {
                "$ref": "#/components/schemas/ClientIDForm"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "An access token",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/AccessToken"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/account/api/rotate": {
      "post": {
        "tags": [
          "Account"
        ],
        "operationId": "rotateAPIToken",
        "summary": "Rotate the API client secret",
        "requestBody": {
          "description": "Client ID and secret",
          "required": true,
          "content": {
            "application/x-www-form-urlencoded": {
              "schema": {
                "$ref": "#/components/schemas/ClientIDForm"
              }
            }
          }
        },
        "responses": {
          "200": {
            "description": "Client details with an updated api_client_secret value",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/APIClient"
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets/sync/created/assets.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Splunk"
        ],
        "operationId": "splunkAssetSyncCreatedJSON",
        "summary": "Exports the asset inventory in a sync-friendly manner using created_at as a checkpoint. Requires the Splunk entitlement.",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "fields",
            "description": "an optional list of fields to export, comma-separated",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "since",
            "description": "an optional unix timestamp to use as a checkpoint",
            "required": false,
            "schema": {
              "type": "integer",
              "format": "int64",
              "example": 1576300370
            }
          }
        ],
        "responses": {
          "200": {
            "description": "filtered asset results with a checkpoint wrapper",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/AssetsWithCheckpoint"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets/sync/updated/assets.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Splunk"
        ],
        "operationId": "splunkAssetSyncUpdatedJSON",
        "summary": "Exports the asset inventory in a sync-friendly manner using updated_at as a checkpoint. Requires the Splunk entitlement.",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "fields",
            "description": "an optional list of fields to export, comma-separated",
            "required": false,
            "schema": {
              "type": "string"
            }
          },
          {
            "in": "query",
            "name": "since",
            "description": "an optional unix timestamp to use as a checkpoint",
            "required": false,
            "schema": {
              "type": "integer",
              "format": "int64",
              "example": 1576300370
            }
          }
        ],
        "responses": {
          "200": {
            "description": "filtered asset results with a checkpoint wrapper",
            "content": {
              "application/json": {
                "schema": {
                  "$ref": "#/components/schemas/AssetsWithCheckpoint"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets.servicenow.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "ServiceNow"
        ],
        "operationId": "snowExportAssetsCSV",
        "summary": "Export an asset inventory as CSV for ServiceNow integration",
        "responses": {
          "200": {
            "description": "asset export",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets.servicenow.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "ServiceNow"
        ],
        "operationId": "snowExportAssetsJSON",
        "summary": "Exports the asset inventory as JSON",
        "responses": {
          "200": {
            "description": "filtered asset results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetServiceNow"
                  }
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/services.servicenow.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "ServiceNow"
        ],
        "operationId": "snowExportServicesCSV",
        "summary": "Export a service inventory as CSV for ServiceNow integration",
        "responses": {
          "200": {
            "description": "services export",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    },
    "/export/org/assets.servicegraph.json": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "ServiceNow"
        ],
        "operationId": "snowServiceGraphExportAssetsJSON",
        "summary": "Exports the asset inventory as JSON",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "filtered asset results",
            "content": {
              "application/json": {
                "schema": {
                  "type": "array",
                  "items": {
                    "$ref": "#/components/schemas/AssetServiceNow"
                  }
                }
              }
            }
          },
          "400": {
            "$ref": "#/components/responses/InvalidRequestBodyError"
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          },
          "403": {
            "$ref": "#/components/responses/NotAllowedForLicenseError"
          }
        }
      }
    },
    "/export/org/assets.cisco.csv": {
      "parameters": [
        {
          "$ref": "#/components/parameters/orgID"
        }
      ],
      "get": {
        "tags": [
          "Cisco SNTC"
        ],
        "operationId": "exportAssetsCiscoCSV",
        "summary": "Cisco serial number and model name export for Cisco Smart Net Total Care Service.",
        "parameters": [
          {
            "in": "query",
            "name": "search",
            "description": "an optional search string for filtering results",
            "required": false,
            "schema": {
              "type": "string"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "filtered asset results",
            "content": {
              "text/csv": {
                "schema": {
                  "type": "string",
                  "format": "binary"
                }
              }
            }
          },
          "401": {
            "$ref": "#/components/responses/UnauthorizedError"
          }
        }
      }
    }
  },
  "components": {
    "parameters": {
      "orgID": {
        "in": "query",
        "name": "_oid",
        "required": false,
        "schema": {
          "type": "string"
        },
        "description": "The current Organization"
      },
      "search": {
        "in": "query",
        "name": "search",
        "required": false,
        "schema": {
          "type": "string"
        },
        "description": "A search query in runZero search query syntax"
      },
      "fields": {
        "in": "query",
        "name": "fields",
        "required": false,
        "schema": {
          "type": "string"
        },
        "description": "A list of fields to export, comma-separated"
      },
      "pageSize": {
        "in": "query",
        "name": "page_size",
        "required": false,
        "schema": {
          "type": "integer"
        },
        "description": "The number of results to return per request."
      },
      "startKey": {
        "in": "query",
        "name": "start_key",
        "required": false,
        "schema": {
          "type": "string"
        },
        "description": "The value to use for requesting the next page when requesting paginated results.  This should be the value of the `next_key` attribute returned in the previous response."
      }
    },
    "securitySchemes": {
      "bearerAuth": {
        "type": "http",
        "scheme": "bearer"
      },
      "oauthDefaults": {
        "type": "oauth2",
        "flows": {
          "clientCredentials": {
            "tokenUrl": "https://console.runzero.com/api/v1.0/account/api/token",
            "scopes": {}
          }
        }
      }
    },
    "responses": {
      "UnauthorizedError": {
        "description": "Access token is missing or invalid",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "LicenseExpiredError": {
        "description": "License has expired",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "ProcessingError": {
        "description": "Request could not be processed",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "NotFoundError": {
        "description": "Resource not found",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "InternalServerError": {
        "description": "Unexpected error occurred on the server",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "NotAllowedForLicenseError": {
        "description": "Action not allowed for this license type",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "InvalidRequestBodyError": {
        "description": "Invalid request body",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "InvalidRequestParamError": {
        "description": "Invalid request parameter",
        "content": {
          "application/json": {
            "schema": {
              "$ref": "#/components/schemas/Problem"
            }
          }
        }
      },
      "StatusMessage": {
        "description": "Summary of operation results"
      }
    },
    "schemas": {
      "StatusMessage": {
        "type": "object"
      },
      "Problem": {
        "description": "RFC7807 Problem JSON object from https://opensource.zalando.com/restful-api-guidelines/models/problem-1.0.1.yaml without the standard 'type' and 'instance' fields.\n",
        "type": "object",
        "properties": {
          "title": {
            "type": "string",
            "description": "A short summary of the problem type. Written in English and readable for engineers, usually not suited for non technical stakeholders and not localized.\n",
            "example": "A short summary of the problem type."
          },
          "status": {
            "type": "integer",
            "format": "int32",
            "description": "The HTTP status code generated by the origin server for this occurrence of the problem.\n",
            "minimum": 100,
            "maximum": 600,
            "exclusiveMaximum": true
          },
          "detail": {
            "type": "string",
            "description": "A human readable explanation specific to this occurrence of the problem that is helpful to locate the problem and give advice on how to proceed. Written in English and readable for engineers, usually not suited for non technical stakeholders and not localized.\n",
            "example": "A human readable explanation specific to this occurrence of the problem."
          }
        }
      },
      "AWSCredentialFields": {
        "type": "object",
        "required": [
          "access_key",
          "secret_access_key"
        ],
        "properties": {
          "access_key": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "secret_access_key": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "regions": {
            "type": "string",
            "format": "string",
            "example": "us-west-1, us-east-2"
          },
          "use_cross_account_org": {
            "type": "string",
            "format": "string",
            "example": "true"
          },
          "role": {
            "type": "string",
            "format": "string",
            "example": "runzero-role"
          }
        }
      },
      "AzureClientSecretCredentialFields": {
        "type": "object",
        "required": [
          "client_id",
          "client_secret",
          "tenant_id",
          "environment"
        ],
        "properties": {
          "client_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_secret": {
            "type": "string",
            "format": "string",
            "example": "abcde~abcdefghiklmnopqrstuvwx_yz123456-7"
          },
          "tenant_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "environment": {
            "type": "string",
            "format": "string",
            "example": "global",
            "enum": [
              "global",
              "gcc",
              "gcc_high",
              "dod"
            ]
          },
          "multi_subscription": {
            "type": "string",
            "format": "string",
            "example": "true"
          },
          "subscription_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          }
        }
      },
      "AzureUsernamePasswordCredentialFields": {
        "type": "object",
        "required": [
          "client_id",
          "tenant_id",
          "username",
          "password"
        ],
        "properties": {
          "client_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "tenant_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "username": {
            "type": "string",
            "format": "string",
            "example": "user@example.com"
          },
          "password": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          }
        }
      },
      "CensysCredentialFields": {
        "type": "object",
        "required": [
          "client_id",
          "client_secret"
        ],
        "properties": {
          "client_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_secret": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "api_url": {
            "type": "string",
            "format": "string",
            "example": "https://search.censys.io"
          }
        }
      },
      "Certificate": {
        "type": "object",
        "required": [
          "id",
          "organization_id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "type": {
            "type": "string",
            "enum": [
              "x509",
              "ssh"
            ]
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "description": "When the certificate was last seen in a response from a service, and updated.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "names": {
            "type": "array",
            "description": "An assembled list of all names in the certificate.",
            "items": {
              "type": "string",
              "example": "CN=server,OU=Dept,O=Company"
            }
          },
          "self_signed": {
            "description": "Whether the certificate appears to be self-signed based on subject and authority.",
            "type": "boolean"
          },
          "hidden": {
            "description": "Whether the certificate has been hidden from the default certificates view.",
            "type": "boolean"
          },
          "serial": {
            "description": "The serial number of the certificate.",
            "type": "string",
            "format": "string",
            "example": "03beffa48e31b95581b0ebb0b1b3fe5ada9c"
          },
          "validity_start": {
            "description": "When the certificate becomes valid.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "validity_end": {
            "description": "When the certificate ceases to be valid.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "public_key": {
            "type": "string",
            "format": "base64"
          },
          "public_key_bits": {
            "type": "integer",
            "format": "int32",
            "example": 2048
          },
          "public_key_algorithm": {
            "type": "string",
            "format": "string",
            "example": "rsaEncryption"
          },
          "signature": {
            "type": "string",
            "format": "base64"
          },
          "signature_algorithm": {
            "type": "string",
            "format": "string",
            "example": "sha256WithRSAEncryption"
          },
          "fp_bkhash": {
            "description": "The badkeys hash.",
            "type": "string",
            "format": "string"
          },
          "fp_sha1": {
            "description": "The SHA1 hash of the certificate.",
            "type": "string",
            "format": "string"
          },
          "fp_sha256": {
            "description": "The SHA256 hash of the certificate.",
            "type": "string",
            "format": "string"
          },
          "fp_md5": {
            "description": "The MD5 hash of the certificate (for SSH).",
            "type": "string",
            "format": "string"
          },
          "subject": {
            "description": "The subject of the certificate.",
            "type": "string",
            "format": "dn"
          },
          "cn": {
            "description": "The Common Name field from the certificate (no longer used by web browsers).",
            "type": "string",
            "format": "string",
            "example": "www.example.com"
          },
          "version": {
            "description": "The version of the certificate.",
            "type": "integer",
            "format": "int32"
          },
          "issuer": {
            "description": "The authority which issued the certificate.",
            "type": "string",
            "format": "dn"
          },
          "subject_key_id": {
            "description": "The key ID of the subject of the certificate.",
            "type": "string",
            "format": "string"
          },
          "authority_key_id": {
            "description": "The key ID of the authority which signed the certificate.",
            "type": "string",
            "format": "string"
          },
          "ocsp_server": {
            "description": "Zero or more OCSP server URLs.",
            "type": "array",
            "items": {
              "type": "string",
              "format": "url"
            }
          },
          "crl_distribution_points": {
            "description": "Zero or more URLs of CRLs.",
            "type": "array",
            "items": {
              "type": "string",
              "format": "url"
            }
          },
          "issuing_certificate_url": {
            "description": "Zero or more URLs where the issuing certificate can be found.",
            "type": "array",
            "items": {
              "type": "string",
              "format": "url"
            }
          },
          "is_ca": {
            "description": "Whether the certificate claims to be a Certificate Authority.",
            "type": "boolean"
          },
          "key_usage": {
            "description": "Valid purposes the certificate's key can be used for.",
            "type": "array",
            "items": {
              "type": "string"
            }
          },
          "ext_key_usage": {
            "description": "Additional purposes the certificate's key can be used for.",
            "type": "array",
            "items": {
              "type": "string"
            }
          },
          "san_dns_names": {
            "description": "Subject Alternative Name hostnames.",
            "type": "array",
            "items": {
              "type": "string",
              "format": "hostname"
            }
          },
          "san_ip_addresses": {
            "description": "Subject Alternative Name IP addresses.",
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ]
            }
          },
          "san_email_addresses": {
            "description": "Subject Alternative Name email addresses.",
            "items": {
              "type": "string",
              "format": "email"
            }
          },
          "san_uris": {
            "description": "Subject Alternative Name URIs.",
            "items": {
              "type": "string",
              "format": "uri"
            }
          },
          "public_key_parameters": {
            "description": "Parameters specific to the public key type.",
            "type": "object"
          }
        }
      },
      "CrowdstrikeCredentialFields": {
        "type": "object",
        "required": [
          "client_id",
          "client_secret",
          "api_url"
        ],
        "properties": {
          "client_id": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_secret": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "api_url": {
            "type": "string",
            "format": "string",
            "example": "example.crowdstrike.com"
          }
        }
      },
      "CustomIntegrationScriptCredentialFields": {
        "type": "object",
        "required": [
          "access_key",
          "access_secret"
        ],
        "properties": {
          "access_key": {
            "type": "string",
            "format": "string"
          },
          "access_secret": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "Finding": {
        "type": "object",
        "required": [
          "id",
          "organization_id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid"
          },
          "category": {
            "type": "string",
            "format": "string"
          },
          "organization_id": {
            "type": "string",
            "format": "uuid"
          },
          "finding_code": {
            "description": "A runZero-assigned code for the finding.",
            "type": "string"
          },
          "name": {
            "description": "The title of the finding.",
            "type": "string"
          },
          "description": {
            "description": "Additional information about the finding.",
            "type": "string"
          },
          "solution": {
            "description": "Remediation information.",
            "type": "string"
          },
          "links": {
            "type": "object",
            "properties": {
              "cves": {
                "type": "array",
                "items": {
                  "type": "object",
                  "properties": {
                    "title": {
                      "type": "string"
                    },
                    "url": {
                      "type": "string"
                    }
                  }
                }
              },
              "rz_blog": {
                "description": "URLs of relevant runZero blog postings.",
                "type": "array",
                "items": {
                  "type": "object",
                  "properties": {
                    "title": {
                      "type": "string"
                    },
                    "url": {
                      "type": "string"
                    }
                  }
                }
              },
              "urls": {
                "description": "Additional relevant URLs.",
                "type": "array",
                "items": {
                  "type": "object",
                  "properties": {
                    "title": {
                      "type": "string"
                    },
                    "url": {
                      "type": "string"
                    }
                  }
                }
              }
            }
          },
          "created_at": {
            "type": "integer",
            "format": "int64"
          },
          "updated_at": {
            "type": "integer",
            "format": "int64"
          },
          "last_detected_at": {
            "type": "integer",
            "format": "int64"
          },
          "instance_count": {
            "type": "integer",
            "format": "int64"
          },
          "risk_rank": {
            "type": "string"
          },
          "risk_rank_value": {
            "description": "0 = info, 4 = critical",
            "type": "integer",
            "format": "int32",
            "minimum": 0,
            "maximum": 4
          }
        }
      },
      "GCPCredentialFields": {
        "type": "object",
        "properties": {
          "cross_project": {
            "type": "string",
            "format": "string",
            "example": "false"
          },
          "auth_provider_x509_cert_url": {
            "type": "string",
            "format": "string",
            "example": "https://www.googleapis.com/oauth2/v1/certs"
          },
          "auth_uri": {
            "type": "string",
            "format": "string",
            "example": "https://accounts.google.com/o/oauth2/auth"
          },
          "client_email": {
            "type": "string",
            "format": "string",
            "example": "example@example.iam.gserviceaccount.com"
          },
          "client_id": {
            "type": "string",
            "format": "string",
            "example": "111111111111111111111"
          },
          "client_x509_cert_url": {
            "type": "string",
            "format": "string",
            "example": "https://www.googleapis.com/robot/v1/metadata/x509/example.iam.gserviceaccount.com"
          },
          "private_key": {
            "type": "string",
            "format": "string",
            "description": "base64 encoded private key, beginning with -----BEGIN PRIVATE KEY-----"
          },
          "private_key_id": {
            "type": "string",
            "format": "string",
            "example": "1111111111111111111111111111111111111111"
          },
          "project_id": {
            "type": "string",
            "format": "string",
            "example": "example"
          },
          "token_uri": {
            "type": "string",
            "format": "string",
            "example": "https://oauth2.googleapis.com/token"
          },
          "type": {
            "type": "string",
            "format": "string",
            "example": "service_account"
          },
          "universe_domain": {
            "type": "string",
            "format": "string",
            "example": "googleapis.com"
          }
        }
      },
      "GoogleWorkspaceCredentialFields": {
        "type": "object",
        "required": [
          "delegate"
        ],
        "properties": {
          "delegate": {
            "type": "string",
            "format": "string",
            "example": "adminexample@example.com"
          },
          "customer_id": {
            "type": "string",
            "format": "string"
          },
          "auth_provider_x509_cert_url": {
            "type": "string",
            "format": "string",
            "example": "https://www.googleapis.com/oauth2/v1/certs"
          },
          "auth_uri": {
            "type": "string",
            "format": "string",
            "example": "https://accounts.google.com/o/oauth2/auth"
          },
          "client_email": {
            "type": "string",
            "format": "string",
            "example": "example@example.iam.gserviceaccount.com"
          },
          "client_id": {
            "type": "string",
            "format": "string",
            "example": "111111111111111111111"
          },
          "client_x509_cert_url": {
            "type": "string",
            "format": "string",
            "example": "https://www.googleapis.com/robot/v1/metadata/x509/example.iam.gserviceaccount.com"
          },
          "private_key": {
            "type": "string",
            "format": "string",
            "description": "base64 encoded private key, beginning with -----BEGIN PRIVATE KEY-----"
          },
          "private_key_id": {
            "type": "string",
            "format": "string",
            "example": "1111111111111111111111111111111111111111"
          },
          "project_id": {
            "type": "string",
            "format": "string",
            "example": "example"
          },
          "token_uri": {
            "type": "string",
            "format": "string",
            "example": "https://oauth2.googleapis.com/token"
          },
          "type": {
            "type": "string",
            "format": "string",
            "example": "service_account"
          },
          "universe_domain": {
            "type": "string",
            "format": "string",
            "example": "googleapis.com"
          }
        }
      },
      "InsightVMCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "username",
          "password"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string",
            "example": "https://ivm.example:3780"
          },
          "username": {
            "type": "string",
            "format": "string",
            "example": "admin"
          },
          "password": {
            "type": "string",
            "format": "string",
            "example": "pass"
          },
          "insecure": {
            "type": "string",
            "format": "string",
            "example": "true"
          },
          "thumbprints": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "LDAPCredentialFields": {
        "type": "object",
        "required": [
          "username",
          "password",
          "base_dn",
          "url"
        ],
        "properties": {
          "url": {
            "type": "string",
            "format": "string",
            "example": "ldap://example.com:389"
          },
          "username": {
            "type": "string",
            "format": "string",
            "example": "admin"
          },
          "password": {
            "type": "string",
            "format": "string",
            "example": "pass"
          },
          "base_dn": {
            "type": "string",
            "format": "string",
            "example": "dc=example,dc=com"
          },
          "insecure": {
            "type": "string",
            "format": "string",
            "example": "true"
          },
          "legacy_tls": {
            "type": "string",
            "format": "string",
            "example": "false"
          },
          "thumbprints": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "MECMCredentialFields": {
        "type": "object",
        "required": [
          "db_connection_string"
        ],
        "properties": {
          "db_connection_string": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "MirakiCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "api_key"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "api_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "MiradoreCredentialFields": {
        "type": "object",
        "required": [
          "hostname",
          "api_key"
        ],
        "properties": {
          "hostname": {
            "type": "string",
            "format": "string",
            "example": "yourcompanyinc.online.miradore.com"
          },
          "api_key": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          }
        }
      },
      "NessusCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "access_key",
          "secret_key"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "access_key": {
            "type": "string",
            "format": "string"
          },
          "secret_key": {
            "type": "string",
            "format": "string"
          },
          "insecure": {
            "type": "string",
            "format": "string",
            "example": "false"
          },
          "thumbprints": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "NetboxCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "api_key"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "api_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "PaloAltoFirewallCredentialFields": {
        "type": "object",
        "required": [
          "api_key"
        ],
        "properties": {
          "api_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "QualysCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "username",
          "password"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "username": {
            "type": "string",
            "format": "string"
          },
          "password": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "SentinelOneCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "api_key"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "api_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "ShodanCredentialFields": {
        "type": "object",
        "required": [
          "api_key"
        ],
        "properties": {
          "api_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "SNMPv2CommunitiesCredentialFields": {
        "type": "object",
        "required": [
          "community"
        ],
        "properties": {
          "community": {
            "type": "string",
            "format": "string",
            "example": "public,private"
          }
        }
      },
      "SNMPv3CredentialFields": {
        "type": "object",
        "required": [
          "username"
        ],
        "properties": {
          "username": {
            "type": "string",
            "format": "string",
            "example": "user"
          },
          "context": {
            "type": "string",
            "format": "string",
            "example": "vlan-32"
          },
          "auth-protocol": {
            "type": "string",
            "format": "string",
            "example": "sha"
          },
          "auth-passphrase": {
            "type": "string",
            "format": "string",
            "example": "authpass"
          },
          "privacy-protocol": {
            "type": "string",
            "format": "string",
            "example": "aes"
          },
          "privacy-passphrase": {
            "type": "string",
            "format": "string",
            "example": "privpass"
          }
        }
      },
      "TaniumCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "api_token"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "api_token": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "TenableIoCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "access_key",
          "secret_key"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "access_key": {
            "type": "string",
            "format": "string"
          },
          "secret_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "TenableScCredentialFields": {
        "type": "object",
        "required": [
          "api_url",
          "access_key",
          "secret_key"
        ],
        "properties": {
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "access_key": {
            "type": "string",
            "format": "string"
          },
          "secret_key": {
            "type": "string",
            "format": "string"
          },
          "insecure": {
            "type": "string",
            "format": "string",
            "example": "false"
          },
          "thumbprints": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "VMwareCredentialFields": {
        "type": "object",
        "required": [
          "username",
          "password"
        ],
        "properties": {
          "username": {
            "type": "string",
            "format": "string",
            "example": "user"
          },
          "password": {
            "type": "string",
            "format": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "insecure": {
            "type": "string",
            "format": "string",
            "example": "true"
          },
          "thumbprints": {
            "type": "string",
            "format": "string",
            "example": "IP=SHA256:B64HASH"
          }
        }
      },
      "WizCredentialFields": {
        "type": "object",
        "required": [
          "client_id",
          "client_secret",
          "auth_url",
          "api_url"
        ],
        "properties": {
          "auth_url": {
            "type": "string",
            "format": "string",
            "example": "https://auth.app.wiz.io/"
          },
          "api_url": {
            "type": "string",
            "format": "string"
          },
          "client_id": {
            "type": "string",
            "format": "string"
          },
          "client_secret": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "X509CredentialFields": {
        "type": "object",
        "required": [
          "x509_certificate",
          "private_key"
        ],
        "properties": {
          "x509_certificate": {
            "type": "string",
            "format": "string"
          },
          "private_key": {
            "type": "string",
            "format": "string"
          }
        }
      },
      "ComponentVersion": {
        "type": "object",
        "description": "A component ID and version",
        "required": [
          "id",
          "version"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "string",
            "example": "agent"
          },
          "version": {
            "type": "string",
            "format": "string",
            "example": "1.0.0"
          }
        }
      },
      "HealthCheckResponse": {
        "type": "object",
        "description": "A health check response and version",
        "required": [
          "status",
          "version"
        ],
        "properties": {
          "status": {
            "type": "string",
            "format": "string",
            "example": "ok"
          },
          "version": {
            "type": "string",
            "format": "string",
            "example": "3.0.0"
          }
        }
      },
      "URL": {
        "description": "A URL to a resource",
        "type": "object",
        "required": [
          "url"
        ],
        "properties": {
          "url": {
            "type": "string",
            "format": "url",
            "example": "https://www.runzero.com/docs/"
          }
        }
      },
      "SampleOptions": {
        "description": "Options which can be set to create or modify traffic sampling.",
        "type": "object",
        "required": [
          "interfaces"
        ],
        "properties": {
          "explorer": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "agent": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "targets": {
            "type": "string",
            "example": "10.0.0.0/8 172.16.0.0/12 192.168.0.0/16"
          },
          "excludes": {
            "type": "string"
          },
          "tags": {
            "type": "string",
            "example": "owner=IT location=Texas"
          },
          "interfaces": {
            "type": "string",
            "example": "eth0,wlan0"
          }
        }
      },
      "ScanOptions": {
        "description": "Options which can be set to create or modify a scan.",
        "type": "object",
        "required": [
          "targets"
        ],
        "properties": {
          "targets": {
            "type": "string",
            "example": "defaults"
          },
          "excludes": {
            "type": "string"
          },
          "scan-name": {
            "type": "string",
            "example": "My Scan"
          },
          "scan-description": {
            "description": "A description of the scan.",
            "type": "string",
            "example": "Scan of Wireless"
          },
          "scan-template": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "scan-frequency": {
            "description": "A string time duration value representing execution frequency, if scheduled to repeat.",
            "type": "string",
            "enum": [
              "once",
              "hourly",
              "daily",
              "weekly",
              "monthly",
              "continuous"
            ],
            "example": "hourly"
          },
          "scan-start": {
            "description": "Unix timestamp value indicating when the template was created.",
            "type": "string",
            "example": "0"
          },
          "scan-tags": {
            "type": "string",
            "example": "owner=IT location=Texas"
          },
          "scan-grace-period": {
            "type": "string",
            "example": "4"
          },
          "agent": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "explorer": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "explorer-group-id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "hosted-zone-id": {
            "type": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "description": "The string 'auto' will use any available hosted zone. Otherwise, provide the string name (hostedzone1) or UUID (\"e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8\") of a hosted zone."
          },
          "hosted-zone-name": {
            "type": "string",
            "example": "auto",
            "description": "The string 'auto' will use any available hosted zone. Otherwise, provide the string name (hostedzone1) of the hosted zone."
          },
          "rate": {
            "type": "string",
            "example": "10000"
          },
          "max-host-rate": {
            "type": "string",
            "example": "100"
          },
          "passes": {
            "type": "string",
            "example": "3"
          },
          "max-attempts": {
            "type": "string",
            "example": "3"
          },
          "max-sockets": {
            "type": "string",
            "example": "500"
          },
          "max-group-size": {
            "type": "string",
            "example": "4096"
          },
          "max-ttl": {
            "type": "string",
            "example": "255"
          },
          "tos": {
            "type": "string",
            "example": "255"
          },
          "tcp-ports": {
            "type": "string",
            "example": "1-1000,5000-6000"
          },
          "tcp-excludes": {
            "type": "string",
            "example": "9500"
          },
          "screenshots": {
            "type": "string",
            "example": "true"
          },
          "nameservers": {
            "type": "string",
            "example": "8.8.8.8"
          },
          "subnet-ping": {
            "type": "string",
            "example": "true"
          },
          "subnet-ping-net-size": {
            "type": "string",
            "example": "256"
          },
          "subnet-ping-probes": {
            "type": "string",
            "description": "Optional subnet ping probe list as comma separated strings. The example shows possibilities.",
            "example": "arp, echo, syn, connect, netbios, snmp, ntp, sunrpc, ike, openvpn, mdns"
          },
          "subnet-ping-sample-rate": {
            "type": "string",
            "example": "3"
          },
          "host-ping": {
            "type": "string",
            "example": "false"
          },
          "host-ping-probes": {
            "type": "string",
            "description": "Optional host ping probe list as comma separated strings. The example shows possibilities.",
            "example": "arp, echo, syn, connect, netbios, snmp, ntp, sunrpc, ike, openvpn, mdns"
          },
          "probes": {
            "type": "string",
            "description": "Optional probe list, otherwise all probes are used",
            "example": "arp,bacnet,connect,dns,echo,ike,ipmi,mdns,memcache,mssql,natpmp,netbios,pca,rdns,rpcbind,sip,snmp,ssdp,syn,ubnt,wlan-list,wsd"
          }
        }
      },
      "ScanTemplateOptions": {
        "description": "Options which can be set to create a scan template.",
        "type": "object",
        "required": [
          "name",
          "organization_id",
          "global",
          "acl"
        ],
        "properties": {
          "name": {
            "description": "Name of the template.",
            "type": "string",
            "example": "My Scan Template"
          },
          "description": {
            "description": "Description of the template.",
            "type": "string",
            "example": "My Scan Template"
          },
          "organization_id": {
            "description": "The ID of the organization the template will be created in",
            "type": "string",
            "format": "uuid",
            "example": "f6cfb91a-52ea-4a86-bf9a-5a891a26f52b",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "params": {
            "description": "A number of scan parameter values. Currently there is no authoritative list of acceptable values. See existing templates for examples.",
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "global": {
            "description": "Whether the template is globally available to all organizations.",
            "type": "boolean",
            "example": false
          },
          "acl": {
            "description": "A map of IDs to strings which describe how the template may be accessed. Currently there is no authoritative list of acceptable values. See existing templates for examples.",
            "type": "object",
            "additionalProperties": true,
            "example": {
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8": "user"
            }
          }
        }
      },
      "ScanTemplate": {
        "description": "A scan task template",
        "type": "object",
        "required": [
          "id",
          "global",
          "organization_id",
          "acl"
        ],
        "properties": {
          "id": {
            "description": "ID of the template.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "name": {
            "description": "The name of the template.",
            "type": "string",
            "example": "My Scan Template"
          },
          "description": {
            "description": "The description of the template.",
            "type": "string",
            "example": "My Scan Template"
          },
          "client_id": {
            "description": "ID of the account which owns the template.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "organization_id": {
            "description": "ID of the organization the template is available in.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "agent_id": {
            "description": "ID of the explorer which may execute the template.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "site_id": {
            "description": "ID of the site the template is being used in.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "cruncher_id": {
            "description": "ID of the runZero cruncher the task is executing on.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "created_at": {
            "description": "Unix timestamp value indicating when the template was created.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "created_by": {
            "description": "The username of the account which created the template.",
            "type": "string",
            "example": "user@example.com"
          },
          "created_by_user_id": {
            "description": "The ID of the account which created the template.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "updated_at": {
            "description": "Unix timestamp value indicating when the template was last modified.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "type": {
            "description": "The type of task the template creates.",
            "type": "string",
            "example": "scan"
          },
          "status": {
            "description": "The status of the last task using the template.",
            "type": "string",
            "example": "processed"
          },
          "error": {
            "description": "The error message, if any, of the last task using the template.",
            "type": "string",
            "example": "agent unavailable"
          },
          "params": {
            "description": "A number of task parameter values. Currently there is no authoritative list of in-use values. See existing templates for examples.",
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "stats": {
            "description": "A map of statistics about the last task executed with the template. Currently there is no authoritative list of in-use values. See existing templates for examples.",
            "type": "object",
            "additionalProperties": true
          },
          "hidden": {
            "description": "A flag indicating whether the item is hidden from common view.",
            "type": "boolean",
            "example": false
          },
          "parent_id": {
            "description": "The ID of the parent entity of the task scheduled.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "recur": {
            "description": "A flag representing whether derived tasks are scheduled to repeat.",
            "type": "boolean",
            "example": false
          },
          "recur_frequency": {
            "description": "A string time duration value representing execution frequency, if scheduled to repeat. You may use\nvalues including as once, hourly, daily, weekly, monthly, continuous\n",
            "type": "string",
            "example": "hourly"
          },
          "start_time": {
            "description": "Unix timestamp representing the next execution time.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "recur_last": {
            "description": "Unix timestamp representing the last execution if scheduled to repeat.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "recur_next": {
            "description": "Unix timestamp representing the next execution if scheduled to repeat.",
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "recur_last_task_id": {
            "description": "The ID of the task that last executed if scheduled to repeat.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "grace_period": {
            "description": "Additional time beyond hard expiration deadline by which the task may still be allowed to execute.",
            "type": "string",
            "example": "4"
          },
          "custom_integration_id": {
            "description": "The ID of the custom integration source, if the last task executed with this template was an import of Asset Data.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "source_id": {
            "description": "The numeric ID of the data source, if the task executed with this template is a runZero scan or third party data connection import.",
            "type": "string",
            "example": "1"
          },
          "template_id": {
            "description": "The ID of the template.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "size_site": {
            "description": "The size in assets of the site the last task the template was executed against.",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "size_data": {
            "description": "The total size of result data of the last task the template was used with.",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "size_results": {
            "description": "The number of results in the last task the template was used with.",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "hosted_zone_id": {
            "description": "The ID of the hosted zone that ran the last task the template was used with.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "linked_task_count": {
            "description": "The number of tasks derived from the template.",
            "type": "integer",
            "format": "int32",
            "example": 1
          },
          "global": {
            "description": "Whether the template is globally available to all organizations.",
            "type": "boolean",
            "example": false
          },
          "acl": {
            "description": "A map of IDs to strings which describe how the template may be accessed. Currently there is no authoritative list of in-use values. See existing templates for examples.",
            "type": "object",
            "additionalProperties": true,
            "example": {
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8": "user"
            }
          }
        }
      },
      "AgentPatchedSettings": {
        "type": "object",
        "properties": {
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "settings": {
            "type": "object",
            "properties": {
              "max_concurrent_scans": {
                "type": "integer",
                "format": "int64",
                "example": 5
              }
            }
          }
        }
      },
      "Explorer": {
        "$ref": "#/components/schemas/Agent"
      },
      "ExplorerPatchedSettings": {
        "$ref": "#/components/schemas/AgentPatchedSettings"
      },
      "OrgOptions": {
        "type": "object",
        "properties": {
          "name": {
            "type": "string",
            "example": "My Organization"
          },
          "description": {
            "type": "string",
            "example": "Wobbly Widgets, Inc."
          },
          "parent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "expiration_assets_stale": {
            "type": "string",
            "format": "number",
            "example": "365"
          },
          "expiration_assets_offline": {
            "type": "string",
            "format": "number",
            "example": "365"
          },
          "expiration_integration_attributes": {
            "type": "string",
            "format": "number",
            "example": "365"
          },
          "expiration_scans": {
            "type": "string",
            "format": "number",
            "example": "365"
          },
          "expiration_vulnerabilities": {
            "type": "string",
            "format": "number",
            "example": "365"
          },
          "keep_latest_integration_attributes": {
            "type": "string",
            "example": "true"
          }
        }
      },
      "SiteOptions": {
        "type": "object",
        "required": [
          "name"
        ],
        "properties": {
          "name": {
            "type": "string",
            "example": "New Site"
          },
          "description": {
            "type": "string",
            "example": "County Office"
          },
          "scope": {
            "type": "string",
            "example": "192.168.10.0/24"
          },
          "excludes": {
            "type": "string",
            "example": "192.168.10.1"
          },
          "subnets": {
            "type": "object",
            "additionalProperties": true
          }
        }
      },
      "CredentialFields": {
        "oneOf": [
          {
            "$ref": "#/components/schemas/AWSCredentialFields"
          },
          {
            "$ref": "#/components/schemas/AzureClientSecretCredentialFields"
          },
          {
            "$ref": "#/components/schemas/AzureUsernamePasswordCredentialFields"
          },
          {
            "$ref": "#/components/schemas/CensysCredentialFields"
          },
          {
            "$ref": "#/components/schemas/CrowdstrikeCredentialFields"
          },
          {
            "$ref": "#/components/schemas/CustomIntegrationScriptCredentialFields"
          },
          {
            "$ref": "#/components/schemas/GCPCredentialFields"
          },
          {
            "$ref": "#/components/schemas/GoogleWorkspaceCredentialFields"
          },
          {
            "$ref": "#/components/schemas/InsightVMCredentialFields"
          },
          {
            "$ref": "#/components/schemas/LDAPCredentialFields"
          },
          {
            "$ref": "#/components/schemas/MECMCredentialFields"
          },
          {
            "$ref": "#/components/schemas/MirakiCredentialFields"
          },
          {
            "$ref": "#/components/schemas/MiradoreCredentialFields"
          },
          {
            "$ref": "#/components/schemas/NessusCredentialFields"
          },
          {
            "$ref": "#/components/schemas/NetboxCredentialFields"
          },
          {
            "$ref": "#/components/schemas/PaloAltoFirewallCredentialFields"
          },
          {
            "$ref": "#/components/schemas/QualysCredentialFields"
          },
          {
            "$ref": "#/components/schemas/SentinelOneCredentialFields"
          },
          {
            "$ref": "#/components/schemas/ShodanCredentialFields"
          },
          {
            "$ref": "#/components/schemas/SNMPv2CommunitiesCredentialFields"
          },
          {
            "$ref": "#/components/schemas/SNMPv3CredentialFields"
          },
          {
            "$ref": "#/components/schemas/TaniumCredentialFields"
          },
          {
            "$ref": "#/components/schemas/TenableIoCredentialFields"
          },
          {
            "$ref": "#/components/schemas/TenableScCredentialFields"
          },
          {
            "$ref": "#/components/schemas/VMwareCredentialFields"
          },
          {
            "$ref": "#/components/schemas/WizCredentialFields"
          },
          {
            "$ref": "#/components/schemas/X509CredentialFields"
          }
        ]
      },
      "CredentialOptions": {
        "type": "object",
        "properties": {
          "name": {
            "type": "string",
            "example": "credentials_name"
          },
          "type": {
            "type": "string",
            "enum": [
              "aws_access_secret",
              "azure_client_secret",
              "azure_username_password",
              "censys_search_api_key",
              "crowdstrike_api_key",
              "custom_integration_credential",
              "gcp_service_account_key",
              "google_workspace_client_secret",
              "insightvm_username_password",
              "ldap_username_password",
              "mecm_db_connection_string",
              "meraki_api_key",
              "miradore_api_key_v1",
              "nessus_access_secret",
              "netbox_api_key",
              "palo_alto_api_key",
              "qualys_username_password",
              "sentinelone_api_key",
              "shodan_api_key",
              "snmpv2_community",
              "snmpv3_credential",
              "tanium_api_token",
              "tenable_access_secret",
              "tenable_security_center_access_secret",
              "vmware_username_password",
              "wiz_client_secret",
              "x509_keypair"
            ],
            "example": "miradore_api_key_v1"
          },
          "acl": {
            "type": "object",
            "additionalProperties": true,
            "example": {
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8": "user",
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fe9": "none"
            }
          },
          "global": {
            "type": "boolean",
            "example": false
          },
          "cidrs": {
            "type": "string",
            "example": "10.0.0.17/32, 192.168.1.0/24"
          },
          "secret": {
            "$ref": "#/components/schemas/CredentialFields"
          }
        }
      },
      "APIKeyOptions": {
        "type": "object",
        "properties": {
          "comment": {
            "type": "string",
            "example": "Splunk integration key"
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          }
        }
      },
      "ExportTokenOptions": {
        "type": "object",
        "properties": {
          "comment": {
            "type": "string",
            "example": "Splunk export key"
          }
        }
      },
      "AssetsWithCheckpoint": {
        "type": "object",
        "required": [
          "since",
          "assets"
        ],
        "properties": {
          "since": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "assets": {
            "type": "array",
            "items": {
              "$ref": "#/components/schemas/Asset"
            }
          }
        }
      },
      "AssetComments": {
        "type": "object",
        "required": [
          "comments"
        ],
        "properties": {
          "comments": {
            "type": "string",
            "example": "Sales Laptop"
          }
        }
      },
      "AssetTags": {
        "type": "object",
        "required": [
          "tags"
        ],
        "properties": {
          "tags": {
            "type": "string",
            "example": "ThisTag=Value -OldTag"
          }
        }
      },
      "AssetCriticality": {
        "type": "object",
        "required": [
          "criticality"
        ],
        "properties": {
          "criticality": {
            "type": "string",
            "example": "high"
          }
        }
      },
      "AssetIDs": {
        "type": "object",
        "required": [
          "asset_ids"
        ],
        "properties": {
          "asset_ids": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "453C191F-644E-4EA8-9727-0E81E5275C35"
            }
          }
        }
      },
      "AssetTagsWithSearch": {
        "type": "object",
        "required": [
          "tags",
          "search"
        ],
        "properties": {
          "tags": {
            "type": "string",
            "example": "ThisTag=Value -OldTag"
          },
          "search": {
            "type": "string",
            "example": "alive:true and os:windows"
          }
        }
      },
      "AssetCriticalityWithSearch": {
        "type": "object",
        "required": [
          "criticality",
          "search"
        ],
        "properties": {
          "criticality": {
            "type": "string",
            "example": "high"
          },
          "search": {
            "type": "string",
            "example": "alive:true and os:windows"
          }
        }
      },
      "Search": {
        "type": "object",
        "required": [
          "search"
        ],
        "properties": {
          "search": {
            "type": "string",
            "example": "alive:true and os:windows"
          }
        }
      },
      "Asset": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "scanned": {
            "type": "boolean",
            "example": true
          },
          "alive": {
            "type": "boolean",
            "example": true
          },
          "first_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "detected_by": {
            "type": "string",
            "example": "icmp"
          },
          "type": {
            "type": "string",
            "example": "Server"
          },
          "os": {
            "type": "string",
            "example": "Ubuntu Linux"
          },
          "os_version": {
            "type": "string",
            "example": "18.04"
          },
          "hw": {
            "type": "string",
            "example": "Dell PowerEdge 2500"
          },
          "addresses": {
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ],
              "example": "192.168.0.1"
            }
          },
          "addresses_extra": {
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ],
              "example": "192.168.100.1"
            }
          },
          "macs": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "mac",
              "example": "11:22:33:44:55:66"
            }
          },
          "mac_vendors": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "Dell"
            }
          },
          "names": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "www"
            }
          },
          "domains": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "www"
            }
          },
          "service_count": {
            "type": "integer",
            "format": "int64",
            "example": 10
          },
          "service_count_tcp": {
            "type": "integer",
            "format": "int64",
            "example": 7
          },
          "service_count_udp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_arp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_icmp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "lowest_ttl": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "lowest_rtt": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "last_agent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "last_task_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "newest_mac": {
            "type": "string",
            "format": "mac",
            "example": "11:22:33:44:55:66"
          },
          "newest_mac_vendor": {
            "type": "string",
            "example": "Intel Corporate"
          },
          "newest_mac_age": {
            "type": "integer",
            "format": "int64",
            "example": 1304035200000000000
          },
          "comments": {
            "type": "string",
            "example": "File Server"
          },
          "service_ports_tcp": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "port",
              "example": "22"
            }
          },
          "service_ports_udp": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "port",
              "example": "53"
            }
          },
          "service_protocols": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "ssh"
            }
          },
          "service_products": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "bind"
            }
          },
          "org_name": {
            "type": "string",
            "example": "Test Labs"
          },
          "site_name": {
            "type": "string",
            "example": "Primary"
          },
          "agent_name": {
            "type": "string",
            "example": "LAPTOP-F4P1R6"
          },
          "tags": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "services": {
            "type": "object",
            "additionalProperties": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            }
          },
          "rtts": {
            "type": "object",
            "additionalProperties": true
          },
          "risk_rank": {
            "description": "-1 = none, 0 = info, 4 = critical",
            "type": "number",
            "format": "int32",
            "minimum": -1,
            "maximum": 4
          },
          "risk": {
            "type": "string",
            "format": "string",
            "example": "critical"
          },
          "credentials": {
            "type": "object",
            "additionalProperties": {
              "type": "string",
              "additionalProperties": {
                "type": "boolean"
              }
            }
          },
          "vulnerability_count": {
            "type": "number",
            "format": "int64"
          },
          "finding_count": {
            "type": "number",
            "format": "int64"
          },
          "eol_os": {
            "description": "OS main EOL date",
            "type": "number",
            "format": "int64"
          },
          "eol_os_ext": {
            "description": "OS extended support EOL date",
            "type": "number",
            "format": "int64"
          },
          "sources": {
            "description": "Sources used for asset data",
            "type": "array",
            "items": {
              "type": "string",
              "format": "string"
            }
          },
          "attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          }
        }
      },
      "Service": {
        "type": "object",
        "required": [
          "id",
          "service_id"
        ],
        "properties": {
          "service_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "service_asset_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "service_created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "service_updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "service_address": {
            "type": "string",
            "oneOf": [
              {
                "format": "ipv4"
              },
              {
                "format": "ipv6"
              }
            ],
            "example": "192.168.0.1"
          },
          "service_transport": {
            "type": "string",
            "example": "tcp"
          },
          "service_vhost": {
            "type": "string",
            "example": "www"
          },
          "service_port": {
            "type": "string",
            "format": "port",
            "example": "80"
          },
          "service_data": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "service_protocol": {
            "type": "string",
            "example": "http tls"
          },
          "service_summary": {
            "type": "string",
            "example": "Login Page"
          },
          "service_screenshot_link": {
            "type": "string"
          },
          "service_link": {
            "type": "string",
            "example": "http://192.168.0.1:80/"
          },
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "alive": {
            "type": "boolean",
            "example": true
          },
          "first_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "detected_by": {
            "type": "string",
            "example": "icmp"
          },
          "type": {
            "type": "string",
            "example": "Server"
          },
          "os": {
            "type": "string",
            "example": "Ubuntu Linux"
          },
          "os_version": {
            "type": "string",
            "example": "18.04"
          },
          "hw": {
            "type": "string",
            "example": "Dell PowerEdge 2500"
          },
          "addresses": {
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ],
              "example": "192.168.0.1"
            }
          },
          "addresses_extra": {
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ],
              "example": "192.168.100.1"
            }
          },
          "macs": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "mac",
              "example": "11:22:33:44:55:66"
            }
          },
          "mac_vendors": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "Dell"
            }
          },
          "names": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "www"
            }
          },
          "domains": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "CORPNET"
            }
          },
          "service_count": {
            "type": "integer",
            "format": "int64",
            "example": 10
          },
          "service_count_tcp": {
            "type": "integer",
            "format": "int64",
            "example": 7
          },
          "service_count_udp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_arp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_icmp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "lowest_ttl": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "lowest_rtt": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "last_agent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "last_task_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "newest_mac": {
            "type": "string",
            "format": "mac",
            "example": "11:22:33:44:55:66"
          },
          "newest_mac_vendor": {
            "type": "string",
            "example": "Intel Corporate"
          },
          "newest_mac_age": {
            "type": "integer",
            "format": "int64",
            "example": 1304035200000000000
          },
          "comments": {
            "type": "string",
            "example": "File Server"
          },
          "service_ports_tcp": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "port",
              "example": "22"
            }
          },
          "service_ports_udp": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "port",
              "example": "53"
            }
          },
          "service_ports_protocols": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "ssh"
            }
          },
          "service_ports_products": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "bind"
            }
          },
          "org_name": {
            "type": "string",
            "example": "Test Labs"
          },
          "site_name": {
            "type": "string",
            "example": "Primary"
          },
          "agent_name": {
            "type": "string",
            "example": "LAPTOP-F4P1R6"
          },
          "tags": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "services": {
            "type": "object",
            "additionalProperties": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            }
          },
          "rtts": {
            "type": "object",
            "additionalProperties": true
          },
          "credentials": {
            "type": "object",
            "additionalProperties": {
              "type": "string",
              "additionalProperties": {
                "type": "boolean"
              }
            }
          },
          "attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          }
        }
      },
      "Site": {
        "type": "object",
        "required": [
          "id",
          "name"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "name": {
            "type": "string",
            "example": "Primary"
          },
          "description": {
            "type": "string",
            "example": "Headquarters"
          },
          "scope": {
            "type": "string",
            "example": "192.168.0.0/24"
          },
          "excludes": {
            "type": "string",
            "example": "192.168.0.5"
          },
          "subnets": {
            "type": "object",
            "additionalProperties": true
          }
        }
      },
      "Wireless": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "last_agent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "last_task_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "essid": {
            "type": "string",
            "format": "uuid",
            "example": "Free WiFi"
          },
          "bssid": {
            "type": "string",
            "format": "mac",
            "example": "11:22:33:44:55:66"
          },
          "type": {
            "type": "string",
            "example": "infrastructure"
          },
          "authentication": {
            "type": "string",
            "example": "wpa2-psk"
          },
          "encryption": {
            "type": "string",
            "example": "aes"
          },
          "signal": {
            "type": "integer",
            "minimum": 0,
            "maximum": 100,
            "example": 99
          },
          "channels": {
            "type": "string",
            "example": "11, 158+1"
          },
          "interface": {
            "type": "string",
            "example": "wlan0"
          },
          "vendor": {
            "type": "string",
            "example": "Ubiquiti Networks"
          },
          "family": {
            "type": "string",
            "example": "223344"
          },
          "data": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "org_name": {
            "type": "string",
            "example": "Test Labs"
          },
          "site_name": {
            "type": "string",
            "example": "Primary"
          },
          "agent_name": {
            "type": "string",
            "example": "LAPTOP-F4P1R6"
          }
        }
      },
      "Software": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "software_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "software_asset_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "software_organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "software_source_id": {
            "type": "integer",
            "example": 1
          },
          "software_created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "software_updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "software_service_address": {
            "type": "string",
            "oneOf": [
              {
                "format": "ipv4"
              },
              {
                "format": "ipv6"
              }
            ],
            "example": "192.168.0.1"
          },
          "software_service_transport": {
            "type": "string",
            "example": "tcp"
          },
          "software_service_port": {
            "type": "integer",
            "format": "int64",
            "example": 80
          },
          "software_installed_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "software_installed_size": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "software_installed_from": {
            "type": "string"
          },
          "software_app_id": {
            "type": "string"
          },
          "software_part": {
            "type": "string",
            "example": "a"
          },
          "software_vendor": {
            "type": "string",
            "example": "OpenBSD"
          },
          "software_product": {
            "type": "string",
            "example": "OpenSSH"
          },
          "software_version": {
            "type": "string",
            "example": "8.3p1"
          },
          "software_update": {
            "type": "string"
          },
          "software_edition": {
            "type": "string"
          },
          "software_language": {
            "type": "string"
          },
          "software_sw_edition": {
            "type": "string"
          },
          "software_target_sw": {
            "type": "string"
          },
          "software_target_hw": {
            "type": "string"
          },
          "software_other": {
            "type": "string"
          },
          "software_cpe23": {
            "type": "string",
            "example": "cpe:/a:openbsd:openssh:8.2"
          },
          "software_attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          }
        }
      },
      "Vulnerability": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "vulnerability_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "vulnerability_asset_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "vulnerability_organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "vulnerability_source_id": {
            "type": "integer",
            "example": 1
          },
          "vulnerability_created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "vulnerability_updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "vulnerability_service_address": {
            "type": "string",
            "oneOf": [
              {
                "format": "ipv4"
              },
              {
                "format": "ipv6"
              }
            ],
            "example": "192.168.0.1"
          },
          "vulnerability_service_transport": {
            "type": "string",
            "example": "tcp"
          },
          "vulnerability_service_port": {
            "type": "integer",
            "format": "int64",
            "example": 80
          },
          "vulnerability_cpe23": {
            "type": "string",
            "example": "cpe:/o:cisco:ios"
          },
          "vulnerability_vuln_id": {
            "type": "string",
            "example": "103565"
          },
          "vulnerability_category": {
            "type": "string",
            "example": "Remote"
          },
          "vulnerability_name": {
            "type": "string",
            "example": "Cisco IOS Software DHCP Remote Code Execution Vulnerability"
          },
          "vulnerability_description": {
            "type": "string",
            "example": "The remote device is missing a vendor-supplied security patch."
          },
          "vulnerability_solution": {
            "type": "string",
            "example": "Upgrade to the relevant fixed version referenced in Cisco bug ID(s) CSCsm45390 and CSCuw77959."
          },
          "vulnerability_cve": {
            "type": "string",
            "example": "CVE-2017-12240"
          },
          "vulnerability_cvss2_base_score": {
            "type": "number",
            "format": "double",
            "example": 10
          },
          "vulnerability_cvss2_temporal_score": {
            "type": "number",
            "format": "double",
            "example": 8.7
          },
          "vulnerability_cvss3_base_score": {
            "type": "number",
            "format": "double",
            "example": 9.8
          },
          "vulnerability_cvss3_temporal_score": {
            "type": "number",
            "format": "double",
            "example": 9.4
          },
          "vulnerability_severity": {
            "type": "string",
            "example": "Critical"
          },
          "vulnerability_severity_score": {
            "type": "number",
            "format": "double",
            "example": 10
          },
          "vulnerability_risk": {
            "type": "string",
            "example": "High"
          },
          "vulnerability_risk_score": {
            "type": "number",
            "format": "double",
            "example": 7.4
          },
          "vulnerability_published_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "vulnerability_first_detected_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "vulnerability_last_detected_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "vulnerability_attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "alive": {
            "type": "boolean",
            "example": true
          },
          "first_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_seen": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "detected_by": {
            "type": "string",
            "example": "icmp"
          },
          "type": {
            "type": "string",
            "example": "Server"
          },
          "os": {
            "type": "string",
            "example": "Ubuntu Linux"
          },
          "os_version": {
            "type": "string",
            "example": "18.04"
          },
          "hw": {
            "type": "string",
            "example": "Dell PowerEdge 2500"
          },
          "addresses": {
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ],
              "example": "192.168.0.1"
            }
          },
          "addresses_extra": {
            "type": "array",
            "items": {
              "type": "string",
              "oneOf": [
                {
                  "format": "ipv4"
                },
                {
                  "format": "ipv6"
                }
              ],
              "example": "192.168.100.1"
            }
          },
          "macs": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "mac",
              "example": "11:22:33:44:55:66"
            }
          },
          "mac_vendors": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "Dell"
            }
          },
          "names": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "www"
            }
          },
          "domains": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "www"
            }
          },
          "service_count": {
            "type": "integer",
            "format": "int64",
            "example": 10
          },
          "service_count_tcp": {
            "type": "integer",
            "format": "int64",
            "example": 7
          },
          "service_count_udp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_arp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_icmp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "lowest_ttl": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "lowest_rtt": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "last_agent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "last_task_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "newest_mac": {
            "type": "string",
            "format": "mac",
            "example": "11:22:33:44:55:66"
          },
          "newest_mac_vendor": {
            "type": "string",
            "example": "Intel Corporate"
          },
          "newest_mac_age": {
            "type": "integer",
            "format": "int64",
            "example": 1304035200000000000
          },
          "comments": {
            "type": "string",
            "example": "File Server"
          },
          "service_ports_tcp": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "port",
              "example": "22"
            }
          },
          "service_ports_udp": {
            "type": "array",
            "items": {
              "type": "string",
              "format": "port",
              "example": "53"
            }
          },
          "service_ports_protocols": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "ssh"
            }
          },
          "service_ports_products": {
            "type": "array",
            "items": {
              "type": "string",
              "example": "bind"
            }
          },
          "org_name": {
            "type": "string",
            "example": "Test Labs"
          },
          "site_name": {
            "type": "string",
            "example": "Primary"
          },
          "agent_name": {
            "type": "string",
            "example": "LAPTOP-F4P1R6"
          },
          "tags": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "services": {
            "type": "object",
            "additionalProperties": {
              "type": "object",
              "additionalProperties": {
                "type": "string"
              }
            }
          },
          "rtts": {
            "type": "object",
            "additionalProperties": true
          },
          "credentials": {
            "type": "object",
            "additionalProperties": {
              "type": "string",
              "additionalProperties": {
                "type": "boolean"
              }
            }
          },
          "attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          }
        }
      },
      "DirectoryUser": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_user_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_user_organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_user_site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_user_source_id": {
            "type": "integer",
            "example": 1
          },
          "directory_user_created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "directory_user_updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "directory_user_user_id": {
            "type": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_user_group_ids": {
            "type": "array",
            "items": {
              "type": "string"
            },
            "example": [
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
            ]
          },
          "directory_user_display_name": {
            "type": "string",
            "example": "Jane Doe"
          },
          "directory_user_name": {
            "type": "string",
            "example": "CN=Jane Doe,OU=Employees,DC=example,DC=com"
          },
          "directory_user_first_name": {
            "type": "string",
            "example": "Jane"
          },
          "directory_user_last_name": {
            "type": "string",
            "example": "Doe"
          },
          "directory_user_description": {
            "type": "string",
            "example": "Example user"
          },
          "directory_user_email": {
            "type": "string",
            "format": "email",
            "example": "user@example.com"
          },
          "directory_user_email_normalized": {
            "type": "string",
            "format": "email",
            "example": "user@example.com"
          },
          "directory_user_phone": {
            "type": "string",
            "example": "555-555-5555"
          },
          "directory_user_title": {
            "type": "string",
            "example": "Software Engineer"
          },
          "directory_user_location": {
            "type": "string",
            "example": "Remote"
          },
          "directory_user_last_logon_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "directory_user_attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          }
        }
      },
      "DirectoryGroup": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_group_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_group_organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_group_site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_group_source_id": {
            "type": "integer",
            "example": 1
          },
          "directory_group_created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "directory_group_updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "directory_group_group_id": {
            "type": "string",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "directory_group_user_count": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "directory_group_name": {
            "type": "string",
            "example": "CN=Remote Desktop Users,CN=Builtin,DC=example,DC=com"
          },
          "directory_group_display_name": {
            "type": "string",
            "example": "Remote Desktop Users"
          },
          "directory_group_description": {
            "type": "string",
            "example": "Members in this group are granted the right to logon remotely"
          },
          "directory_group_email": {
            "type": "string",
            "format": "email",
            "example": "user@example.com"
          },
          "directory_group_email_normalized": {
            "type": "string",
            "format": "email",
            "example": "user@example.com"
          },
          "directory_group_attributes": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          }
        }
      },
      "Organization": {
        "type": "object",
        "required": [
          "id",
          "name"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "download_token": {
            "type": "string",
            "example": "DT11226D9EEEA2B035D42569585900"
          },
          "download_token_created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "name": {
            "type": "string",
            "example": "My Company"
          },
          "description": {
            "type": "string",
            "example": "All subdivisions of my company"
          },
          "inactive": {
            "type": "boolean",
            "example": false
          },
          "deactivated_at": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "service_count": {
            "type": "integer",
            "format": "int64",
            "example": 10
          },
          "service_count_tcp": {
            "type": "integer",
            "format": "int64",
            "example": 7
          },
          "service_count_udp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_arp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_icmp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "asset_count": {
            "type": "integer",
            "format": "int64",
            "example": 100
          },
          "project": {
            "type": "boolean",
            "example": false
          },
          "parent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "expiration_assets_stale": {
            "type": "integer",
            "format": "int64",
            "example": 365
          },
          "expiration_assets_offline": {
            "type": "integer",
            "format": "int64",
            "example": 365
          },
          "expiration_integration_attributes": {
            "type": "integer",
            "format": "int64",
            "example": 365
          },
          "expiration_scans": {
            "type": "integer",
            "format": "int64",
            "example": 365
          },
          "expiration_vulnerabilities": {
            "type": "integer",
            "format": "int64",
            "example": 365
          },
          "export_token": {
            "deprecated": true,
            "type": "string",
            "example": "ET11226D9EEEA2B035D42569585900"
          },
          "export_token_created_at": {
            "deprecated": true,
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "export_token_last_used_at": {
            "deprecated": true,
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "export_token_last_used_by": {
            "deprecated": true,
            "type": "string",
            "example": "127.0.0.1"
          },
          "export_token_counter": {
            "deprecated": true,
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "keep_latest_integration_attributes": {
            "type": "boolean",
            "example": true
          }
        }
      },
      "Credential": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "name": {
            "type": "string",
            "example": "credentials_name"
          },
          "type": {
            "type": "string",
            "enum": [
              "miradore_api_key_v1",
              "aws_access_secret",
              "crowdstrike_api_key",
              "azure_client_secret",
              "azure_username_password",
              "censys_search_api_key",
              "snmpv2_community",
              "snmpv3_credential",
              "vmware_username_password"
            ],
            "description": "The service the credentials are for."
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "created_by_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_by_email": {
            "type": "string",
            "format": "email",
            "example": "user@example.com"
          },
          "acl": {
            "type": "object",
            "additionalProperties": true,
            "example": {
              "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8": "user"
            }
          },
          "global": {
            "type": "boolean",
            "example": false
          },
          "cidrs": {
            "type": "array",
            "items": {
              "type": "string"
            },
            "example": [
              "10.0.0.47/32",
              "192.168.1.0/24"
            ]
          },
          "last_used_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_used_by_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          }
        }
      },
      "APIKey": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "created_by": {
            "type": "string",
            "format": "email",
            "example": "user@example.com"
          },
          "comment": {
            "type": "string",
            "example": "API key used for Splunk integration"
          },
          "last_used_at": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "last_used_ip": {
            "type": "string",
            "example": "127.0.0.1"
          },
          "last_used_ua": {
            "type": "string",
            "example": "curl/7.44.1"
          },
          "counter": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "usage_today": {
            "type": "integer",
            "format": "int64",
            "example": 100
          },
          "usage_limit": {
            "type": "integer",
            "format": "int64",
            "example": 10000
          },
          "token": {
            "type": "string",
            "example": "CTXXXXXXXXXXXXX"
          },
          "inactive": {
            "type": "boolean",
            "example": true
          },
          "type": {
            "type": "string",
            "example": "org"
          }
        }
      },
      "ExportToken": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "token": {
            "type": "string",
            "example": "ET11226D9EEEA2B035D42569585900"
          },
          "comment": {
            "type": "string",
            "example": "Export token used for Splunk integration"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_used_at": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "last_used_by": {
            "type": "string",
            "example": "127.0.0.1"
          },
          "counter": {
            "type": "integer",
            "format": "int64",
            "example": 0
          }
        }
      },
      "Agent": {
        "description": "A deployed service which performs scan tasks.\nExplorers may be referred to by their legacy name, Agents.\n",
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "host_id": {
            "type": "string",
            "example": "6f9e6fe52271da70962e007183c5c9c9"
          },
          "hub_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "name": {
            "type": "string",
            "example": "RUNZERO-AGENT"
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "last_checkin": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "os": {
            "type": "string",
            "example": "Windows"
          },
          "arch": {
            "type": "string",
            "example": "amd64"
          },
          "version": {
            "type": "string",
            "example": "1.2.3 (build 20191219224016) [fc50c5eefdc3ff5c60533c3c345d14d336396272]"
          },
          "external_ip": {
            "type": "string",
            "example": "1.1.1.1"
          },
          "internal_ip": {
            "type": "string",
            "oneOf": [
              {
                "format": "ipv4"
              },
              {
                "format": "ipv6"
              }
            ],
            "example": "192.168.0.1"
          },
          "system_info": {
            "type": "object",
            "additionalProperties": true
          },
          "connected": {
            "type": "boolean",
            "example": true
          },
          "inactive": {
            "type": "boolean",
            "example": false
          },
          "deactivated_at": {
            "type": "integer",
            "format": "int64",
            "example": 0
          }
        }
      },
      "TaskBase": {
        "description": "All fields of a Task with none required",
        "type": "object",
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "name": {
            "type": "string",
            "example": "Hourly Scan"
          },
          "description": {
            "type": "string",
            "example": "Scan the headquarters hourly"
          },
          "template_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "agent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "hosted_zone_id": {
            "description": "The ID of the Hosted Zone which executes the task. If the\n",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "cruncher_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "created_by": {
            "type": "string",
            "example": "user@example.com"
          },
          "created_by_user_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "custom_integration_id": {
            "description": "The ID of the custom integration source, if the last task executed with this template was an import of Asset Data.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "source_id": {
            "description": "The numeric ID of the data source, if the task executed with this template is a runZero scan or third party data connection import.",
            "type": "integer",
            "example": 1
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "type": {
            "type": "string",
            "example": "scan"
          },
          "status": {
            "type": "string",
            "example": "processed"
          },
          "error": {
            "type": "string",
            "example": "agent unavailable"
          },
          "params": {
            "type": "object",
            "additionalProperties": {
              "type": "string"
            }
          },
          "stats": {
            "type": "object",
            "additionalProperties": true
          },
          "hidden": {
            "type": "boolean",
            "example": false
          },
          "parent_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "recur": {
            "type": "boolean",
            "example": false
          },
          "recur_frequency": {
            "type": "string",
            "example": "hourly"
          },
          "start_time": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "recur_last": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "recur_next": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "recur_last_task_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          }
        }
      },
      "Task": {
        "description": "A task object",
        "required": [
          "id"
        ],
        "allOf": [
          {
            "$ref": "#/components/schemas/TaskBase"
          }
        ]
      },
      "TaskOptions": {
        "description": "Options which can be set to create or modify a task.",
        "properties": {
          "hosted_zone_name": {
            "type": "string",
            "example": "auto",
            "description": "The string 'auto' will use any available hosted zone. Otherwise, provide the string name (hostedzone1) of the hosted zone."
          }
        },
        "allOf": [
          {
            "$ref": "#/components/schemas/TaskBase"
          }
        ]
      },
      "HostedZone": {
        "description": "A hosted service which performs scan tasks. Hosted zones are only available to\nEnterprise customers.\n",
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "description": "The ID of the hosted zone",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "name": {
            "type": "string",
            "example": "zone1"
          },
          "enabled": {
            "description": "Whether the hosted zone is enabled",
            "type": "boolean",
            "example": true
          },
          "updated_at": {
            "description": "The last modification time of the hosted zone",
            "type": "string",
            "format": "date-time",
            "example": "2023-03-06T18:14:50.52Z"
          },
          "processor_id": {
            "description": "The processor ID assigned to the hosted zone",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "explorers_concurrency": {
            "description": "The number of concurrent explorer tasks that can be executed",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "explorers_total": {
            "description": "The number of explorers available in the zone",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "tasks_active": {
            "description": "The number of tasks executing in the zone",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "tasks_waiting": {
            "description": "The number of tasks waiting to execute in the zone",
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "organization_id": {
            "description": "The ID of the organization the hosted zone is assigned to",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          }
        }
      },
      "License": {
        "type": "object",
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "name": {
            "type": "string",
            "example": "My Company"
          },
          "activated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "license_type": {
            "type": "string",
            "example": "platform"
          },
          "license_expiration": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "license_max_assets": {
            "type": "integer",
            "format": "int64",
            "example": 1000000
          },
          "license_live_asset_count": {
            "type": "integer",
            "format": "int64",
            "example": 1000
          },
          "license_project_asset_count": {
            "type": "integer",
            "format": "int64",
            "example": 5000
          },
          "via_reseller": {
            "type": "boolean",
            "example": false
          },
          "phone": {
            "type": "string",
            "example": "512-555-5555"
          },
          "address_street": {
            "type": "string",
            "example": "1111 Main St"
          },
          "address_country": {
            "type": "string",
            "example": "US"
          },
          "address_city": {
            "type": "string",
            "example": "Austin"
          },
          "address_region": {
            "type": "string",
            "example": "Texas"
          },
          "address_postal": {
            "type": "string",
            "example": "78700"
          },
          "subscription_period_start": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "subscription_period_end": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "subscription_cancel_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "subscription_canceled_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "settings": {
            "type": "object",
            "additionalProperties": true
          },
          "sso_type": {
            "type": "string",
            "example": "saml20"
          },
          "sso_domain": {
            "type": "string",
            "example": "runzero.com"
          },
          "sso_mode": {
            "type": "string",
            "example": "required"
          },
          "sso_login_message": {
            "type": "string",
            "example": "Hello"
          },
          "sso_login_issuer_url": {
            "type": "string",
            "example": "https://accounts.google.com/o/saml2?idpid=issuer"
          },
          "sso_login_login_url": {
            "type": "string",
            "example": "https://accounts.google.com/o/saml2?idpid=login"
          },
          "sso_login_logout_url": {
            "type": "string",
            "example": "https://accounts.google.com/o/saml2?idpid=logout"
          },
          "sso_default_role": {
            "type": "string",
            "example": "viewer"
          },
          "partner": {
            "type": "string",
            "example": "runZero"
          }
        }
      },
      "Event": {
        "type": "object",
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "organization_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "site_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "action": {
            "type": "string",
            "example": "login"
          },
          "source_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "source_name": {
            "type": "string",
            "example": "SiteName"
          },
          "source_type": {
            "type": "string",
            "example": "api"
          },
          "target_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "target_name": {
            "type": "string",
            "example": "SiteName"
          },
          "target_type": {
            "type": "string",
            "example": "api"
          },
          "success": {
            "type": "boolean",
            "example": true
          },
          "details": {
            "type": "object",
            "additionalProperties": true
          },
          "state": {
            "type": "string",
            "example": "SiteName"
          },
          "processor_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "processed_at": {
            "type": "integer",
            "format": "int64",
            "example": 0
          }
        }
      },
      "User": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "name": {
            "type": "string",
            "example": "James Smith"
          },
          "first_name": {
            "type": "string",
            "example": "James"
          },
          "last_name": {
            "type": "string",
            "example": "Smith"
          },
          "email": {
            "type": "string",
            "example": "jsmith@example.com"
          },
          "client_admin": {
            "type": "boolean",
            "example": true
          },
          "org_default_role": {
            "type": "string",
            "example": "admin"
          },
          "org_roles": {
            "type": "object",
            "additionalProperties": true
          },
          "password_enabled_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "invite_token_expiration": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "reset_token_expiration": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "terms_agreed_as_of": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_login_ip": {
            "type": "string",
            "oneOf": [
              {
                "format": "ipv4"
              },
              {
                "format": "ipv6"
              }
            ],
            "example": "192.168.0.1"
          },
          "last_login_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "last_login_ua": {
            "type": "string",
            "example": "curl/1.0"
          },
          "last_activity_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "sso_only": {
            "type": "boolean",
            "example": false
          },
          "login_failures": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "actions": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "last_action_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "mfa_enabled": {
            "type": "boolean",
            "example": false
          }
        }
      },
      "Group": {
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "description": {
            "type": "string",
            "example": "Viewers Group"
          },
          "name": {
            "type": "string",
            "example": "Viewers"
          },
          "role_summary": {
            "type": "string",
            "example": "all:viewer"
          },
          "user_count": {
            "type": "integer",
            "format": "int64",
            "example": 2
          },
          "created_by_email": {
            "type": "string",
            "example": "jsmith@example.com"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "expires_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "org_default_role": {
            "type": "string",
            "example": "admin"
          },
          "org_roles": {
            "type": "object",
            "additionalProperties": true
          }
        }
      },
      "GroupPost": {
        "type": "object",
        "properties": {
          "description": {
            "type": "string",
            "example": "Viewers Group"
          },
          "name": {
            "type": "string",
            "example": "Viewers"
          },
          "expires_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "org_default_role": {
            "type": "string",
            "example": "admin"
          },
          "org_roles": {
            "type": "object",
            "additionalProperties": true,
            "example": {
              "1a5e612e-4d64-45fe-aa3e-afba5cf3b9bf": "viewer,",
              "fd6d6662-732b-4c4b-8331-051178994384": "admin"
            }
          }
        }
      },
      "GroupPut": {
        "type": "object",
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "description": {
            "type": "string",
            "example": "Viewers Group"
          },
          "name": {
            "type": "string",
            "example": "Viewers"
          },
          "expires_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "org_default_role": {
            "type": "string",
            "example": "admin"
          },
          "org_roles": {
            "type": "object",
            "additionalProperties": true,
            "example": {
              "1a5e612e-4d64-45fe-aa3e-afba5cf3b9bf": "viewer,",
              "fd6d6662-732b-4c4b-8331-051178994384": "admin"
            }
          }
        }
      },
      "GroupMapping": {
        "type": "object",
        "required": [
          "id",
          "group_id",
          "sso_attribute",
          "sso_value"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "f6cfb91a-52ea-4a86-bf9a-5a891a26f52b"
          },
          "group_id": {
            "type": "string",
            "format": "uuid",
            "example": "2b096711-4d28-4417-8635-64af4f62c1ae"
          },
          "group_name": {
            "type": "string",
            "example": "Viewers Group"
          },
          "sso_attribute": {
            "type": "string",
            "example": "basic-attribute"
          },
          "sso_value": {
            "type": "string",
            "example": "basic-attribute-value"
          },
          "description": {
            "type": "string",
            "example": "Maps basic-attribute to Viewers Group"
          },
          "created_by_email": {
            "type": "string",
            "example": "jsmith@example.com"
          },
          "created_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          },
          "updated_at": {
            "type": "integer",
            "format": "int64",
            "example": 1576300370
          }
        }
      },
      "UserOptions": {
        "type": "object",
        "properties": {
          "first_name": {
            "type": "string",
            "example": "James"
          },
          "last_name": {
            "type": "string",
            "example": "Smith"
          },
          "email": {
            "type": "string",
            "example": "jsmith@example.com"
          },
          "client_admin": {
            "type": "boolean",
            "example": true
          },
          "org_default_role": {
            "type": "string",
            "example": "admin"
          },
          "org_roles": {
            "type": "object",
            "additionalProperties": true
          }
        }
      },
      "UserInviteOptions": {
        "type": "object",
        "properties": {
          "first_name": {
            "type": "string",
            "example": "James"
          },
          "last_name": {
            "type": "string",
            "example": "Smith"
          },
          "email": {
            "type": "string",
            "example": "jsmith@example.com"
          },
          "client_admin": {
            "type": "boolean",
            "example": true
          },
          "org_default_role": {
            "type": "string",
            "example": "admin"
          },
          "org_roles": {
            "type": "object",
            "additionalProperties": true
          },
          "subject": {
            "type": "string",
            "example": "Welcome to runZero"
          },
          "message": {
            "type": "string",
            "example": "You have been invited to the runZero Network Discovery platform"
          }
        }
      },
      "AssetServiceNow": {
        "type": "object",
        "required": [
          "asset_id"
        ],
        "properties": {
          "asset_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "organization": {
            "type": "string",
            "example": "Headquarters"
          },
          "site": {
            "type": "string",
            "example": "Primary"
          },
          "detected_by": {
            "type": "string",
            "example": "icmp"
          },
          "type": {
            "type": "string",
            "example": "Server"
          },
          "sys_class_name": {
            "type": "string",
            "example": "cmdb_ci_iot"
          },
          "os_vendor": {
            "type": "string",
            "example": "Microsoft"
          },
          "os_product": {
            "type": "string",
            "example": "Windows 10"
          },
          "os_version": {
            "type": "string",
            "example": "1903"
          },
          "hw_vendor": {
            "type": "string",
            "example": "Dell"
          },
          "hw_product": {
            "type": "string",
            "example": "PowerEdge"
          },
          "hw_version": {
            "type": "string",
            "example": "2.0"
          },
          "ip_address": {
            "type": "string",
            "oneOf": [
              {
                "format": "ipv4"
              },
              {
                "format": "ipv6"
              }
            ],
            "example": "192.168.0.1"
          },
          "addresses_scope": {
            "type": "string",
            "example": "192.168.100.1;192.168.100.2"
          },
          "addresses_extra": {
            "type": "string",
            "example": "192.168.0.5;192.168.0.3"
          },
          "mac_address": {
            "type": "string",
            "format": "mac",
            "example": "11:22:33:44:55:66"
          },
          "mac_manufacturer": {
            "type": "string",
            "example": "Dell"
          },
          "newest_mac_age": {
            "type": "string",
            "example": "2020-01-01T00:00:00.000Z"
          },
          "macs": {
            "type": "string",
            "format": "mac",
            "example": "11:22:33:44:55:66"
          },
          "mac_vendors": {
            "type": "string",
            "example": "Dell"
          },
          "name": {
            "type": "string",
            "example": "www;server"
          },
          "tags": {
            "type": "string",
            "example": "owner=IT;location=Austin"
          },
          "domains": {
            "type": "string",
            "example": "runzero.com;runzero.local.lan"
          },
          "service_count": {
            "type": "integer",
            "format": "int64",
            "example": 10
          },
          "service_count_tcp": {
            "type": "integer",
            "format": "int64",
            "example": 7
          },
          "service_count_udp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_arp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "service_count_icmp": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "lowest_ttl": {
            "type": "integer",
            "format": "int64",
            "example": 0
          },
          "lowest_rtt": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "alive": {
            "type": "boolean",
            "example": true
          },
          "first_discovered": {
            "type": "string",
            "example": "2006-01-02T15:04:05.000Z"
          },
          "last_discovered": {
            "type": "string",
            "example": "2006-01-02T15:04:05.000Z"
          },
          "last_updated": {
            "type": "string",
            "example": "2006-01-02T15:04:05.000Z"
          },
          "comments": {
            "type": "string",
            "example": "File Server"
          }
        }
      },
      "AssetOwnershipType": {
        "type": "object",
        "required": [
          "id",
          "name"
        ],
        "properties": {
          "id": {
            "type": "string",
            "format": "uuid",
            "example": "f6cfb91a-52ea-4a86-bf9a-5a891a26f52b"
          },
          "name": {
            "type": "string",
            "example": "Asset Owner"
          },
          "reference": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "order": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "hidden": {
            "type": "boolean",
            "example": true
          }
        }
      },
      "AssetOwnershipTypePost": {
        "type": "object",
        "required": [
          "name"
        ],
        "properties": {
          "name": {
            "type": "string",
            "example": "Asset Owner"
          },
          "reference": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "order": {
            "type": "integer",
            "format": "int64",
            "example": 1
          },
          "hidden": {
            "type": "boolean",
            "example": true
          }
        }
      },
      "AssetOwnerships": {
        "type": "object",
        "properties": {
          "ownerships": {
            "type": "array",
            "items": {
              "type": "object",
              "properties": {
                "ownership_type_id": {
                  "type": "string",
                  "example": "2318e078-4164-4e1b-92a5-11e353093f4b"
                },
                "owner": {
                  "type": "string",
                  "example": "it@runzero.com"
                }
              }
            }
          }
        }
      },
      "AssetOwnershipsWithSearch": {
        "type": "object",
        "required": [
          "ownerships",
          "search"
        ],
        "properties": {
          "search": {
            "type": "string",
            "example": "alive:true and os:windows"
          },
          "ownerships": {
            "type": "array",
            "items": {
              "type": "object",
              "properties": {
                "ownership_type_id": {
                  "type": "string",
                  "example": "2318e078-4164-4e1b-92a5-11e353093f4b"
                },
                "owner": {
                  "type": "string",
                  "example": "it@runzero.com"
                }
              }
            }
          }
        }
      },
      "BaseResponse": {
        "description": "Minimal identifying information with lifecycle metadata",
        "type": "object",
        "required": [
          "id",
          "clientId",
          "createdAt",
          "createdById",
          "updatedAt"
        ],
        "properties": {
          "id": {
            "description": "The unique ID of the object",
            "type": "string",
            "format": "uuid",
            "example": "f6cfb91a-52ea-4a86-bf9a-5a891a26f52b",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "clientId": {
            "description": "The unique ID of the runZero client/customer account that owns the object",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "createdById": {
            "description": "The unique ID of the entity that created the object",
            "type": "string",
            "format": "uuid",
            "example": "f6cfb91a-52ea-4a86-bf9a-5a891a26f52b",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "createdAt": {
            "description": "A timestamp indicating creation time of the object",
            "type": "string",
            "format": "date-time",
            "example": "2023-03-06T18:14:50.52Z"
          },
          "updatedAt": {
            "description": "A timestamp indicating last modified time of the object",
            "type": "string",
            "format": "date-time",
            "example": "2023-03-06T18:14:50.52Z"
          },
          "destroyedAt": {
            "description": "A timestamp indicating deletion time of the object",
            "type": "string",
            "format": "date-time",
            "example": "2023-03-06T18:14:50.52Z"
          }
        }
      },
      "BaseCustomIntegration": {
        "type": "object",
        "properties": {
          "name": {
            "description": "The unique name of the custom integration, without spaces.",
            "pattern": "^\\S+$",
            "type": "string",
            "example": "my-custom-integration"
          },
          "icon": {
            "description": "Base64 encoded png with maximum size 256x256 pixels",
            "type": "string",
            "format": "byte",
            "example": "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"
          },
          "description": {
            "description": "A text description of the custom integration",
            "type": "string",
            "example": "My custom integration description."
          }
        }
      },
      "CustomIntegration": {
        "required": [
          "name"
        ],
        "allOf": [
          {
            "$ref": "#/components/schemas/BaseCustomIntegration"
          },
          {
            "$ref": "#/components/schemas/BaseResponse"
          }
        ]
      },
      "NewCustomIntegration": {
        "required": [
          "name"
        ],
        "allOf": [
          {
            "$ref": "#/components/schemas/BaseCustomIntegration"
          }
        ]
      },
      "NewAssetImport": {
        "description": "Represents a request to import asset data described by the specified custom integration into the specified site.\n\nAssets will be created new or merged according to merge rules defined by the version of the platform\nyou are uploading the asset data file to. Typically, this involves matching network and other unique\nsingle or grouped properties.\n\nThere is a maximum of 256 custom asset properties that can be applied to any asset. This means\nthat, aside from the per-import asset property limit set on ImportAsset, if a new import sets\ndifferent custom properties on the same asset, the new properties are combined with the\npre-existing ones.\n",
        "type": "object",
        "required": [
          "assetData",
          "siteId",
          "customIntegrationId",
          "importTask"
        ],
        "properties": {
          "siteId": {
            "description": "The ID of the site assets are to be imported into.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "customIntegrationId": {
            "description": "The unique ID of the registered custom integration which produced the asset data. Uniqueness is not checked/enforced. See /account/custom-integrations api.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "importTask": {
            "title": "ImportTask",
            "description": "Information which describes the task created when asset data is imported.",
            "type": "object",
            "required": [
              "name"
            ],
            "properties": {
              "name": {
                "type": "string",
                "maxLength": 100,
                "example": "my import task"
              },
              "description": {
                "type": "string",
                "maxLength": 1024,
                "example": "importing assets from custom integration A"
              },
              "excludeUnknown": {
                "description": "Instructs the data ingestion process whether to skip assets which do not merge into an existing asset in the asset inventory",
                "type": "boolean",
                "default": false,
                "example": true
              },
              "tags": {
                "description": "Arbitrary string tag values which are applied to the asset data import task created.",
                "type": "array",
                "maxItems": 100,
                "items": {
                  "type": "string",
                  "maxLength": 1024
                },
                "example": [
                  "tag1",
                  "tag2"
                ]
              }
            }
          },
          "assetData": {
            "description": "A gzip (not .tar.gz) compressed file containing ImportAsset objects. The file data may be a JSON array of\nImportAsset objects, e.g. [{},{},...] or JSONL format, with a single JSON representation of an ImportAsset\nobject on each new line, e.g. {}\\n{}\\n...\n",
            "type": "string",
            "format": "binary"
          }
        }
      },
      "ImportAsset": {
        "description": "Represents a custom asset to be created or merged after import.",
        "type": "object",
        "required": [
          "id"
        ],
        "properties": {
          "id": {
            "description": "Any value which can uniquely identify the asset within the custom integration.",
            "maxLength": 1024,
            "type": "string"
          },
          "runZeroID": {
            "description": "The unique identifier of the runZero asset to merge into.",
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8",
            "x-go-type": "uuid.UUID",
            "x-go-import": {
              "name": "uuid",
              "path": "github.com/gofrs/uuid"
            }
          },
          "networkInterfaces": {
            "title": "NetworkInterfaces",
            "description": "The asset's networking configuration.",
            "type": "array",
            "maxItems": 256,
            "items": {
              "type": "object",
              "properties": {
                "ipv4Addresses": {
                  "description": "Represents IPV4 addresses. Addresses are ordered from most to least likely to uniquely identify the asset.",
                  "type": "array",
                  "maxItems": 256,
                  "items": {
                    "type": "string",
                    "format": "ipv4"
                  }
                },
                "ipv6Addresses": {
                  "description": "Represents the IPV6 addresses. Addresses are ordered from most to least likely to uniquely identify the asset.",
                  "type": "array",
                  "maxItems": 100,
                  "items": {
                    "type": "string",
                    "format": "ipv6"
                  }
                },
                "macAddress": {
                  "description": "Represents a MAC address in IEEE 802 MAC/EUI-48, or EUI-64 form in one of the following formats:\n  01:23:45:67:89:AB\n  01:23:45:67:89:ab:cd:ef\n  01-23-45-67-89-ab\n  01-23-45-67-89-ab-cd-ef\n  0123.4567.89ab\n  0123.4567.89ab.cdef\n  0123 4567 89ab cdEF\n",
                  "type": "string",
                  "maxLength": 23,
                  "example": "01:23:45:67:89:0A",
                  "pattern": "^([A-Fa-f0-9]{2}:){5}[A-Fa-f0-9]{2}$|^([A-Fa-f0-9]{2}:){7}[A-Fa-f0-9]{2}$|^([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}$|^([A-Fa-f0-9]{2}-){7}[A-Fa-f0-9]{2}$|^([A-Fa-f0-9]{4}\\.){2}[A-Fa-f0-9]{4}$|^([A-Fa-f0-9]{4}\\.){3}[A-Fa-f0-9]{4}$|^([A-Fa-f0-9]{4} ){3}[A-Fa-f0-9]{4}$"
                }
              }
            }
          },
          "hostnames": {
            "description": "Represents hostnames the asset is assigned or reachable at. These can be fully-qualified hostnames with the domain name, or a short hostname.",
            "type": "array",
            "maxItems": 100,
            "items": {
              "type": "string",
              "maxLength": 260,
              "example": "host.domain.com"
            }
          },
          "domain": {
            "description": "Represents a single domain name which could be applied to all non-fqdns in the hostnames field.",
            "type": "string",
            "maxLength": 260,
            "example": "domain.com"
          },
          "firstSeenTS": {
            "description": "Represents the earliest time the asset was seen by the custom integration reporting it, using a date string as defined by RFC 3339, section 5.6.",
            "type": "string",
            "format": "date-time",
            "example": "2023-03-06T18:14:50.52Z"
          },
          "os": {
            "description": "The name of the asset's operating system. It is advisable to keep the data clean by normalizing to existing values when possible.",
            "type": "string",
            "maxLength": 1024,
            "example": "Ubuntu Linux 22.04"
          },
          "osVersion": {
            "description": "The version of the asset's operating system. It is advisable to keep the data clean by normalizing to existing values when possible.",
            "type": "string",
            "maxLength": 1024,
            "example": "22.04"
          },
          "manufacturer": {
            "description": "The manufacturer of the operating system of the asset. It is advisable to keep the data clean by normalizing to existing values when possible.",
            "type": "string",
            "maxLength": 1024,
            "example": "Apple Inc."
          },
          "model": {
            "description": "The hardware model of the asset. It is advisable to keep the data clean by normalizing to existing values when possible.",
            "type": "string",
            "maxLength": 1024,
            "example": "Macbook Air"
          },
          "tags": {
            "description": "Arbitrary string tags applied to the asset.",
            "type": "array",
            "maxItems": 100,
            "items": {
              "type": "string",
              "maxLength": 1024
            },
            "example": [
              "foo",
              "key=value"
            ]
          },
          "deviceType": {
            "type": "string",
            "maxLength": 1024,
            "example": "Desktop"
          },
          "customAttributes": {
            "title": "CustomAttributes",
            "description": "Flat map of arbitrary string key/value pairs representing custom attribute data not described in properties above. Note the maximum number of keys and length of values. Additionally, property names may only be 256 characters long.",
            "type": "object",
            "maxProperties": 1024,
            "additionalProperties": {
              "anyOf": [
                {
                  "type": "string",
                  "maxLength": 1024
                }
              ]
            }
          }
        }
      },
      "AccessToken": {
        "type": "object",
        "properties": {
          "access_token": {
            "type": "string"
          },
          "token_type": {
            "type": "string"
          },
          "expires_in": {
            "type": "integer"
          }
        }
      },
      "APIClient": {
        "type": "object",
        "properties": {
          "api_client_id": {
            "type": "string",
            "format": "uuid",
            "example": "e77602e0-3fb8-4734-aef9-fbc6fdcb0fa8"
          },
          "api_client_secret": {
            "type": "string"
          }
        }
      },
      "ClientIDForm": {
        "type": "object",
        "required": [
          "grant_type",
          "client_id",
          "client_secret"
        ],
        "properties": {
          "grant_type": {
            "type": "string",
            "example": "client_credential"
          },
          "client_id": {
            "type": "string"
          },
          "client_secret": {
            "type": "string"
          }
        }
      }
    }
  }
},
    dom_id: '#swagger-ui',
    deepLinking: true,
    presets: [
      SwaggerUIBundle.presets.apis,
      SwaggerUIStandalonePreset
    ],
    plugins: [
      SwaggerUIBundle.plugins.DownloadUrl
    ],
    layout: "StandaloneLayout"
  });

  //</editor-fold>
};
