function [bmx, ALPHA, S, alpha] = hsmm_fwd_init_hsum(Data, m)
%Forward variable initialization
%Sylvain Calinon, 2014 

for i=1:size(m.Sigma,3)
  Btmp(i,1) = gaussPDF(Data, m.Mu(:,i), m.Sigma(:,:,i));
end
Btmp = Btmp / sum(Btmp);

ALPHA = repmat(m.StatesPriors, 1, size(m.Pd,2)) .* m.Pd; %Equation (13)
r = Btmp' * sum(ALPHA,2);	%Equation (3) 
bmx(:,1) = Btmp ./ r;	%Equation (2)
E(:,1) = bmx(:,1) .* ALPHA(:,1); %Equation (5)
S(:,1) = m.Trans' * E(:,1);	%Equation (6)

alpha = Btmp .* sum(ALPHA,2); %Forward variable

