function h = rescaledGMM_step(DataTmp,m)
% GMM weight with max-type rescaling (see Eq. (4) in the paper)
% Inputs -----------------------------------------------------------------
%   o Datatmp:    D x N array representing N datapoints of D dimensions.
%   o m      :    struct containing paramenters of the GMM:
%                 m.nbStates, m.Priors, m.Mu and m.Sigma. 
% Outputs ----------------------------------------------------------------
%   o h      :    rescaled GMM weights vector.
%
% Antonio Pistillo and Sylvain Calinon, 2011 

for i=1:m.nbStates
  Btmp(i) = gaussPDF(DataTmp,m.Mu(:,i),m.Sigma(:,:,i));
end

h = Btmp' ./ m.hMax'; %see Eq. (4) in the paper


