function h=plotGMM3D(Mu, Sigma, col1, alpha1)
%Sylvain Calinon, 2009

nbData = size(Mu,2);
nbpoints = 40;

for n=1:nbData

  stdev = sqrtm(1.0.*Sigma(:,:,n));

  [x,y,z] = sphere(nbpoints);
  x2 = reshape(x,[size(x,1)*size(x,2) 1]);
  y2 = reshape(y,[size(y,1)*size(y,2) 1]);
  z2 = reshape(z,[size(z,1)*size(z,2) 1]);

  D = [x2 y2 z2] * real(stdev) + repmat(Mu(:,n)',size(x2,1),1);
  X = reshape(D(:,1), [size(x,1) size(x,2)]);
  Y = reshape(D(:,2), [size(y,1) size(y,2)]);
  Z = reshape(D(:,3), [size(z,1) size(z,2)]);

  h(n) = surface(X,Y,Z);
  set(h(n), 'FaceColor', col1, 'EdgeColor', 'none','FaceAlpha', alpha1); 
  camlight('left');
  lighting('gouraud');
  material('metal');

  set(gca, 'AmbientLightColor', [0.75 0.75 0.75]);
  set(h(n), 'AmbientStrength', 0.7);
end