function [prodRes, pp] = computeResultingGaussians(model, pp)
% Computes the resulting Gaussians after projections in the different candidate frames and products of
% Gaussians estimation. 
% 
% Author:	Sylvain Calinon, 2013
%         http://programming-by-demonstration.org/SylvainCalinon

%Projections in the different candidate frames (see Eq. (3) Calinon et al, Humanoids'2012 paper)
for t=1:size(pp,2)
  for i=1:model.nbStates 
    for m=1:model.nbFrames 
      pp(m,t).Mu(:,i) = pp(m,t).A * model.ref(m).ZMu(:,i) + pp(m,t).b; 
      pp(m,t).Sigma(:,:,i) = pp(m,t).A * model.ref(m).ZSigma(:,:,i) * pp(m,t).A'; 
    end
  end
end

%GMM products (see Eq. (3) Calinon et al, Humanoids'2012 paper)
for t=1:size(pp,2)
  for i=1:model.nbStates 
    SigmaTmp = zeros(model.nbVar);
    MuTmp = zeros(model.nbVar,1);
    for m=1:model.nbFrames 
      pp(m,t).Mu(:,i) = pp(m,t).A * model.ref(m).ZMu(:,i) + pp(m,t).b; 
      pp(m,t).Sigma(:,:,i) = pp(m,t).A * model.ref(m).ZSigma(:,:,i) * pp(m,t).A'; 
      SigmaTmp = SigmaTmp + inv(pp(m,t).Sigma(:,:,i));
      MuTmp = MuTmp + inv(pp(m,t).Sigma(:,:,i))*pp(m,t).Mu(:,i); 
    end
    prodRes(t).invSigma(:,:,i) = SigmaTmp;
    prodRes(t).Sigma(:,:,i) = inv(SigmaTmp);
    prodRes(t).detSigma(i) = det(prodRes(t).Sigma(:,:,i));
    prodRes(t).Mu(:,i) = prodRes(t).Sigma(:,:,i) * MuTmp;
  end
end
