function model = init_proposedPGMM_kmeans(s, model)
% Initialization of the model with k-means 
%
% Author:	Sylvain Calinon, 2013
%         http://programming-by-demonstration.org/SylvainCalinon
%

nbSamples = length(s);

%Projections in the different candidate frames
DataAll = [];
for m=1:model.nbFrames
  DataTmp = [];
  for n=1:nbSamples
    if size(s(n).p,2)==1 %frame is fixed during each demonstration 
      DataTmp = [DataTmp inv(s(n).p(m).A) * (s(n).Data-repmat(s(n).p(m).b,1,s(n).nbData))];
    else %frame is moving during demonstration
      for t=1:s(n).nbData
        DataTmp = [DataTmp s(n).p(m,t).invA*(s(n).Data(:,t)-s(n).p(m,t).b)];
      end
    end
  end
  DataAll = [DataAll; DataTmp];
end

%k-means clustering 
[Data_id, Mu] = kmeansClustering(DataAll, model.nbStates);

for i=1:model.nbStates
  idtmp = find(Data_id==i);
  Priors(i) = length(idtmp);
  Sigma(:,:,i) = cov([DataAll(:,idtmp) DataAll(:,idtmp)]');
end
Priors = Priors ./ sum(Priors);

for m=1:model.nbFrames
  for i=1:model.nbStates
    model.ref(m).ZMu(:,i) = Mu((m-1)*model.nbVar+1:m*model.nbVar,i); 
    model.ref(m).ZSigma(:,:,i) = Sigma((m-1)*model.nbVar+1:m*model.nbVar,(m-1)*model.nbVar+1:m*model.nbVar,i); 
  end
end
model.Priors = Priors;

