function model = init_proposedPGMM_timeBased(s, model)
% Initialization of the model with clusters equally split in time.
%
% Author:	Sylvain Calinon, 2013
%         http://programming-by-demonstration.org/SylvainCalinon

diagRegularizationFactor=1E-4;
nbSamples = length(s);

DataAll = [];
for m=1:model.nbFrames
  DataTmp = [];
  for n=1:nbSamples
    if size(s(n).p,2)==1 %frame is fixed during each demonstration 
      DataTmp = [DataTmp inv(s(n).p(m).A)*(s(n).Data-repmat(s(n).p(m).b,1,s(n).nbData))];
    else %frame is moving during demonstration
      for t=1:s(n).nbData
        DataTmp = [DataTmp s(n).p(m,t).invA*(s(n).Data(:,t)-s(n).p(m,t).b)];
      end
    end
  end
  DataAll = [DataAll; DataTmp];
end

TimingSep = linspace(min(DataAll(1,:)), max(DataAll(1,:)), model.nbStates+1);
for i=1:model.nbStates
  idtmp = find( DataAll(1,:)>=TimingSep(i) & DataAll(1,:)<TimingSep(i+1));
  Priors(i) = length(idtmp);
  Mu(:,i) = mean(DataAll(:,idtmp)');
  Sigma(:,:,i) = cov(DataAll(:,idtmp)') + eye(size(DataAll,1)) * diagRegularizationFactor;
end
Priors = Priors / sum(Priors);

for m=1:model.nbFrames
  for i=1:model.nbStates
    model.ref(m).ZMu(:,i) = Mu((m-1)*model.nbVar+1:m*model.nbVar,i); 
    model.ref(m).ZSigma(:,:,i) = Sigma((m-1)*model.nbVar+1:m*model.nbVar,(m-1)*model.nbVar+1:m*model.nbVar,i); 
    %Regularization term (optional)
    model.ref(m).ZSigma(:,:,i) = model.ref(m).ZSigma(:,:,i) + eye(size(model.ref(m).ZSigma(:,:,i)))*1E-6;
  end
end
model.Priors = Priors;

