function r = reproduction_DSGMR(DataIn, model, rr, currPos)
% Reproduction by using the task-parameterized DS-GMR model. The DS-GMR model is a statistical dynamical system  
% approach to learn and reproduce movements with a superposition of virtual spring-damper systems
% retrieved by Gaussian mixture regression (GMR). 
% For more details, see the 'DMP-learned-by-GMR-v1.0' example code, downloadable from the website below. 
%
% Author:	Sylvain Calinon, 2013
%         http://programming-by-demonstration.org/SylvainCalinon

nbData = size(DataIn,2);
in = [1:size(DataIn,1)];
out = [in(end)+1:model.nbVar];
nbVarOut = length(out);

r.Data = zeros(nbVarOut*4+length(in),size(DataIn,2));
r.Data(1:size(DataIn,1),:) = DataIn;

%Computes resulting Gaussians after projections and products of Gaussians estimation
[prodRes, r.p] = computeResultingGaussians(model, rr.p);
for t=1:length(prodRes)  
  r.Mu(:,:,t) = prodRes(t).Mu;
  r.Sigma(:,:,:,t) = prodRes(t).Sigma;
  for i=1:model.nbStates
		prodRes(t).invSigmaIn(in,in,i) = inv(prodRes(t).Sigma(in,in,i));
		prodRes(t).detSigmaIn(i) = det(prodRes(t).Sigma(in,in,i));
	end
end

currVel = zeros(nbVarOut,1);
for n=1:nbData
  %Moving frames?
  if length(prodRes)>1 
    nn = n;
  else
    nn = 1;
  end
  %Compute activation weight
  for i=1:model.nbStates
    r.H(i,n) = model.Priors(i) * gaussPDFfast(DataIn(:,n), prodRes(nn).Mu(in,i), prodRes(nn).invSigmaIn(in,in,i), prodRes(nn).detSigmaIn(i)); 
  end
  r.H(:,n) = r.H(:,n)/sum(r.H(:,n));
  %Evaluate the current target (see Eq. (2) Calinon et al, Humanoids'2012 paper)
  currTar = zeros(nbVarOut,1);
  for i=1:model.nbStates
    MuTmp(:,i) = prodRes(nn).Mu(out,i) + prodRes(nn).Sigma(out,in,i)*inv(prodRes(nn).Sigma(in,in,i)) * (DataIn(:,n)-prodRes(nn).Mu(in,i)); 
    currTar = currTar + r.H(i,n) * MuTmp(:,i); 
  end
  %Compute acceleration (see Eq. (1) Calinon et al, Humanoids'2012 paper)
  currAcc = model.kP * (currTar-currPos) - model.kV * currVel;
  %Update velocity and position
  currVel = currVel + currAcc * model.dt;
  currPos = currPos + currVel * model.dt;
  %Keep a trace of data
  r.Data(:,n) = [DataIn(:,n); currPos; currVel; currAcc; currTar];
end
