function prob = gaussPDFfast(Data, Mu, invSigma, detSigma)
% Likelihood of datapoint(s) to be generated by a Gaussian represented by means and covariance matrix.
% (fast version where the inverse and determinant are precomputed)
% 
% Author:	Sylvain Calinon, 2012
%         http://programming-by-demonstration.org/SylvainCalinon

[nbVar,nbData] = size(Data);

Data = Data' - repmat(Mu',nbData,1);
prob = sum((Data*invSigma).*Data, 2);
prob = exp(-0.5*prob) / sqrt((2*pi)^nbVar * (detSigma+realmin));

