
package sc.tool.carmera;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.widget.Toast;


/* 添加Activity声明
 <activity
	 android:name="sc.tool.carmera.CarmeraActivity"
	 android:configChanges="orientation|keyboardHidden|screenSize"
	 android:theme="@android:style/Theme.Translucent.NoTitleBar.Fullscreen" />
 */

/** 拍照：CarmeraActivity.TakePhoto(Context context, CarmeraCallBack call); 
 * 录屏：CarmeraActivity.TakeVedio(Context context, CarmeraCallBack call); */
public class CarmeraActivity extends Activity
{
	/** Carmera回调 */
	public static abstract class CarmeraCallBack
	{
		/** 回调成功，filePath调用系统拍照或录像后返回的文件名称 */
		public abstract void Success(String filePath);
	}
	
	/** 调用系统相机拍照 */
	public static void TakePhoto(Context context, CarmeraCallBack call)
	{
		CarmeraActivity.call = call;
		
		Intent intent = new Intent(context, CarmeraActivity.class);
		// intent.setAction("intent.action.sc.ScreenShot");
		context.startActivity(intent);
		
		if (Instance != null)
		{
			Instance.TakePhoto();
			Instance = null;
		}
	}
	
	/** 调用系统相机录像 */
	public static void TakeVedio(Context context, CarmeraCallBack call)
	{
		Intent intent = new Intent(context, CarmeraActivity.class);
		// intent.setAction("intent.action.sc.ScreenShot");
		context.startActivity(intent);
		CarmeraActivity.call = call;
		
		if (Instance != null)
		{
			Instance.TakeVedio();
			Instance = null;
		}
	}
	
	static CarmeraActivity Instance;
	static CarmeraCallBack call;
	
	// ---------------
	
	String AppDir = "/sdcard/Carmera/";
	final int Requset_Photo = 3000;
	final int Requset_Vedio = 3001;
	
	String path = "";
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		Instance = this;
		
		// setContentView(R.layout.activity_main);
		
		// 创建目录
		File dir = new File(AppDir);
		if (!dir.exists()) dir.mkdirs();
	}
	
	public void TakePhoto()
	{
		// 调用系统的照相机进行拍照
		Intent intent = new Intent();
		intent.setAction("android.media.action.IMAGE_CAPTURE");
		intent.addCategory("android.intent.category.DEFAULT");
		
		// 保存照片到指定的路径
		path = AppDir + NewName() + ".jpg";
		File file = new File(path);
		
		Uri uri = Uri.fromFile(file);
		intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
		
		this.startActivityForResult(intent, Requset_Photo);
	}
	
	public void TakeVedio()
	{
		// 调用系统的照相机进行录像
		Intent intent = new Intent();
		intent.setAction("android.media.action.VIDEO_CAPTURE");
		intent.addCategory("android.intent.category.DEFAULT");
		
		// 保存录像到指定的路径
		path = AppDir + NewName() + ".mp4";
		File file = new File(path);
		
		Uri uri = Uri.fromFile(file);
		intent.putExtra(MediaStore.EXTRA_OUTPUT, uri);
		
		this.startActivityForResult(intent, Requset_Vedio);
	}
	
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		super.onActivityResult(requestCode, resultCode, data);
		
		Toast.makeText(this, "onActivityResult", Toast.LENGTH_SHORT).show();
//		this.finish();	// 调用完成后，关闭当前Activity
//		
//		new Handler(Looper.getMainLooper()).post(new Runnable()
//		{
//			@Override
//			public void run()
//			{
//				if (requestCode == Requset_Photo)
//				{
//					if (call != null) call.Success(path);
//					// Toast.makeText(this, "拍照完成" + "\n" + path, Toast.LENGTH_SHORT).show();
//				}
//				else if (requestCode == Requset_Vedio)
//				{
//					if (call != null) call.Success(path);
//					// Toast.makeText(this, "录像完成" + "\n" + path, Toast.LENGTH_SHORT).show();
//				}
//			}
//		});
		
		
		
	}
	
	// ---------------
	
	private static int count = 0;
	private static String preTime = "";
	
	/** 生成新的名称 */
	public static String NewName()
	{
		DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		String date = formatter.format(new Date());
		
		DateFormat formatter2 = new SimpleDateFormat("HH.mm.ss");
		String time = formatter2.format(new Date());
		
		if (!preTime.equals(time))
		{
			count = 1;
			preTime = time;
		}
		else count++;
		
		String fileName = date + "_" + time + "_" + count;
		return fileName;
	}
	
}
