package com.sc.permission;
//package com.sc.permission;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;

import com.sc.permission.PermissionTool.PermissionCallBack;

/** 
 * https://blog.csdn.net/scimence/article/details/85989997
 * 继承PermissionActivity可自动进行权限申请，
 * 
 * AndroidBuild Target 设置为6.0，
 * <uses-sdk android:targetSdkVersion="23" /> 
 * 
 * ----- 2019-1-7 上午9:08:39 scimence  */
public class PermissionActivity extends Activity
{
	/** 自动解析并请求AndroidManifest.xml中设置的所有权限 */
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		PermissionTool.Request(this);
		
//		PermissionTool.Request(this, new PermissionCallBack()
//		{
//			@Override
//			public void Success()
//			{
//				// 在权限请求完成后，才可执行的逻辑
//				Toast.makeText(PermissionActivity.this, "PermissionCallBack -> Success", Toast.LENGTH_SHORT).show();
//			}
//		});
	}
	
	/** 处理权限请求结果，若未授权，则继续请求 */
	public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults)
	{
		super.onRequestPermissionsResult(requestCode, permissions, grantResults);
		PermissionTool.onRequestPermissionsResult(this, requestCode, permissions, grantResults);
	}
	
	
	/** Activity执行结果 */
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		super.onActivityResult(requestCode, resultCode, data);
		PermissionTool.onActivityResult(this, requestCode, resultCode, data);
	}
}
