
package com.sc.service;

import android.widget.Toast;

/* 在AndroidManifest.xml添加 <service/>
<application ...>
....
        <service
            android:name="com.sc.service.MsgService"
            android:enabled="true"
            android:exported="true" >
        </service>
</application>
*/

/**
 * 定义：继承BaseService，重写自定义服务逻辑serviceLogic()
 * 
 * 1、获取服务：MsgServices.GetInstance()
 * 
 * 2、启动服务：MsgService.GetInstance().start(context, MsgService.class);
 * 3、停止服务：MsgServices.GetInstance().stop();
 * */
public class MsgService extends BaseService
{
	int count = 0;
	
	/** 在service中待执行的逻辑（在service未停止时，会一直执行）*/
	public void serviceLogic()
	{
		Toast.makeText(this, "serviceLogic: " + count++, Toast.LENGTH_SHORT).show();
		// TODO Auto-generated method stub
		// ...
		// this.stop(); // 停止服务
	}
}
