﻿
package com.sc.call;

//import java.util.ArrayList;

import android.content.Context;
import android.widget.Toast;

//
// 整体调用逻辑：
// (1)从BroadCast_Start广播接收到的系统事件(开机、锁屏等)启动服务CallService;
// (2)在CallService中添加来电、拨出事件监听，在监听到电话事件(来电、接听、挂断、拨打电话）后进行事件处理
// (3)在CallService中调用CallProcess中编写好的逻辑
//-----
// 2019-1-9 上午10:16:06
// scimence 


/** 接入逻辑（在AndroidManifest.xml中）
 * 
 * 1、添加权限：
 * uses-permission android:name="android.permission.READ_PHONE_STATE" 
 * uses-permission android:name="android.permission.PROCESS_OUTGOING_CALLS"
 * 
 * 2、添加receiver和service
<application ...>
....
		<!-- 添加静态广播接收，监听开启、锁屏、解屏 事件（以启动电话监听CallService） -->
		<receiver
		    android:name="com.sc.broad.BroadCast_Start"
		    android:exported="true" >
		    <intent-filter>
		        <action android:name="android.intent.action.BOOT_COMPLETED" />
		        <action android:name="android.intent.action.SCREEN_OFF" />
		        <action android:name="android.intent.action.SCREEN_ON" />
		    </intent-filter>
		</receiver>
		
		<!-- 定义CallService，用于执行电话事件处理逻辑 -->
        <service
            android:name="com.sc.service.CallService"
            android:enabled="true"
            android:exported="true" >
        </service>
</application>
*
*
* 3、电话事件处理逻辑：改写该类中的处理逻辑（实现来电、接听、挂断、拨出 事件逻辑）
* 
* 备注：若改变当前类名、路径，请在CallService.CallLogic()中修改调用
* */
public class CallProcess
{
	/** 添加来电处理逻辑 */
	public static void Ringing(Context context, String phoneNumber)
	{	
		// TODO 添加来电相关处理逻辑
		Toast.makeText(context, "来电相关处理逻辑！", Toast.LENGTH_SHORT).show();
	}
	
	/** 添加接听处理逻辑 */
	public static void OffHook(Context context, String phoneNumber)
	{	
		// TODO 添加接听相关处理逻辑
		Toast.makeText(context, "接听相关处理逻辑！", Toast.LENGTH_SHORT).show();
	}
	
	/** 添加挂断处理逻辑 */
	public static void HungUp(Context context, String phoneNumber)
	{	
		// TODO 添加挂断相关处理逻辑
		Toast.makeText(context, "挂断相关处理逻辑！", Toast.LENGTH_SHORT).show();
	}
	
	/** 添加拨出处理逻辑 */
	public static void OutCall(Context context, String phoneNumber)
	{	
		// TODO 添加拨出相关处理逻辑
		Toast.makeText(context, "拨出相关处理逻辑！", Toast.LENGTH_SHORT).show();
	}
}
