
package com.sc.service;

import com.sc.call.CallListener;
import com.sc.call.CallProcess;

import android.widget.Toast;

/* 在AndroidManifest.xml
 * 
 * 添加权限：
 * uses-permission android:name="android.permission.READ_PHONE_STATE" 
 * uses-permission android:name="android.permission.PROCESS_OUTGOING_CALLS"
 * 
 * 添加 <service/>
<application ...>
....
        <service
            android:name="com.sc.service.CallService"
            android:enabled="true"
            android:exported="true" >
        </service>
</application>
*/

/**
 * 定义：继承BaseService，重写自定义服务逻辑serviceLogic()
 * 
 * 1、获取服务：CallService.GetInstance()
 * 
 * 2、启动服务：CallService.GetInstance().start(context, CallService.class);
 * 3、停止服务：CallService.GetInstance().stop();
 * */
public class CallService extends BaseService
{
	/** 在service中待执行的逻辑（在service未停止时，会一直执行）*/
	public void serviceLogic()
	{
		CheckListener();	// 检测电话监听状态
		CallLogic();		// 执行对应电话状态逻辑
	}
	
	public static boolean isRinging = false;
	public static boolean isOutCall = false;
	public static boolean isOffHook = false;
	public static boolean isHungUp = false;
	public static String Number = "";

	CallListener callListen;
	
	// 检测并自动创建来电、去电监听
	private void CheckListener()
	{
		if(callListen == null)
		{
			callListen = new CallListener(this)
			{
				@Override
				public void Ringing(String phoneNumber)
				{
					isRinging = true;
					Number = phoneNumber;
				}
				
				@Override
				public void OutCall(String phoneNumber)
				{
					isOutCall = true;
					Number = phoneNumber;
				}
				
				@Override
				public void OffHook(String phoneNumber)
				{
					isOffHook = true;
					Number = phoneNumber;
				}
				
				@Override
				public void HungUp(String phoneNumber)
				{
					isHungUp = true;
					Number = phoneNumber;
				}
			};
		}
	}
	
	/** 电话状态处理逻辑 */
	private void CallLogic()
	{
		if(isRinging)
		{
			isRinging = false;
			CallProcess.Ringing(this, Number);
		}
		else if(isOffHook)
		{
			isOffHook = false;
			CallProcess.OffHook(this, Number);
		}
		else if(isHungUp)
		{
			isHungUp = false;
			CallProcess.HungUp(this, Number);
		}
		else if(isOutCall)
		{
			isOutCall = false;
			CallProcess.OutCall(this, Number);
		}
	}
	
//	/** 电话状态处理逻辑 */
//	private void CallLogic()
//	{
//	
//		// 执行定义在CallProcess中的逻辑
//		for(CallProcess proccesser : CallProcess.ProcessList())
//		{
//			if(isRinging)
//			{
//				isRinging = false;
//				proccesser.Ringing(this, Number);
//			}
//			else if(isOffHook)
//			{
//				isOffHook = false;
//				proccesser.OffHook(this, Number);
//			}
//			else if(isHungUp)
//			{
//				isHungUp = false;
//				proccesser.HungUp(this, Number);
//			}
//			else if(isOutCall)
//			{
//				isOutCall = false;
//				proccesser.OutCall(this, Number);
//			}
//		}
//		
//	}

	
//	public void Ringing(String phoneNumber)
//	{
//		// TODO 添加来电处理逻辑
//	}
//	
//	public void OffHook(String phoneNumber)
//	{
//		// TODO 添加接听处理逻辑
//	}
//	
//	public void HungUp(String phoneNumber)
//	{
//		// TODO 添加挂断处理逻辑
//	}
//	
//	public void OutCall(String phoneNumber)
//	{
//		// TODO 添加拨出处理逻辑
//	}
}
