
package sc.screen.demo;

import sc.tool.screenshot.ScreenActivity;
import sc.tool.screenshot.ScreenTool;
import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;


//import sc.tool.screenshot.ScreenActivity.ScreenCallBack;

public class MainActivity extends Activity
{
	EditText Interval;
	EditText Times;
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		Interval = (EditText) this.findViewById(R.id.textInterval);
		Times = (EditText) this.findViewById(R.id.textTimes);
		
		ScreenActivity.Init(this);			// 初始化允许截屏请求
		
		// // 请求允许获取屏幕，用允许时截屏保存
		// ScreenActivity.Init(this, new ScreenCallBack()
		// {
		// @Override
		// public void Success()
		// {
		// ScreenActivity.GetScreen(); // 截屏保存
		// }
		// });
	}
	
	public void ScreeShot(View view)
	{
		ScreenTool.GetScreen(this);			// Activity截屏
		Toast.makeText(this, "截屏已保存", Toast.LENGTH_SHORT).show();
	}
	
	public void ScreeShot_Proj(View view)
	{
		ScreenActivity.GetScreen();			// 投影截屏
		Toast.makeText(this, "截屏已保存", Toast.LENGTH_SHORT).show();
	}
	
	public void ScreeShot_Proj_Auto(View view)
	{
		ScreenActivity.GetScreen(1000, 5);	// 投影截屏（延时多次截屏）
	}
	
	public void ScreeShot_sustom(View view)
	{
		try
		{
			Long inteval = Long.parseLong(Interval.getText().toString());
			int times = Integer.parseInt(Times.getText().toString());
			
			ScreenActivity.GetScreen(inteval, times);	// 投影截屏（延时多次截屏）
		}
		catch (Exception ex)
		{}
	}
	
	public void ScreeRecord(View view)
	{
		Button btn = (Button) view;
		String text = btn.getText().toString().trim();
		if (text.equals("开始录屏(3秒后开始)"))
		{
			btn.setText("停止录屏");
			
			ScreenActivity.GetVedio_Start(3000L);	// 开始录屏
		}
		else if (text.equals("停止录屏"))
		{
			btn.setText("开始录屏(3秒后开始)");
			String path = ScreenActivity.GetVedio_Stop();			// 停止录屏
			
			if (!path.equals(""))
			{
				Toast.makeText(this, "录屏已保存" + "\n" + path, Toast.LENGTH_SHORT).show();
			}
		}
	}
	
}
