var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var debug = require("debug");
var fs = require("fs-extra");
var os = require("os");
var path = require("path");
var d = debug('electron-notarize:helpers');
function withTempDir(fn) {
    return __awaiter(this, void 0, void 0, function () {
        var dir, result, err_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, fs.mkdtemp(path.resolve(os.tmpdir(), 'electron-notarize-'))];
                case 1:
                    dir = _a.sent();
                    d('doing work inside temp dir:', dir);
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 4, , 6]);
                    return [4 /*yield*/, fn(dir)];
                case 3:
                    result = _a.sent();
                    return [3 /*break*/, 6];
                case 4:
                    err_1 = _a.sent();
                    d('work failed');
                    return [4 /*yield*/, fs.remove(dir)];
                case 5:
                    _a.sent();
                    throw err_1;
                case 6:
                    d('work succeeded');
                    return [4 /*yield*/, fs.remove(dir)];
                case 7:
                    _a.sent();
                    return [2 /*return*/, result];
            }
        });
    });
}
exports.withTempDir = withTempDir;
var Secret = /** @class */ (function () {
    function Secret(value) {
        this.value = value;
    }
    Secret.prototype.toString = function () {
        return this.value;
    };
    Secret.prototype.inpsect = function () {
        return '******';
    };
    return Secret;
}());
function makeSecret(s) {
    return new Secret(s);
}
exports.makeSecret = makeSecret;
function isSecret(s) {
    return s instanceof Secret;
}
exports.isSecret = isSecret;
function parseNotarizationInfo(info) {
    var out = {};
    var matchToProperty = function (key, r, modifier) {
        var exec = r.exec(info);
        if (exec) {
            out[key] = modifier ? modifier(exec[1]) : exec[1];
        }
    };
    matchToProperty('uuid', /\n *RequestUUID: (.+?)\n/);
    matchToProperty('date', /\n *Date: (.+?)\n/, function (d) { return new Date(d); });
    matchToProperty('status', /\n *Status: (.+?)\n/);
    matchToProperty('logFileUrl', /\n *LogFileURL: (.+?)\n/);
    matchToProperty('statusCode', /\n *Status Code: (.+?)\n/, function (n) { return parseInt(n, 10); });
    matchToProperty('statusMessage', /\n *Status Message: (.+?)\n/);
    if (out.logFileUrl === '(null)') {
        out.logFileUrl = null;
    }
    return out;
}
exports.parseNotarizationInfo = parseNotarizationInfo;
//# sourceMappingURL=helpers.js.map