/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldNameConstantsFieldProcessor
extends AbstractFieldProcessor {
    private static final String CONFIG_DEFAULT = " CONFIG DEFAULT ";

    public FieldNameConstantsFieldProcessor() {
        super((Class<? extends PsiElement>)PsiField.class, "lombok.experimental.FieldNameConstants");
    }

    @Override
    protected boolean supportAnnotationVariant(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(0);
        }
        return null != psiAnnotation.findAttributeValue("prefix");
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(2);
        }
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(3);
        }
        if (null == nameHint) {
            return true;
        }
        String generatedElementName = this.calcFieldConstantName(psiField, psiAnnotation, psiClass);
        return Objects.equals(nameHint, generatedElementName);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(4);
        }
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(6);
        }
        return LombokProcessorUtil.isLevelVisible(psiAnnotation) && this.checkIfFieldNameIsValidAndWarn(psiAnnotation, psiField, builder);
    }

    public boolean checkIfFieldNameIsValidAndWarn(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        boolean isValid;
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(7);
        }
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(9);
        }
        if (!(isValid = this.isValidFieldNameConstant(psiAnnotation, psiField))) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.constant", new Object[0]));
        }
        return isValid;
    }

    private boolean isValidFieldNameConstant(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        PsiClass psiClass;
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(10);
        }
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(11);
        }
        if (null != (psiClass = psiField.getContainingClass())) {
            String fieldName = this.calcFieldConstantName(psiField, psiAnnotation, psiClass);
            return !fieldName.equals(psiField.getName());
        }
        return false;
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        PsiClass psiClass;
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(13);
        }
        if (target == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(14);
        }
        if (null != (psiClass = psiField.getContainingClass()) && null != psiField.getName()) {
            target.add((PsiElement)this.createFieldNameConstant(psiField, psiClass, psiAnnotation));
        }
    }

    @NotNull
    public PsiField createFieldNameConstant(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(15);
        }
        if (psiClass == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(16);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(17);
        }
        PsiManager manager = psiClass.getContainingFile().getManager();
        PsiClassType psiFieldType = PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)psiClass.getProject()));
        String fieldModifier = LombokProcessorUtil.getLevelVisibility(psiAnnotation);
        String fieldName = this.calcFieldConstantName(psiField, psiAnnotation, psiClass);
        LombokLightFieldBuilder fieldNameConstant = new LombokLightFieldBuilder(manager, fieldName, (PsiType)psiFieldType).withContainingClass(psiClass).withNavigationElement((PsiElement)psiField).withModifier("static").withModifier("final");
        if (!"packageLocal".equals(fieldModifier)) {
            fieldNameConstant.withModifier(fieldModifier);
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
        PsiExpression initializer = psiElementFactory.createExpressionFromText("\"" + psiField.getName() + "\"", (PsiElement)psiClass);
        fieldNameConstant.setInitializer(initializer);
        LombokLightFieldBuilder lombokLightFieldBuilder = fieldNameConstant;
        if (lombokLightFieldBuilder == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(18);
        }
        return lombokLightFieldBuilder;
    }

    @NotNull
    private String calcFieldConstantName(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass) {
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(19);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(20);
        }
        if (psiClass == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(21);
        }
        String prefix = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "prefix", CONFIG_DEFAULT);
        String suffix = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "suffix", CONFIG_DEFAULT);
        ConfigDiscovery configDiscovery = ConfigDiscovery.getInstance();
        if (CONFIG_DEFAULT.equals(prefix)) {
            prefix = configDiscovery.getStringLombokConfigProperty(ConfigKey.FIELD_NAME_CONSTANTS_PREFIX, psiClass);
        }
        if (CONFIG_DEFAULT.equals(suffix)) {
            suffix = configDiscovery.getStringLombokConfigProperty(ConfigKey.FIELD_NAME_CONSTANTS_SUFFIX, psiClass);
        }
        String string = prefix + LombokUtils.camelCaseToConstant(psiField.getName()) + suffix;
        if (string == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(23);
        }
        if (psiAnnotation == null) {
            FieldNameConstantsFieldProcessor.$$$reportNull$$$0(24);
        }
        return LombokPsiElementUsage.USAGE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/FieldNameConstantsFieldProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/FieldNameConstantsFieldProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldNameConstant";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFieldConstantName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportAnnotationVariant";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkIfFieldNameIsValidAndWarn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldNameConstant";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFieldNameConstant";
                break;
            }
            case 18: 
            case 22: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calcFieldConstantName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

