/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DelegateHandler {
    public boolean validate(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull PsiType psiType, @NotNull PsiAnnotation psiAnnotation, @NotNull ProblemBuilder builder) {
        if (psiModifierListOwner == null) {
            DelegateHandler.$$$reportNull$$$0(0);
        }
        if (psiType == null) {
            DelegateHandler.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            DelegateHandler.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            DelegateHandler.$$$reportNull$$$0(3);
        }
        boolean result = true;
        if (psiModifierListOwner.hasModifierProperty("static")) {
            builder.addError(LombokBundle.message("inspection.message.delegate.legal.only.on.instance.fields", new Object[0]));
            result = false;
        }
        Collection<PsiType> types = this.collectDelegateTypes(psiAnnotation, psiType);
        result &= this.validateTypes(types, builder);
        Collection<PsiType> excludes = this.collectExcludeTypes(psiAnnotation);
        return result &= this.validateTypes(excludes, builder);
    }

    private Collection<PsiType> collectDelegateTypes(PsiAnnotation psiAnnotation, PsiType psiType) {
        Collection<PsiType> types = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "types", PsiType.class);
        if (types.isEmpty()) {
            types = Collections.singletonList(psiType);
        }
        return types;
    }

    private boolean validateTypes(Collection<PsiType> psiTypes, ProblemBuilder builder) {
        boolean result = true;
        for (PsiType psiType : psiTypes) {
            if (!this.checkConcreteClass(psiType)) {
                builder.addError(LombokBundle.message("inspection.message.delegate.can.only.use.concrete.class.types", new Object[0]), psiType.getCanonicalText());
                result = false;
                continue;
            }
            result &= this.validateRecursion(psiType, builder);
        }
        return result;
    }

    private boolean validateRecursion(PsiType psiType, ProblemBuilder builder) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)psiType);
        if (null != psiClass) {
            DelegateAnnotationElementVisitor delegateAnnotationElementVisitor = new DelegateAnnotationElementVisitor(psiType, builder);
            psiClass.acceptChildren((PsiElementVisitor)delegateAnnotationElementVisitor);
            return delegateAnnotationElementVisitor.isValid();
        }
        return true;
    }

    private boolean checkConcreteClass(@NotNull PsiType psiType) {
        if (psiType == null) {
            DelegateHandler.$$$reportNull$$$0(4);
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return !(psiClass instanceof PsiTypeParameter);
        }
        return false;
    }

    private Collection<PsiType> collectExcludeTypes(PsiAnnotation psiAnnotation) {
        return PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "excludes", PsiType.class);
    }

    public <T extends PsiMember & PsiNamedElement> void generateElements(@NotNull T psiElement, @NotNull PsiType psiElementType, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        PsiClass psiClass;
        if (psiElement == null) {
            DelegateHandler.$$$reportNull$$$0(5);
        }
        if (psiElementType == null) {
            DelegateHandler.$$$reportNull$$$0(6);
        }
        if (psiAnnotation == null) {
            DelegateHandler.$$$reportNull$$$0(7);
        }
        if (target == null) {
            DelegateHandler.$$$reportNull$$$0(8);
        }
        PsiManager manager = psiElement.getContainingFile().getManager();
        LinkedHashSet<Pair<PsiMethod, PsiSubstitutor>> includesMethods = new LinkedHashSet<Pair<PsiMethod, PsiSubstitutor>>();
        Collection<PsiType> types = this.collectDelegateTypes(psiAnnotation, psiElementType);
        this.addMethodsOfTypes(types, includesMethods);
        LinkedHashSet<Pair<PsiMethod, PsiSubstitutor>> excludeMethods = new LinkedHashSet<Pair<PsiMethod, PsiSubstitutor>>();
        PsiClassType javaLangObjectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)psiElement.getResolveScope());
        this.addMethodsOfType((PsiType)javaLangObjectType, excludeMethods);
        Collection<PsiType> excludes = this.collectExcludeTypes(psiAnnotation);
        this.addMethodsOfTypes(excludes, excludeMethods);
        Collection<Pair<PsiMethod, PsiSubstitutor>> methodsToDelegate = this.findMethodsToDelegate(includesMethods, excludeMethods);
        if (!methodsToDelegate.isEmpty() && null != (psiClass = psiElement.getContainingClass())) {
            for (Pair<PsiMethod, PsiSubstitutor> pair : methodsToDelegate) {
                target.add((PsiElement)this.generateDelegateMethod(psiClass, psiElement, psiAnnotation, (PsiMethod)pair.getFirst(), (PsiSubstitutor)pair.getSecond()));
            }
        }
    }

    private void addMethodsOfTypes(Collection<PsiType> types, Collection<Pair<PsiMethod, PsiSubstitutor>> includesMethods) {
        for (PsiType type : types) {
            this.addMethodsOfType(type, includesMethods);
        }
    }

    private void addMethodsOfType(PsiType psiType, Collection<Pair<PsiMethod, PsiSubstitutor>> allMethods) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)psiType);
        PsiClass psiClass = resolveResult.getElement();
        if (null != psiClass) {
            this.collectAllMethods(allMethods, psiClass, resolveResult.getSubstitutor());
        }
    }

    private void collectAllMethods(Collection<Pair<PsiMethod, PsiSubstitutor>> allMethods, @NotNull PsiClass psiStartClass, @NotNull PsiSubstitutor classSubstitutor) {
        if (psiStartClass == null) {
            DelegateHandler.$$$reportNull$$$0(9);
        }
        if (classSubstitutor == null) {
            DelegateHandler.$$$reportNull$$$0(10);
        }
        for (PsiClass psiClass = psiStartClass; null != psiClass; psiClass = psiClass.getSuperClass()) {
            PsiMethod[] psiMethods;
            for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
                if (psiMethod.isConstructor() || !psiMethod.hasModifierProperty("public") || psiMethod.hasModifierProperty("static")) continue;
                Pair newMethodSubstitutorPair = new Pair((Object)psiMethod, (Object)classSubstitutor);
                boolean acceptMethod = true;
                for (Pair<PsiMethod, PsiSubstitutor> uniquePair : allMethods) {
                    if (!PsiElementUtil.methodMatches((Pair<PsiMethod, PsiSubstitutor>)newMethodSubstitutorPair, uniquePair)) continue;
                    acceptMethod = false;
                    break;
                }
                if (!acceptMethod) continue;
                allMethods.add((Pair<PsiMethod, PsiSubstitutor>)newMethodSubstitutorPair);
            }
            for (PsiMethod psiMethod : psiClass.getInterfaces()) {
                classSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiMethod, (PsiClass)psiClass, (PsiSubstitutor)classSubstitutor);
                this.collectAllMethods(allMethods, (PsiClass)psiMethod, classSubstitutor);
            }
        }
    }

    private Collection<Pair<PsiMethod, PsiSubstitutor>> findMethodsToDelegate(Collection<Pair<PsiMethod, PsiSubstitutor>> includesMethods, Collection<Pair<PsiMethod, PsiSubstitutor>> excludeMethods) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (Pair<PsiMethod, PsiSubstitutor> includesMethodPair : includesMethods) {
            boolean acceptMethod = true;
            for (Pair<PsiMethod, PsiSubstitutor> excludeMethodPair : excludeMethods) {
                if (!PsiElementUtil.methodMatches(includesMethodPair, excludeMethodPair)) continue;
                acceptMethod = false;
                break;
            }
            if (!acceptMethod) continue;
            result.add(includesMethodPair);
        }
        return result;
    }

    @NotNull
    private <T extends PsiModifierListOwner & PsiNamedElement> PsiMethod generateDelegateMethod(@NotNull PsiClass psiClass, @NotNull T psiElement, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiMethod psiMethod, @NotNull PsiSubstitutor psiSubstitutor) {
        if (psiClass == null) {
            DelegateHandler.$$$reportNull$$$0(11);
        }
        if (psiElement == null) {
            DelegateHandler.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            DelegateHandler.$$$reportNull$$$0(13);
        }
        if (psiMethod == null) {
            DelegateHandler.$$$reportNull$$$0(14);
        }
        if (psiSubstitutor == null) {
            DelegateHandler.$$$reportNull$$$0(15);
        }
        PsiType returnType = psiSubstitutor.substitute(psiMethod.getReturnType());
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiClass.getManager(), psiMethod.getName()).withModifier("public").withMethodReturnType(returnType).withContainingClass(psiClass).withNavigationElement((PsiElement)psiMethod);
        for (PsiTypeParameter typeParameter : psiMethod.getTypeParameters()) {
            methodBuilder.withTypeParameter(typeParameter);
        }
        PsiReferenceList throwsList = psiMethod.getThrowsList();
        for (PsiClassType psiClassType : throwsList.getReferencedTypes()) {
            methodBuilder.withException(psiClassType);
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        PsiParameter[] psiParameters = parameterList.getParameters();
        for (int parameterIndex = 0; parameterIndex < psiParameters.length; ++parameterIndex) {
            PsiParameter psiParameter = psiParameters[parameterIndex];
            PsiType psiParameterType = psiSubstitutor.substitute(psiParameter.getType());
            String generatedParameterName = StringUtils.defaultIfEmpty((String)psiParameter.getName(), (String)("p" + parameterIndex));
            methodBuilder.withParameter(generatedParameterName, psiParameterType);
        }
        String codeBlockText = this.createCodeBlockText(psiElement, psiMethod, returnType, psiParameters);
        methodBuilder.withBodyText(codeBlockText);
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            DelegateHandler.$$$reportNull$$$0(16);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private <T extends PsiModifierListOwner & PsiNamedElement> String createCodeBlockText(@NotNull T psiElement, @NotNull PsiMethod psiMethod, @NotNull PsiType returnType, @NotNull PsiParameter[] psiParameters) {
        String blockText;
        if (psiElement == null) {
            DelegateHandler.$$$reportNull$$$0(17);
        }
        if (psiMethod == null) {
            DelegateHandler.$$$reportNull$$$0(18);
        }
        if (returnType == null) {
            DelegateHandler.$$$reportNull$$$0(19);
        }
        if (psiParameters == null) {
            DelegateHandler.$$$reportNull$$$0(20);
        }
        StringBuilder paramString = new StringBuilder();
        for (int parameterIndex = 0; parameterIndex < psiParameters.length; ++parameterIndex) {
            PsiParameter psiParameter = psiParameters[parameterIndex];
            String generatedParameterName = StringUtils.defaultIfEmpty((String)psiParameter.getName(), (String)("p" + parameterIndex));
            paramString.append(generatedParameterName).append(',');
        }
        if (paramString.length() > 0) {
            paramString.deleteCharAt(paramString.length() - 1);
        }
        boolean isMethodCall = psiElement instanceof PsiMethod;
        String string = blockText = String.format("%sthis.%s%s.%s(%s);", PsiType.VOID.equals((Object)returnType) ? "" : "return ", ((PsiNamedElement)psiElement).getName(), isMethodCall ? "()" : "", psiMethod.getName(), paramString.toString());
        if (string == null) {
            DelegateHandler.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 2: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiStartClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSubstitutor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSubstitutor";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/handler/DelegateHandler";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/DelegateHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDelegateMethod";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkConcreteClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateElements";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectAllMethods";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegateMethod";
                break;
            }
            case 16: 
            case 21: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DelegateAnnotationElementVisitor
    extends JavaElementVisitor {
        private final PsiType psiType;
        private final ProblemBuilder builder;
        private boolean valid;

        DelegateAnnotationElementVisitor(PsiType psiType, ProblemBuilder builder) {
            this.psiType = psiType;
            this.builder = builder;
            this.valid = true;
        }

        public void visitField(PsiField psiField) {
            this.checkModifierListOwner((PsiModifierListOwner)psiField);
        }

        public void visitMethod(PsiMethod psiMethod) {
            this.checkModifierListOwner((PsiModifierListOwner)psiMethod);
        }

        private void checkModifierListOwner(PsiModifierListOwner modifierListOwner) {
            if (PsiAnnotationSearchUtil.isAnnotatedWith(modifierListOwner, "lombok.Delegate", "lombok.experimental.Delegate")) {
                this.builder.addError(LombokBundle.message("inspection.message.delegate.does.not.support.recursion.delegating", new Object[0]), ((PsiMember)modifierListOwner).getName(), this.psiType.getPresentableText());
                this.valid = false;
            }
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

