/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiAnnotationUtil {
    @NotNull
    public static PsiAnnotation createPsiAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, String annotationClassName) {
        if (psiModifierListOwner == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(0);
        }
        return PsiAnnotationUtil.createPsiAnnotation(psiModifierListOwner, "", annotationClassName);
    }

    @NotNull
    public static PsiAnnotation createPsiAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, @Nullable String value, String annotationClassName) {
        if (psiModifierListOwner == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(1);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)psiModifierListOwner.getProject());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiClass.class);
        Object valueString = StringUtil.isNotEmpty((String)value) ? "(" + value + ")" : "";
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText("@" + annotationClassName + (String)valueString, (PsiElement)psiClass);
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(2);
        }
        return psiAnnotation;
    }

    @NotNull
    public static <T> Collection<T> getAnnotationValues(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter, @NotNull Class<T> asClass) {
        T value;
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(3);
        }
        if (parameter == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(4);
        }
        if (asClass == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(5);
        }
        List result = Collections.emptyList();
        PsiAnnotationMemberValue attributeValue = psiAnnotation.findAttributeValue(parameter);
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] memberValues = ((PsiArrayInitializerMemberValue)attributeValue).getInitializers();
            result = new ArrayList(memberValues.length);
            for (PsiAnnotationMemberValue memberValue : memberValues) {
                T value2 = PsiAnnotationUtil.resolveElementValue((PsiElement)memberValue, asClass);
                if (null == value2) continue;
                result.add(value2);
            }
        } else if (null != attributeValue && null != (value = PsiAnnotationUtil.resolveElementValue((PsiElement)attributeValue, asClass))) {
            result = Collections.singletonList(value);
        }
        List list = result;
        if (list == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    public static boolean hasDeclaredProperty(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter) {
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(7);
        }
        if (parameter == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(8);
        }
        return null != psiAnnotation.findDeclaredAttributeValue(parameter);
    }

    public static boolean getBooleanAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter, boolean defaultValue) {
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(9);
        }
        if (parameter == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(10);
        }
        Boolean result = psiAnnotation.hasAttribute(parameter) ? AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)psiAnnotation, (String)parameter) : null;
        return result == null ? defaultValue : result;
    }

    public static String getStringAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter, @NotNull String defaultValue) {
        String result;
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(11);
        }
        if (parameter == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(12);
        }
        if (defaultValue == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(13);
        }
        return (result = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)psiAnnotation, (String)parameter)) != null ? result : defaultValue;
    }

    public static String getEnumAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String attributeName, @NotNull String defaultValue) {
        PsiAnnotationMemberValue attrValue;
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(14);
        }
        if (attributeName == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(15);
        }
        if (defaultValue == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(16);
        }
        String result = (attrValue = psiAnnotation.findDeclaredAttributeValue(attributeName)) != null ? PsiAnnotationUtil.resolveElementValue((PsiElement)attrValue, String.class) : null;
        return result != null ? result : defaultValue;
    }

    public static int getIntAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String attributeName, int defaultValue) {
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(17);
        }
        if (attributeName == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(18);
        }
        PsiAnnotationMemberValue attrValue = psiAnnotation.findDeclaredAttributeValue(attributeName);
        PsiConstantEvaluationHelper evaluationHelper = JavaPsiFacade.getInstance((Project)psiAnnotation.getProject()).getConstantEvaluationHelper();
        Object result = evaluationHelper.computeConstantExpression((PsiElement)attrValue);
        return result instanceof Number ? ((Number)result).intValue() : defaultValue;
    }

    @Nullable
    private static <T> T resolveElementValue(@NotNull PsiElement psiElement, @NotNull Class<T> asClass) {
        if (psiElement == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(19);
        }
        if (asClass == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(20);
        }
        Object value = null;
        if (psiElement instanceof PsiReferenceExpression) {
            PsiVariable psiVariable;
            Object elementValue;
            PsiElement resolved = ((PsiReferenceExpression)psiElement).resolve();
            if (resolved instanceof PsiEnumConstant) {
                PsiEnumConstant psiEnumConstant = (PsiEnumConstant)resolved;
                if (asClass.isAssignableFrom(String.class)) {
                    value = psiEnumConstant.getName();
                }
            } else if (resolved instanceof PsiVariable && null != (elementValue = (psiVariable = (PsiVariable)resolved).computeConstantValue()) && asClass.isAssignableFrom(elementValue.getClass())) {
                value = elementValue;
            }
        } else if (psiElement instanceof PsiLiteralExpression) {
            Object elementValue = ((PsiLiteralExpression)psiElement).getValue();
            if (null != elementValue && asClass.isAssignableFrom(elementValue.getClass())) {
                value = elementValue;
            }
        } else if (psiElement instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement elementValue = ((PsiClassObjectAccessExpression)psiElement).getOperand();
            if (asClass.isAssignableFrom(PsiType.class)) {
                value = elementValue.getType();
            }
        } else if (psiElement instanceof PsiAnnotation) {
            if (asClass.isAssignableFrom(PsiAnnotation.class)) {
                value = psiElement;
            }
        } else if (psiElement instanceof PsiPrefixExpression && asClass.isAssignableFrom(String.class)) {
            String expressionText = psiElement.getText();
            value = expressionText;
        }
        return (T)value;
    }

    @Nullable
    public static Boolean getDeclaredBooleanAnnotationValue(@NotNull PsiAnnotation psiAnnotation, @NotNull String parameter) {
        if (psiAnnotation == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(21);
        }
        if (parameter == null) {
            PsiAnnotationUtil.$$$reportNull$$$0(22);
        }
        PsiAnnotationMemberValue attributeValue = psiAnnotation.findDeclaredAttributeValue(parameter);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)psiAnnotation.getProject());
        Object constValue = javaPsiFacade.getConstantEvaluationHelper().computeConstantExpression((PsiElement)attributeValue);
        return constValue instanceof Boolean ? (Boolean)constValue : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/PsiAnnotationUtil";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asClass";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/PsiAnnotationUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsiAnnotation";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationValues";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasDeclaredProperty";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAnnotationValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStringAnnotationValue";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEnumAnnotationValue";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIntAnnotationValue";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredBooleanAnnotationValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

