import { registerPaymentMethod } from '@woocommerce/blocks-registry';
import { decodeEntities } from '@wordpress/html-entities';
import { getSetting } from '@woocommerce/settings';
import { useState, useEffect } from '@wordpress/element';

const settings = getSetting('wc_auxpay_card_data', {});
const label = decodeEntities(settings.title || 'Credit Card');

const Content = (props) => {
    const { eventRegistration, emitResponse } = props;
    const { onPaymentSetup } = eventRegistration;
    const [ paymentToken, setPaymentToken ] = useState('');
    const [hideLabels, setHideLabels] = useState(true);

    useEffect(() => {
        const interval = setInterval(() => {
            if (typeof PayFields !== 'undefined') {
                PayFields.ready();
                PayFields.reload();
                setHideLabels(false);
                clearInterval(interval);
                clearTimeout(timeout);
            }
        }, 500);

        const timeout = setTimeout(() => {
            clearInterval(interval);
        }, 3000);

        const unsubscribe = onPaymentSetup(async () => {
            if (paymentToken) {
                return {
                    type: emitResponse.responseTypes.SUCCESS,
                    meta: {
                        paymentMethodData: { 'payment_token': paymentToken }
                    },
                };
            }
            else if (typeof PayFields !== 'undefined') {
                return new Promise((resolve) => {
                    PayFields.onSuccess = function(response) {
                        setPaymentToken(response?.data?.[0]?.token);
                        resolve({
                            type: emitResponse.responseTypes.SUCCESS,
                            meta: {
                                paymentMethodData: { 'payment_token': response?.data?.[0]?.token }
                            },
                        });
                    };
                    PayFields.onFailure = function(error) {
                        resolve({
                            type: emitResponse.responseTypes.ERROR,
                            message: "Error! Please check your card details.",
                        });
                    };
                    PayFields.onValidationFailure = function() {
                        resolve({
                            type: emitResponse.responseTypes.ERROR,
                            message: "Validation error!",
                        });
                    };
                    PayFields.submit();
                });
            }
            return {
                type: emitResponse.responseTypes.ERROR,
                message: 'Something went wrong, please try again.',
            };
        });

        return () => {
            clearInterval(interval);
            clearTimeout(timeout);
            unsubscribe();
        };
    }, [
        emitResponse.responseTypes.ERROR,
        emitResponse.responseTypes.SUCCESS,
        onPaymentSetup,
        paymentToken
    ]);

    return (
        <>
            <style>
                {`
                    .payfields {
                        padding: 10px;
                        overflow: auto;
                    }
                    .payfields #form-container {
                        width: 315px;
                    }
                    .payfields .label {
                        font-size: 14px !important;
                        font-weight: 500 !important;
                        color: #616161 !important;
                    }
                    .payfields .label.hide {
                        display: none;
                    }
                    .payfields .form-row {
                        height: 60px;
                        width: 315px;
                    }
                    .payfields .card-input-wrapper {
                        display: flex;
                        gap: 12px;
                    }
                    .payfields .card-input-wrapper .form-row {
                        width: auto;
                    }
                    .payfields .card-input-wrapper .w-50 {
                        width: 50%;
                    }
                `}
            </style>
            <div dangerouslySetInnerHTML={{ __html: settings.description || '' }} />
            <div className="payfields">
                <form>
                    <div id="form-container">
                        <label htmlFor="cc_number" className={`label ${hideLabels ? "hide" : ""}`}>Card Number:</label>
                        <div id="cc_number" className="form-row"></div>
                        <div className="card-input-wrapper">
                            <div className="w-50">
                                <label htmlFor="cc_expiry" className={`label ${hideLabels ? "hide" : ""}`}>Expiration:</label>
                                <div id="cc_expiry" className="form-row"></div>
                            </div>
                            <div className="w-50">
                                <label htmlFor="cc_cvv" className={`label ${hideLabels ? "hide" : ""}`}>CVV:</label>
                                <div id="cc_cvv" className="form-row"></div>
                            </div>
                        </div>
                        <label htmlFor="cc_name" className={`label ${hideLabels ? "hide" : ""}`}>Cardholder Name:</label>
                        <div id="cc_name" className="form-row"></div>
                    </div>
                </form>
            </div>
            <input type="hidden" name="payment_token" value={paymentToken} />
        </>
    );
};

const Label = ({ components }) => {
    const { PaymentMethodLabel } = components;
    return <PaymentMethodLabel text={ label } />;
};

const AuxPayCardBlocks = {
    name: 'wc_auxpay_card',
    label: <Label />,
    ariaLabel: label,
    content: <Content />,
    edit: <Content />,
    canMakePayment: () => true,
    supports: {
        features: settings.supports || [],
    },
};

registerPaymentMethod(AuxPayCardBlocks);
