// For classic and block checkout
document.addEventListener('DOMContentLoaded', function() {
    if (typeof WCAuxPaySDK === 'undefined') {
        console.error('WCAuxPaySDK: Payment SDK not loaded.');
    } else {
        WCAuxPaySDK.init({
            environment: WCAuxPayCard.environment,
            merchantURL: WCAuxPayCard.merchantURL,
            merchantID: WCAuxPayCard.merchantID,
            clientToken: WCAuxPayCard.clientToken,
            hostedUrl: WCAuxPayCard.hostedUrl,
            containerId: 'auxpay_card_fields_container'
        });
        WCAuxPaySDK.mount();
        WCAuxPaySDK.onInputChange = function() {
            document.getElementById('payment_token').value = '';
        };
    }
});

// For classic checkout only
jQuery(document).ready(function($) {
    let tokenizing = false;

    function doTokenizeAndSubmit(e) {
        if ($('#payment_token').val()) return true;
        if (tokenizing) return false;

        tokenizing = true;
        e.preventDefault();

        if (typeof WCAuxPaySDK !== 'undefined') {
            WCAuxPaySDK.tokenize().then(function(data) {
                $('#payment_token').val(data.token);
                $('form[name="checkout"]').submit();
            }).catch(function(err) {
                var errorMsg = err.message || err;
                $('.woocommerce-error, .woocommerce-message').remove();
                var noticeWrapper = document.querySelector('.woocommerce-notices-wrapper:last-of-type');
                if (noticeWrapper) {
                    $('<ul class="woocommerce-error"><li>' + errorMsg + '</li></ul>').prependTo(noticeWrapper);
                    setTimeout(function() {
                        noticeWrapper.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }, 1000);
                } else {
                    alert(errorMsg);
                }
            }).finally(function() {
                tokenizing = false;
            });
        }
        return false;
    }

    // Mount the hosted fields, if the payment method is selected
    $(document).on('updated_checkout', function() {
        if ($('input[name="payment_method"]:checked').val() === WCAuxPayCard.gatewayID) {
            setTimeout(function() {
                if (typeof WCAuxPaySDK !== 'undefined') {
                    WCAuxPaySDK.mount();
                    $('#payment_token').val('');
                }
            }, 100);
        }
    });

    // bind to WC classic checkout submit
    $('form[name="checkout"]').on('checkout_place_order_' + WCAuxPayCard.gatewayID, doTokenizeAndSubmit);
});
