// For classic and block checkout
document.addEventListener('DOMContentLoaded', function() {
    if (typeof WCAuxPaySDK !== 'undefined') {
        WCAuxPaySDK.init({
            environment: WCAuxPayCard.environment,
            merchantURL: WCAuxPayCard.merchantURL,
            clientToken: WCAuxPayCard.clientToken,
            hostedUrl: WCAuxPayCard.hostedUrl,
            containerId: 'auxpay_card_fields_container'
        });
        WCAuxPaySDK.mount();
        WCAuxPaySDK.onInputChange = function() {
            document.getElementById('payment_token').value = '';
        };
    }
    else if (typeof PayFields !== 'undefined') {
        PayFields.config.apiKey = WCAuxPayCard.apiKey;
        PayFields.config.merchant = WCAuxPayCard.merchantID;
        PayFields.config.mode = 'token';
        PayFields.fields = [
            { type: "number", element: "#cc_number" },
            { type: "expiration", element: "#cc_expiry" },
            { type: "cvv", element: "#cc_cvv" },
            { type: "name", element: "#cc_name" }
        ];
        PayFields.customizations = {
            style: {
                ".input": {
                    padding: "6px",
                    fontSize: "14px",
                    borderRadius: "4px",
                    backgroundColor: "rgb(255, 255, 255)",
                    borderColor: "rgb(204, 204, 204)",
                    borderStyle: "solid",
                    borderWidth: "1px"
                },
                ".expiration": {
                    width: "137px"
                },
                ".cvv": {
                    width: "137px"
                },
                ".card-icon": {
                    top: "6px"
                }
            }
        };
        PayFields.ready();
    }
});

// For classic checkout only
jQuery(document).ready(function($) {
    let tokenizing = false;

    function doTokenizeAndSubmit(e) {
        if ($('#payment_token').val()) return true;
        if (tokenizing) return false;

        tokenizing = true;
        e.preventDefault();

        if (typeof WCAuxPaySDK !== 'undefined') {
            WCAuxPaySDK.tokenize().then(function(data) {
                $('#payment_token').val(data.token);
                $('#payrix_form').val('no');
                $('form[name="checkout"]').submit();
            }).catch(function(err) {
                var errorMsg = err.message || err;
                $('.woocommerce-error, .woocommerce-message').remove();
                var noticeWrapper = document.querySelector('.woocommerce-notices-wrapper:last-of-type');
                if (noticeWrapper) {
                    $('<ul class="woocommerce-error"><li>' + errorMsg + '</li></ul>').prependTo(noticeWrapper);
                    setTimeout(function() {
                        noticeWrapper.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }, 1000);
                } else {
                    alert(errorMsg);
                }
            }).finally(function() {
                tokenizing = false;
            });
        }
        else  if (typeof PayFields !== 'undefined') {
            const tokenizePromise = new Promise((resolve, reject) => {
                PayFields.onSuccess = function(response) {
                    resolve({ token: response?.data?.[0]?.token });
                };
                PayFields.onFailure = function(error) {
                    reject({ message: "Error! Please check your card details." });
                };
                PayFields.onValidationFailure = function() {
                    reject({ message: "Validation error!" });
                };
                PayFields.submit();
            });

            tokenizePromise.then(function(data) {
                $('#payment_token').val(data.token);
                $('#payrix_form').val('yes');
                $('form[name="checkout"]').submit();
            }).catch(function(err) {
                var errorMsg = err.message || err;
                $('.woocommerce-error, .woocommerce-message').remove();
                var noticeWrapper = document.querySelector('.woocommerce-notices-wrapper:last-of-type');
                if (noticeWrapper) {
                    $('<ul class="woocommerce-error"><li>' + errorMsg + '</li></ul>').prependTo(noticeWrapper);
                    setTimeout(function() {
                        noticeWrapper.scrollIntoView({ behavior: 'smooth', block: 'start' });
                    }, 1000);
                } else {
                    alert(errorMsg);
                }
            }).finally(function() {
                tokenizing = false;
            });
        }
        return false;
    }

    // Mount the hosted fields, if the payment method is selected
    $(document).on('updated_checkout', function() {
        if ($('input[name="payment_method"]:checked').val() === WCAuxPayCard.gatewayID) {
            setTimeout(function() {
                if (typeof WCAuxPaySDK !== 'undefined') {
                    WCAuxPaySDK.mount();
                    $('#payment_token').val('');
                    $('#payrix_form').val('no');
                }
                else if (typeof PayFields !== 'undefined') {
                    PayFields.reload();
                    $('#payment_token').val('');
                    $('#payrix_form').val('yes');
                    $('.payfields').removeClass('hide');
                    $('.payfields .label').removeClass('hide');
                }
            }, 100);
        }
    });

    // bind to WC classic checkout submit
    $('form[name="checkout"]').on('checkout_place_order_' + WCAuxPayCard.gatewayID, doTokenizeAndSubmit);
});
