<?php

if (!defined('ABSPATH')) {
    exit;
}

class WC_AuxPay_Settings extends WC_Settings_Page {

    public function __construct() {
        $this->id    = 'wc_auxpay_settings';
        $this->label = __('AuxPay Gateway', 'auxpay-payment-gateway');
        parent::__construct();
    }

    public function get_sections() {
        return [
            '' => __('Global Settings', 'auxpay-payment-gateway'),
        ];
    }

    public function get_settings($section = '') {
        return [
            [
                'title' => __('General Settings', 'auxpay-payment-gateway'),
                'type'  => 'title',
                'id'    => 'wc_auxpay_global_settings'
            ],
            [
                'title'   => __('Test mode', 'auxpay-payment-gateway'),
                'id'      => 'wc_auxpay_test_enabled',
                'type'    => 'checkbox',
                'default' => 'yes',
                'desc'    => __('Enable test mode', 'auxpay-payment-gateway'),
            ],
            [
                'title' => __('API URL', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_api_url',
                'type'  => 'text',
                'desc'  => 'Base URL of the payment gateway without trailing slashes. (e.g. no "/" at the end)',
                'default' => '',
                'autoload' => false
            ],
            [
                'title' => __('API Key', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_api_key',
                'type'  => 'password',
                'desc'  => 'Authorization key for payment API.',
                'default' => '',
                'autoload' => false
            ],
            [
                'title'   => __('Debug log', 'auxpay-payment-gateway'),
                'id'      => 'wc_auxpay_logs_enabled',
                'type'    => 'checkbox',
                'default' => 'no',
                'desc'    => __('Enable logs (you can find logs in WooCommerce → Status → Logs -> auxpay-payment-gateway)', 'auxpay-payment-gateway'),
            ],
            [
                'title'   => __('Services Fee', 'auxpay-payment-gateway'),
                'id'      => 'wc_auxpay_fee_enabled',
                'type'    => 'checkbox',
                'default' => 'no',
                'desc'    => __('Enable services fee', 'auxpay-payment-gateway'),
            ],
            [
                'title' => __('Services Fee Title', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_fee_title',
                'type'  => 'text',
                'default' => 'Technology Fee',
            ],
            [
                'type' => 'sectionend',
                'id'   => 'wc_auxpay_global_settings'
            ],
            
            // Credit Card
            [
                'title' => __('Configure Credit Card', 'auxpay-payment-gateway'),
                'type'  => 'title',
                'id'    => 'wc_auxpay_card_titles'
            ],
            [
                'title' => __('Credit Card Title', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_cc_title',
                'type'  => 'text',
                'default' => 'Credit Card',
            ],
            [
                'title' => __('Description', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_cc_description',
                'type'  => 'textarea',
                'default' => 'Pay using your credit card.',
            ],
            [
                'type' => 'sectionend',
                'id'   => 'wc_auxpay_card_titles'
            ],

            // ACH Network
            [
                'title' => __('Configure ACH Network', 'auxpay-payment-gateway'),
                'type'  => 'title',
                'id'    => 'wc_auxpay_ach_titles'
            ],
            [
                'title' => __('ACH Title', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_ach_title',
                'type'  => 'text',
                'default' => 'ACH Payment',
            ],
            [
                'title' => __('Description', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_ach_description',
                'type'  => 'textarea',
                'default' => 'Pay directly from your bank account.',
            ],
            [
                'type' => 'sectionend',
                'id'   => 'wc_auxpay_ach_titles'
            ],

            // Text to Pay
            [
                'title' => __('Configure Text to Pay', 'auxpay-payment-gateway'),
                'type'  => 'title',
                'id'    => 'wc_auxpay_texttopay_titles'
            ],
            [
                'title' => __('Text to Pay Title', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_texttopay_title',
                'type'  => 'text',
                'default' => 'Text to Pay',
            ],
            [
                'title' => __('Description', 'auxpay-payment-gateway'),
                'id'    => 'wc_auxpay_texttopay_description',
                'type'  => 'textarea',
                'default' => 'Pay using a link sent to your mobile.',
            ],

            [
                'type' => 'sectionend',
                'id'   => 'wc_auxpay_texttopay_titles'
            ]
        ];
    }

    public function output() {
        echo '<div class="wc-auxpay-settings"></div>';
		echo wp_kses_post('<a href="' . esc_url( admin_url( 'admin.php?page=wc-settings&tab=checkout' ) ) . '">' . __( 'Back to payments' ) . ' &#x2934;</a>');
        echo wp_kses_post('<h2>' . __('AuxPay Gateway Settings', 'auxpay-payment-gateway') . '</h2>');
        echo '<p>
                <button id="wc-auxpay-test-connection" class="button-primary">Test API Connection</button>
                &nbsp;
                <button id="wc-auxpay-fetch-config" class="button">Fetch Configuration</button>
            </p><br>';
        
        $merchant = get_option('wc_auxpay_merchant_config');
        $merchant_config = array();
        $merchant_config['env'] = 'no' === get_option('wc_auxpay_test_enabled') ? '<span style="color: green">Production</span>' : '<span style="color: orange">Sandbox</span>';
        if (!empty($merchant)) {
            $merchant_config['connect'] = '<span style="color: green">Connected</span>';
            $merchant_config['name']    = $merchant;
        }
        else {
            $merchant_config['connect'] = '<span style="color: red">Not Connected</span>';
            $merchant_config['name']    = '';
        }

        $fee_details  = '';
        $fee_details .= '<h2>Merchant Details</h2>
                        <table class="form-table">
                        <tr><th style="padding: 4px">API Connection</th><td style="padding: 4px">' . $merchant_config['connect'] . '</td></tr>
                        <tr><th style="padding: 4px">Payment Mode</th><td style="padding: 4px">' . $merchant_config['env'] . '</td></tr>
                        <tr><th style="padding: 4px">Merchant</th><td style="padding: 4px">' . $merchant_config['name'] . '</td></tr>
                        </table><br>';

        $config = get_option('wc_auxpay_fee_config');
        if (is_array($config) && !empty($config)) {
            if (isset($config['card'])) {
                $fee_active   =  $config['card']['active'] ? 'Yes' : 'No';
                $fee_details .= '<h2>Card Fee Details</h2>
                                <table class="form-table">
                                <tr><th style="padding: 4px">Is Active</th><td style="padding: 4px">' . $fee_active . '</td></tr>
                                <tr><th style="padding: 4px">Service Fee</th><td style="padding: 4px">' . $config['card']['value'] . '</td></tr>
                                <tr><th style="padding: 4px">Fee Type</th><td style="padding: 4px">' . $config['card']['type'] . '</td></tr>
                                <tr><th style="padding: 4px">Minimum Fee</th><td style="padding: 4px">$' . $config['card']['minimum'] . '</td></tr>
                                </table><br>';
            }
            if (isset($config['ach'])) {
                $fee_active   =  $config['ach']['active'] ? 'Yes' : 'No';
                $fee_details .= '<h2>ACH Fee Details</h2>
                                <table class="form-table">
                                <tr><th style="padding: 4px">Is Active</th><td style="padding: 4px">' . $fee_active . '</td></tr>
                                <tr><th style="padding: 4px">Service Fee</th><td style="padding: 4px">' . $config['ach']['value'] . '</td></tr>
                                <tr><th style="padding: 4px">Fee Type</th><td style="padding: 4px">' . $config['ach']['type'] . '</td></tr>
                                <tr><th style="padding: 4px">Minimum Fee</th><td style="padding: 4px">$' . $config['ach']['minimum'] . '</td></tr>
                                </table><br>';
            }
        }
        else {
            $fee_details .= '<table class="form-table"><tr><th>Fee Details</th><td>No data available, please fetch configuration.</td></tr></table>';
        }

        echo wp_kses_post($fee_details);

        parent::output();
    }

    public function save() {
        // delete transients
        delete_transient('wc_auxpay_client_token');
        WC_Admin_Settings::save_fields($this->get_settings());
    }
}
