jQuery(function ($) {
  $('#wc-auxpay-test-connection').on('click', function (e) {
    e.preventDefault();
    $.post(WCAuxPayGateway.ajax_url, {
      action: 'wc_auxpay_test_connection',
      nonce: WCAuxPayGateway.nonce,
    }, function (response) {
      handleResponse(response, 'Merchant Connected Successfully', true);
    });
  });

  $('#wc-auxpay-fetch-config').on('click', function (e) {
    e.preventDefault();
    $.post(WCAuxPayGateway.ajax_url, {
      action: 'wc_auxpay_fetch_config',
      nonce: WCAuxPayGateway.nonce,
    }, function (response) {
      handleResponse(response, 'Settings Fetched Successfully', true);
    });
  });

  function handleResponse(response, message, reload = false) {
    if (response) {
      console.log(response);
      var errorMsg = response.success && ['success', 200].includes(response.data.status) ? message : response.data.message;
      var errorClass = response.success && ['success', 200].includes(response.data.status) ? 'notice-success' : 'notice-error';
      $('.wc-auxpay-settings .notice').remove();
      var noticeWrapper = document.querySelector('.wc-auxpay-settings');
      if (noticeWrapper) {
        $('<div class="notice ' + errorClass + '"><p>' + errorMsg + '</p></div>').appendTo(noticeWrapper);
      } else {
        alert(errorMsg);
      }
      reload ? location.reload() : '';
    }
  }
});
