<?php
use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

class WC_AuxPay_Card_Blocks extends AbstractPaymentMethodType {
	private $gateway;
    protected $name = 'wc_auxpay_card';

    public function initialize() {
        $this->settings = get_option('woocommerce_wc_auxpay_card_settings', []);
        $this->gateway  = null;

		if ( function_exists( 'WC' ) && WC()->payment_gateways ) {
			$gateways = WC()->payment_gateways->payment_gateways();
			if ( is_array( $gateways ) && isset( $gateways[ $this->name ] ) ) {
				$this->gateway = $gateways[ $this->name ];
			}
		}
    }

    public function is_active() {
		return $this->gateway && $this->gateway->is_available();
	}

    public function get_payment_method_script_handles() {
        $script_path = WC_AUXPAY_PLUGIN_DIR . 'assets/js/dist/auxpay-card';
        $script_url  = $script_path . '.js';
		$asset_path  = $script_path . '.asset.php';
		$asset_url   = file_exists($asset_path)
        ? require($asset_path)
        : array(
            'dependencies' => array(),
            'version' => WC_AUXPAY_VERSION
        );

		wp_register_script(
			'wc-auxpay-card-blocks',
			$script_url,
			$asset_url['dependencies'],
			$asset_url['version'],
			true
		);

        // Hook script translations for block JS
        if ( function_exists( 'wp_set_script_translations' ) ) {
			wp_set_script_translations('wc-auxpay-card-blocks', 'auxpay-payment-gateway', plugin_dir_path(__FILE__) . 'languages');
		}

        return ['wc-auxpay-card-blocks'];
	}

    public function get_payment_method_data() {
        return [
            'title'        => get_option('wc_auxpay_cc_title') . $this->gateway->test_mode,
            'description'  => get_option('wc_auxpay_cc_description'),
            'cards'        => get_option('wc_auxpay_cards_config'),
            'supports'     => array_filter( $this->gateway->supports, [ $this->gateway, 'supports' ] ),
            'pluginUrl'    => WC_AUXPAY_PLUGIN_DIR,
            'ajaxUrl'      => admin_url('admin-ajax.php'),
            'nonce'        => wp_create_nonce('wc_auxpay_card')
        ];
    }
}
