// For classic and block checkout
document.addEventListener('DOMContentLoaded', function() {
    if (typeof WCAuxPaySDK !== 'undefined') {
        WCAuxPaySDK.init({
            environment: WCAuxPayCard.environment,
            merchantURL: WCAuxPayCard.merchantURL,
            clientToken: WCAuxPayCard.clientToken,
            hostedUrl: WCAuxPayCard.hostedUrl,
            containerId: 'auxpay_card_fields_container',
            customizations: {
                style: {
                    ".card-header": {
                        display: "none"
                    }
                }
            }
        });
        WCAuxPaySDK.mount();
        WCAuxPaySDK.onInputChange = function() {
            document.getElementById('payment_token').value = '';
        };
    }
    else if (typeof PayFields !== 'undefined') {
        PayFields.config.apiKey = WCAuxPayCard.apiKey;
        PayFields.config.merchant = WCAuxPayCard.merchantID;
        PayFields.config.mode = 'token';
        PayFields.fields = [
            { type: "number", element: "#cc_number" },
            { type: "expiration", element: "#cc_expiry" },
            { type: "cvv", element: "#cc_cvv" },
            { type: "name", element: "#cc_name" }
        ];
        PayFields.customizations = {
            style: {
                ".input": {
                    padding: "6px",
                    fontSize: "14px",
                    borderRadius: "4px",
                    backgroundColor: "rgb(255, 255, 255)",
                    borderColor: "rgb(204, 204, 204)",
                    borderStyle: "solid",
                    borderWidth: "1px"
                },
                ".expiration": {
                    width: "137px"
                },
                ".cvv": {
                    width: "137px"
                },
                ".card-icon": {
                    top: "6px"
                }
            }
        };
        PayFields.ready();
    }
});

// For classic checkout only
jQuery(document).ready(function($) {
    let tokenizing = false;

    function doTokenizeAndSubmit(e) {
        if ($('#payment_token').val()) return true;
        if (tokenizing) return false;

        tokenizing = true;
        e.preventDefault();

        if (typeof WCAuxPaySDK !== 'undefined') {
            WCAuxPaySDK.tokenize().then(function(data) {
                $('#payment_token').val(data.token);
                $('#payrix_form').val('no');
                showAuxpaySuccess();
                $('form[name="checkout"]').submit();
            }).catch(function(err) {
                showAuxpayError(err);
            }).finally(function() {
                tokenizing = false;
            });
        }
        else  if (typeof PayFields !== 'undefined') {
            const tokenizePromise = new Promise((resolve, reject) => {
                PayFields.onSuccess = function(response) {
                    resolve({ token: response?.data?.[0]?.token });
                };
                PayFields.onFailure = function(error) {
                    reject({ message: "Error! Please check your card details." });
                };
                PayFields.onValidationFailure = function() {
                    reject({ message: "Validation error!" });
                };
                PayFields.submit();
            });

            tokenizePromise.then(function(data) {
                $('#payment_token').val(data.token);
                $('#payrix_form').val('yes');
                showAuxpaySuccess();
                $('form[name="checkout"]').submit();
            }).catch(function(err) {
                showAuxpayError(err);
            }).finally(function() {
                tokenizing = false;
            });
        }
        return false;
    }

    function showOtpModal(phone, transactionId = null, orderId = null, amount = null) {
        const modalHtmlOtpFlow = `
            <div id="auxpay-otp-modal" class="auxpay-modal">
                <div class="auxpay-modal-content">
                    <div id="auxpay-phone-section">
                        <div class="modal-header">
                            <p class="title text-gray">Confirm your approval</p>
                            <p class="desc text-grey">Enter your phone number to continue</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <h4 class="text-gray">Enter your mobile number</h4>
                            <p class="text-grey">We\'ll send a 4-digit code to confirm it\'s you.</p>
                            
                            <div class="phone-text">
                                <p><b><label>Mobile Number</label></b></p>
                                <p><input type="text" id="auxpay-otp-phone" value="${phone}" /></p>
                            </div>

                            <div class="form-group">
                                <button class="auxpay-cancel-otp btn btn-secondary">No thanks</button>
                                <button id="auxpay-send-otp" class="btn btn-success">Send code</button>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-otp-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Enter your 4-digit code</p>
                            <p class="desc text-grey">Verify your identity</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <h4 class="text-gray">Enter your 4-digit code</h4>
                            <p class="text-grey">Enter the code sent to your phone</p>

                            <div class="text-center phone-text">
                                <p><input type="text" id="auxpay-otp-code" value="" maxlength="4" /></p>
                                <p class="text-grey">Didn\'t get a code? &nbsp;&nbsp; <b>Resend</b> in (<span id="auxpay-countdown"></span><button id="auxpay-resend-otp" style="display:none;">Resend Code</button>)</p>
                            </div>

                            <div class="form-group">
                                <button class="auxpay-cancel-otp btn btn-secondary">No thanks</button>
                                <button id="auxpay-verify-otp" class="btn btn-success">Confirm & complete</button>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-done-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Please wait!</p>
                            <p class="desc text-grey">Otp Verification Successful</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <div class="text-center phone-text">
                                <h4 class="text-green">Transaction in progress...</h4>
                                <p class="text-grey">Please do not close this window.<br>If successful, you will be redirected shortly.</p>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-fail-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Declined!</p>
                            <p class="desc text-grey">Unable to complete payment</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <div class="text-center phone-text">
                                <h4 class="text-red">Payment Failed</h4>
                                <p class="text-grey">Please try again</p>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-otp-error" role="error" style="display:none;"></div>
                    <div id="auxpay-otp-success" role="success" style="display:none;"></div>
                </div>
            </div>
        `;
        
        const modalHtmlDeclinedFlow = `
            <div id="auxpay-decline-modal" class="auxpay-modal">
                <div class="auxpay-modal-content">
                    <div id="auxpay-agree-section">
                        <div class="modal-header">
                            <p class="title text-gray">Your card issuer declined this payment</p>
                            <p class="desc text-grey">Convert to gift card instead</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <h4 class="text-center text-red">Payment Declined</h4>
                            <p class="text-grey">We can still help you complete your order today. With your permission, we\'ll issue a <b>AuxCARD</b> e-gift card for <b class="text-green">$${amount}</b> and use it right away to pay for this order.</p>
                            
                            <div class="amount-text">
                                <h4 class="text-green">$${amount}</h4>
                                <label class="text-grey"><span>Transaction Amount</span></label>
                            </div>

                            <div class="form-group">
                                <p class="text-gray">You\'re in control. If you agree, we\'ll text you a 4-digit code to confirm.</p>
                            </div>

                            <div class="form-group cursor-pointer">
                                <input type="checkbox" id="auxpay-agree-terms" />
                                <label for="auxpay-agree-terms" class="text-gray">I agree to use a <b>AuxCARD</b> e-gift card to complete this order and I have read the <a class="text-blue" target="_blank" href="https://auxcard.net/program-terms">Program Terms</a> and <a class="text-blue" target="_blank" href="https://auxcard.net/privacy-policy">Privacy Notice</a>.</label>
                            </div>

                            <p class="text-grey"><b>Program Terms:</b> No extra fees. Card is single-use and valid only at AuxCARD for this order.</p>

                            <p class="text-grey"><b>Privacy Notice:</b> We use your number to send codes and receipts. See our privacy policy for details.</p>
                            
                            <div class="form-group">
                                <button class="auxpay-cancel-otp btn btn-secondary">No thanks</button>
                                <button id="auxpay-continue-otp" class="btn btn-success" disabled="true">Continue</button>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-phone-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Confirm your approval</p>
                            <p class="desc text-grey">Enter your phone number to continue</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <h4 class="text-gray">Enter your mobile number</h4>
                            <p class="text-grey">We\'ll send a 4-digit code to confirm it\'s you.</p>
                            
                            <div class="phone-text">
                                <p><b><label>Mobile Number</label></b></p>
                                <p><input type="text" id="auxpay-otp-phone" value="${phone}" /></p>
                            </div>

                            <div class="form-group">
                                <button class="auxpay-cancel-otp btn btn-secondary">No thanks</button>
                                <button id="auxpay-send-otp" class="btn btn-success">Send code</button>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-otp-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Enter your 4-digit code</p>
                            <p class="desc text-grey">Verify your identity</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <h4 class="text-gray">Enter your 4-digit code</h4>
                            <p class="text-grey">Enter the code sent to your phone</p>

                            <div class="text-center phone-text">
                                <p><input type="text" id="auxpay-otp-code" value="" maxlength="4" /></p>
                                <p class="text-grey">Didn\'t get a code? &nbsp;&nbsp; <b>Resend</b> in (<span id="auxpay-countdown"></span><button id="auxpay-resend-otp" style="display:none;">Resend Code</button>)</p>
                            </div>

                            <div class="form-group">
                                <button class="auxpay-cancel-otp btn btn-secondary">No thanks</button>
                                <button id="auxpay-verify-confirm-otp" class="btn btn-success">Confirm & complete</button>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-done-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Done!</p>
                            <p class="desc text-grey">Payment Successful</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <div class="text-center phone-text">
                                <h4 class="text-green">Payment Successful</h4>
                                <p class="text-grey">We issued a <b>AuxCARD</b> e-gift card and used it to pay for your order. You\'ll get a receipt for the gift card and your order.</p>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-fail-section" style="display:none;">
                        <div class="modal-header">
                            <p class="title text-gray">Declined!</p>
                            <p class="desc text-grey">Unable to complete payment</p>
                            <button class="auxpay-close-otp close">X</button>
                        </div>
                        <div class="modal-body">
                            <div class="text-center phone-text">
                                <h4 class="text-red">Payment Failed</h4>
                                <p class="text-grey">Please try again</p>
                            </div>
                        </div>
                    </div>
                    <div id="auxpay-otp-error" role="error" style="display:none;"></div>
                    <div id="auxpay-otp-success" role="success" style="display:none;"></div>
                </div>
            </div>
        `;

        if (WCAuxPayCard.threeds === '1') {
            $('body').append(modalHtmlOtpFlow);
            $('#auxpay-otp-modal').show();
        }
        else {
            $('body').append(modalHtmlDeclinedFlow);
            $('#auxpay-decline-modal').show();
        }

        // Close popup
        $('.auxpay-close-otp').on('click', () => {
            $('#auxpay-otp-modal').remove();
            $('#auxpay-decline-modal').remove();
        });

        // Enable continue button only if terms are agreed
        $('#auxpay-agree-terms').on('change', function() {
            if ($(this).is(':checked')) {
                $('#auxpay-continue-otp').removeAttr('disabled');
            } else {
                $('#auxpay-continue-otp').attr('disabled', true);
            }
        });

        // Continue to phone input
        $('#auxpay-continue-otp').on('click', () => {
            $('#auxpay-agree-section').hide();
            $('#auxpay-phone-section').show();
        });

        // Cancel OTP
        $('.auxpay-cancel-otp').on('click', () => {
            $('#auxpay-otp-error').hide();
            $('#auxpay-otp-success').hide();
            if (WCAuxPayCard.threeds === '1') {
                $('#auxpay-otp-modal').remove();
            }
            else {
                $('.auxpay-cancel-otp').attr('disabled', true);
                $.post(wc_checkout_params.ajax_url, {
                    action: 'auxpay_cancel_otp',
                    nonce: $('#wc_auxpay_card_nonce').val(),
                    transaction_id: transactionId,
                    order_id: orderId
                }).done(res => {
                    $('.auxpay-cancel-otp').removeAttr('disabled');
                    if (res.success) {
                        $('#auxpay-decline-modal').remove();
                    } else {
                        showOtpError(res.data.message);
                    }
                }).fail(err => {
                    console.log(err);
                    $('.auxpay-cancel-otp').removeAttr('disabled');
                    showOtpError('Error cancelling OTP. Please try again.');
                });
            }
        });

        // Send or Resend OTP
        $('#auxpay-send-otp, #auxpay-resend-otp').on('click', () => {
            $('#auxpay-otp-error').hide();
            $('#auxpay-otp-success').hide();
            $('#auxpay-otp-code').val('');
            $('#auxpay-send-otp').attr('disabled', true);
            $('#auxpay-resend-otp').attr('disabled', true);
            $.post(wc_checkout_params.ajax_url, {
                action: 'auxpay_generate_otp',
                nonce: $('#wc_auxpay_card_nonce').val(),
                phone: $('#auxpay-otp-phone').val(),
                order_id: orderId
            }).done(res => {
                $('#auxpay-send-otp').removeAttr('disabled');
                $('#auxpay-resend-otp').removeAttr('disabled');
                if (res.success) {
                    $('#auxpay-phone-section').hide();
                    $('#auxpay-otp-section').show();
                    showOtpSuccess(res.data.message);
                    startOtpCountdown(180); // 3 minutes countdown
                } else {
                    showOtpError(res.data.message);
                }
            }).fail(err => {
                console.log(err);
                $('#auxpay-send-otp').removeAttr('disabled');
                $('#auxpay-resend-otp').removeAttr('disabled');
                showOtpError('Error sending OTP. Please try again.');
            });
        });

        // Verify OTP and initiate transaction
        $('#auxpay-verify-otp').on('click', () => {
            $('#auxpay-otp-error').hide();
            $('#auxpay-otp-success').hide();
            $('#auxpay-verify-otp').attr('disabled', true);
            $.post(wc_checkout_params.ajax_url, {
                action: 'auxpay_verify_otp',
                nonce: $('#wc_auxpay_card_nonce').val(),
                phone: $('#auxpay-otp-phone').val(),
                otp: $('#auxpay-otp-code').val()
            }).done(res => {
                $('#auxpay-verify-otp').removeAttr('disabled');
                if (res.success) {
                    $('#auxpay_otp').val($('#auxpay-otp-code').val());
                    $('#auxpay-otp-section').hide();
                    $('#auxpay-done-section').show();
                    $('button[name="woocommerce_checkout_place_order"]').trigger('click');
                } else {
                    showOtpError(res.data.message);
                }
            }).fail(err => {
                console.log(err);
                $('#auxpay-verify-otp').removeAttr('disabled');
                showOtpError('Error verifying OTP. Please try again.');
            });
        });

        // Verify OTP and complete pending transaction
        $('#auxpay-verify-confirm-otp').on('click', () => {
            $('#auxpay-otp-error').hide();
            $('#auxpay-otp-success').hide();
            $('#auxpay-verify-confirm-otp').attr('disabled', true);
            $.post(wc_checkout_params.ajax_url, {
                action: 'auxpay_verify_confirm_otp',
                nonce: $('#wc_auxpay_card_nonce').val(),
                phone: $('#auxpay-otp-phone').val(),
                otp: $('#auxpay-otp-code').val(),
                transaction_id: transactionId,
                order_id: orderId
            }).done(res => {
                $('#auxpay-verify-confirm-otp').removeAttr('disabled');
                if (res.success) {
                    $('#auxpay-otp-section').hide();
                    $('#auxpay-done-section').show();
                    showOtpSuccess('Redirecting...');
                    setTimeout(() => {
                        window.location.href = res.data.redirect;
                    }, 5000);
                } else {
                    if (res.data.rerun) {
                        $('#auxpay-otp-section').hide();
                        $('#auxpay-fail-section').show();
                        setTimeout(() => {
                            $('#auxpay-decline-modal').remove();
                        }, 3000);
                    }
                    showOtpError(res.data.message);
                }
            }).fail(err => {
                console.log(err);
                $('#auxpay-verify-confirm-otp').removeAttr('disabled');
                showOtpError('Error verifying OTP. Please try again.');
            });
        });
    }

    function startOtpCountdown(durationSeconds) {
        var countdownSpan = $('#auxpay-countdown');
        var remaining = durationSeconds;
        countdownSpan.text(formatTime(remaining));
        $('#auxpay-resend-otp').hide();

        var interval = setInterval(function() {
            remaining--;
            countdownSpan.text(formatTime(remaining));
            if (remaining <= 0) {
                clearInterval(interval);
                countdownSpan.text('');
                $('#auxpay-resend-otp').show();
            }
        }, 1000);

        // Helper to format as mm:ss
        function formatTime(sec) {
            var m = Math.floor(sec / 60);
            var s = sec % 60;
            return m + ':' + (s < 10 ? '0' : '') + s;
        }
    }

    function showOtpSuccess(message) {
        $('#auxpay-otp-success').text(message);
        $('#auxpay-otp-success').show();
        setTimeout(() => {
            $('#auxpay-otp-success').hide();
        }, 5000);
    }

    function showOtpError(message) {
        $('#auxpay-otp-error').text(message);
        $('#auxpay-otp-error').show();
        setTimeout(() => {
            $('#auxpay-otp-error').hide();
        }, 5000);
    }

    function mountHostedFields() {
        if ($('input[name="payment_method"]:checked').val() === WCAuxPayCard.gatewayID) {
            setTimeout(function() {
                if (typeof WCAuxPaySDK !== 'undefined') {
                    WCAuxPaySDK.mount();
                    $('#payment_token').val('');
                    $('#payrix_form').val('no');
                }
                else if (typeof PayFields !== 'undefined') {
                    PayFields.reload();
                    $('#payment_token').val('');
                    $('#payrix_form').val('yes');
                    $('.payfields').removeClass('hide');
                    $('.payfields .label').removeClass('hide');
                }
            }, 100);
        }
    }

    function showAuxpaySuccess() {
        $('.wc-auxpay-message').remove();
        var noticeWrapper = $('.auxpay-source-message');
        var successSVG = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false" style="fill: #28a745;"><path d="M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM10 16l-4-4 1.4-1.4L10 13.2l6.6-6.6L18 8l-8 8z"></path></svg>';
        if (noticeWrapper) {
            $('<ul class="wc-auxpay-message wc-auxpay-success"><li>' + successSVG + 'Card details tokenized successfully.</li></ul>').prependTo(noticeWrapper);
        }
    }

    function showAuxpayError(err) {
        var errorMsg = err.message || err;
        $('.wc-auxpay-message').remove();
        var noticeWrapper = $('.auxpay-source-message');
        var errorSVG = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" aria-hidden="true" focusable="false" style="fill: #cc1818;"><path d="M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM11 17h2v-6h-2v6zm0-8h2V7h-2v2z"></path></svg>';
        if (noticeWrapper) {
            $('<ul class="wc-auxpay-message wc-auxpay-error"><li>' + errorSVG + errorMsg + '</li></ul>').prependTo(noticeWrapper);
        } else {
            alert(errorMsg);
        }
    }

    // Mount the hosted fields, if the payment method is selected
    $(document).on('updated_checkout', mountHostedFields);
    $('form[name="checkout"]').on('change', 'input[name="payment_method"]', mountHostedFields);

    // bind to WC classic checkout submit
    $('form[name="checkout"]').on('checkout_place_order_' + WCAuxPayCard.gatewayID, doTokenizeAndSubmit);

    // Listen for checkout errors to show OTP modal if required
    $(document).on('checkout_error', function( event, result) {
        var $otpDiv = $(result).find('.otp-required');
        if ($otpDiv.length) {
            var orderId  = $otpDiv.data('order');
            var transId  = $otpDiv.data('transaction');
            var phone    = $otpDiv.data('phone');
            var amount   = $otpDiv.data('amount');
            // Stop WooCommerce from showing the default error
            event.stopImmediatePropagation();
            // Show your modal
            showOtpModal(phone, transId, orderId, amount);
        }

        var $threedsDiv = $(result).find('.3ds-required');
        if ($threedsDiv.length) {
            var orderId  = $threedsDiv.data('order');
            var phone    = $threedsDiv.data('phone');
            var amount   = $threedsDiv.data('amount');
            // Stop WooCommerce from showing the default error
            event.stopImmediatePropagation();
            // Show your modal
            showOtpModal(phone, null, orderId, amount);
        }

        var $otpClose = $(result).find('.close-otp-model');
        if ($otpClose.length) {
            // Close OTP modal if open
            $('#auxpay-otp-modal').remove();
            $('#auxpay-decline-modal').remove();
        }
    });
});
