import { __ } from '@wordpress/i18n';
import { registerPaymentMethod } from '@woocommerce/blocks-registry';
import { decodeEntities } from '@wordpress/html-entities';
import { getSetting } from '@woocommerce/settings';
import { useState, useEffect } from '@wordpress/element';

const settings = getSetting( 'wc_auxpay_ach_data', {} );
const label = decodeEntities( settings.title || 'ACH Payment' );

const Content = (props) => {
	const { eventRegistration, emitResponse } = props;
	const { onPaymentSetup } = eventRegistration;
    const [ accountNumber, setAccountNumber ] = useState('');
    const [ routingNumber, setRoutingNumber ] = useState('');

	useEffect(() => {
		const unsubscribe = onPaymentSetup(async () => {
			if (accountNumber && routingNumber) {
				return {
					type: emitResponse.responseTypes.SUCCESS,
					meta: {
						paymentMethodData: {
							'ach_account_number': accountNumber,
                            'ach_routing_number': routingNumber,
						},
					},
				};
			}

			return {
				type: emitResponse.responseTypes.ERROR,
				message: 'Please fill in all required ach fields.',
			};
		});
		return () => {
			unsubscribe();
		};
	}, [
		emitResponse.responseTypes.ERROR,
		emitResponse.responseTypes.SUCCESS,
		onPaymentSetup,
        accountNumber,
        routingNumber
	]);

	return (
        <>
            <div dangerouslySetInnerHTML={{ __html: settings.description || '' }} />
            <div className="wc-auxpay-ach-form">
                <div className="form-row">
                    <input
                        onChange={ e => setAccountNumber(e.target.value) }
                        name="ach_account_number"
                        type="text"
                        placeholder="Account Number"
                        maxLength={15}
                        required
                    />
                </div>
                <div className="form-row">
                    <input
                        onChange={ e => setRoutingNumber(e.target.value) }
                        name="ach_routing_number"
                        type="text"
                        placeholder="Routing Number"
                        maxLength={9}
                        required
                    />
                </div>
            </div>
        </>
    );
};

const Label = ({ components }) => {
    const { PaymentMethodLabel } = components;
    return <PaymentMethodLabel text={ label } />;
};

const AuxPayAchBlocks = {
    name: 'wc_auxpay_ach',
    label: <Label />,
    ariaLabel: label,
    content: <Content />,
    edit: <Content />,
    canMakePayment: () => true,
    ariaLabel: label,
    supports: {
        features: settings.supports || [],
    }
};

registerPaymentMethod(AuxPayAchBlocks);
