<?php

$items = array(

    array(
        'tab' => 'general',
        'name' => __('Getting Started', 'kiwiblocks'),
        'url' => KIWIBLOCKS_PANEL_URL . '&tab=general.php'
    ),

    array(
        'tab' => 'settings',
        'name' => __('Settings', 'kiwiblocks'),
        'url' => KIWIBLOCKS_PANEL_URL . '&tab=settings.php'
    ),


    array(
        'tab' => 'changelog',
        'name' => __('Change Log', 'kiwiblocks'),
        'url' => KIWIBLOCKS_PANEL_URL . '&tab=changelog.php'
    ),

);

?>

<ul class="kiwi_panel_menu">
    <?php
        foreach ( $items as $item ) {

            $tab = isset($_GET['tab']) ? $_GET['tab'] : 'general.php';
            $class = '';

            if( $tab === $item['tab']){
                $class = '__active';
            }
        ?>
            <li class="<?php echo esc_attr($class); ?>">
                <a href="<?php echo esc_url($item['url']); ?>"><?php echo esc_html($item['name']); ?></a>
            </li>
        <?php
        }
    ?>
</ul>
