import { getPosts} from './../../global';
import { IconClassicBlock } from '../../icons';
import Edit from './edit';

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { withSelect } = wp.data;

registerBlockType( 'kiwiblocks/classic', {
	
	title: __( 'Classic - Kiwiblocks', 'kiwiblocks' ), 
	
	icon: IconClassicBlock, 
	
	category: 'kiwiblocks', 

	keywords: [
		__( 'classic', 'kiwiblocks' ),
		__( 'grid', 'kiwiblocks' ),
		__( 'posts', 'kiwiblocks' ),
    ],
    
    supports: {
        html:false,
    },

    edit: withSelect( getPosts ) ( Edit ),

    save: () => null,

});
