import {getPosts} from './../../global';
import { IconGridBlock } from '../../icons';
import Edit from './edit';

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { withSelect } = wp.data;

registerBlockType( 'kiwiblocks/normal', {
	
	title: __( 'Normal Grid - Kiwiblocks', 'kiwiblocks' ), 
	
	icon: IconGridBlock, 
	
	category: 'kiwiblocks', 

	keywords: [
		__( 'normal', 'kiwiblocks' ),
		__( 'grid', 'kiwiblocks' ),
		__( 'posts', 'kiwiblocks' ),
    ],
    
    supports: {
        html:false,
    },

    edit: withSelect( getPosts ) ( Edit ),

    save: () => null,

});
