import {getPosts} from './../../global';
import { IconGridBlock } from '../../icons';
import Edit from './edit';

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { withSelect } = wp.data;

registerBlockType( 'kiwiblocks/pinterest', {
	
	title: __( 'Pinterest Grid - Kiwiblocks', 'kiwiblocks' ), 
	
	icon: IconGridBlock, 
	
	category: 'kiwiblocks', 

	keywords: [
		__( 'pinterest', 'kiwiblocks' ),
		__( 'grid', 'kiwiblocks' ),
		__( 'posts', 'kiwiblocks' ),
    ],
    
    supports: {
        html:false,
    },

    edit: withSelect( getPosts ) ( Edit ),

    save: () => null,

});
