import { getPosts } from './../../global';
import { IconGridBlock } from '../../icons';
import Edit from './edit';

const { __ } = wp.i18n;
const { registerBlockType } = wp.blocks;
const { withSelect } = wp.data;

registerBlockType( 'kiwiblocks/tos1', {
	
	title: __( 'Two & Others - Kiwiblocks', 'kiwiblocks' ), 
	
	icon: IconGridBlock, 
	
	category: 'kiwiblocks', 

	keywords: [
		__( 'two', 'kiwiblocks' ),
		__( 'others', 'kiwiblocks' ),
		__( 'posts', 'kiwiblocks' ),
    ],
    
    supports: {
        html:false,
    },

    edit: withSelect( getPosts ) ( Edit ),

    save: () => null,

});
