import ColorControl from './ColorControl';

const { 
    PanelBody,
    ToggleControl,
    RangeControl,
    SelectControl,
} = wp.components;

const { __ } = wp.i18n;

const PaginationSettings = ({ attributes, setAttributes }) => {
    
    return (
        <PanelBody
            title={ __('Pagination Settings', 'kiwiblocks') }
            initialOpen={ false }
        >
            
            {attributes.hasOwnProperty('isPaginationEnabled') &&(
                <ToggleControl
                    label = { __("Enable Pagination", 'kiwiblocks') }
                    help = { attributes.isPaginationEnabled ? __("Enabled", 'kiwiblocks') : __("Disabled", 'kiwiblocks') }
                    checked = { attributes.isPaginationEnabled }
                    onChange = { isPaginationEnabled => setAttributes({ isPaginationEnabled }) }
                />
            )}

            {attributes.hasOwnProperty('paginationMaxPages') &&(
                <RangeControl
                    label = { __("Max Pages", 'kiwiblocks') }
                    value = { attributes.paginationMaxPages }
                    onChange = { paginationMaxPages => setAttributes({ paginationMaxPages }) }
                    min={ 1 }
                    max={ 100 }
                />
            )}

            {attributes.hasOwnProperty('paginationPos') &&(
                <SelectControl
                    label = { __("Position", 'kiwiblocks') }
                    value = { attributes.paginationPos }
                    onChange = { paginationPos => setAttributes({ paginationPos }) }
                    options={ [
                        { label: __('Top', 'kiwiblocks'), value: 'top' },
                        { label: __('Bottom', 'kiwiblocks'), value: 'bottom' },
                    ] }
                />
            )}

            {attributes.hasOwnProperty('paginationColor') &&(
                <ColorControl
                    label = { __('Numbers Color', 'kiwiblocks') }
                    value = { attributes.paginationColor }
                    onChange={ ( paginationColor ) => setAttributes({ paginationColor }) } 
                />
            )}

            {attributes.hasOwnProperty('paginationBgColor') &&(
                <ColorControl
                    label = { __('Numbers Background Color', 'kiwiblocks') }
                    value = { attributes.paginationBgColor }
                    onChange={ ( paginationBgColor ) => setAttributes({ paginationBgColor }) } 
                />
            )}

            {attributes.hasOwnProperty('paginationActiveColor') &&(
                <ColorControl
                    label = { __('Active Number Color', 'kiwiblocks') }
                    value = { attributes.paginationActiveColor }
                    onChange={ ( paginationActiveColor ) => setAttributes({ paginationActiveColor }) } 
                />
            )}

            {attributes.hasOwnProperty('paginationActiveBgColor') &&(
                <ColorControl
                    label = { __('Active Number Background Color', 'kiwiblocks') }
                    value = { attributes.paginationActiveBgColor }
                    onChange={ ( paginationActiveBgColor ) => setAttributes({ paginationActiveBgColor }) } 
                />
            )}
            
        </PanelBody>

    );

}

export default PaginationSettings;
