<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Classic Block
 */
class Kiwiblocks_Classic extends Kiwiblocks_Block{

    /**
     * Constructor
     */
    function __construct(){

        $this->name = 'classic';
        $this->slug = 'kiwiblocks/classic';

        $this->attributes = array(
            'uid' => array(
                'type' => 'string',
                'default' => ''
            ),
            'categoriesSelected' => array(
                'type' => 'array',
                'default' => array(),
                'items'   => [
                    'type' => 'object',
                ]
            ),
            'postsNumber' => array(
                'type' => 'number',
                'default' => 6
            ),
            'isAuthorVisible' => array(
                'type' => 'boolean',
                'default' => true
            ),
            'isDateVisible' => array(
                'type' => 'boolean',
                'default' => true
            ),
            'areCategoriesVisible' => array(
                'type' => 'boolean',
                'default' => true
            ),
            'fontSize' => array(
                'type' => 'number',
                'default' => 16
            ),
            'tabletFontSize' => array(
                'type' => 'number',
                'default' => 16
            ),
            'mobileFontSize' => array(
                'type' => 'number',
                'default' => 16
            ),
            'titleColor' => array(
                'type' => 'string',
                'default' => '#5e35b1'
            ),
            'categoryColor' => array(
                'type' => 'string',
                'default' => '#e53935'
            ),
            'dateColor' => array(
                'type' => 'string',
                'default' => '#777777'
            ),
            'authorColor' => array(
                'type' => 'string',
                'default' => '#777777'
            ),
            'excerptColor' => array(
                'type' => 'string',
                'default' => '#555555'
            ),
            'readmoreColor' => array(
                'type' => 'string',
                'default' => '#ffffff'
            ),
            'readmoreBGColor' => array(
                'type' => 'string',
                'default' => '#d32f2f'
            ),
            'bottomBorderColor' => array(
                'type' => 'string',
                'default' => '#f1f1f1'
            ),
            'hasBorderedImage' => array(
                'type' => 'boolean',
                'default' => false,
            ),
            'marginTop' => array(
                'type' => 'number',
                'default' => 0
            ),
            'marginBottom' => array(
                'type' => 'number',
                'default' => 20
            ),
            'paddingTop' => array(
                'type' => 'number',
                'default' => 20
            ),
            'paddingBottom' => array(
                'type' => 'number',
                'default' => 20
            ),
            'paddingLeft' => array(
                'type' => 'number',
                'default' => 0
            ),
            'paddingRight' => array(
                'type' => 'number',
                'default' => 0
            ),
            'backgroundColor' => array(
                'type' => 'string',
                'default' => 'rgba(0,0,0,0)'
            ),
            'isExcerptVisible' => array(
                'type' => 'boolean',
                'default' => true,
            ),
            'isPaginationEnabled' => array(
                'type' => 'boolean',
                'default' => false,
            ),
            'paginationMaxPages' => array(
                'type' => 'number',
                'default' => 3,
            ),
            'paginationPos' => array(
                'type' => 'string',
                'default' => 'top',
            ),
            'paginationColor' => array(
                'type' => 'string',
                'default' => '#333333',
            ),
            'paginationBgColor' => array(
                'type' => 'string',
                'default' => '#e9e9e9',
            ),
            'paginationActiveColor' => array(
                'type' => 'string',
                'default' => '#ffffff',
            ),
            'paginationActiveBgColor' => array(
                'type' => 'string',
                'default' => '#d32f2f',
            ),
            'isReadMoreVisible' => array(
                'type' => 'boolean',
                'default' => true
            ),
            'readMoreText' => array(
                'type' => 'string',
                'default' => __('Read More', 'kiwiblocks')
            ),
            'postsOrder' => array(
                'type' => 'string',
                'default' => 'date'
            ),
        );

        add_action( 'init', array( $this, 'init' ) );
        add_action( 'wp_ajax_kiwiblocks_' . $this->name , array( $this, 'ajaxRender' ));
        add_action( 'wp_ajax_nopriv_kiwiblocks_' . $this->name, array( $this, 'ajaxRender' ));
    }

    /**
     * Render Style
     * 
     * @param array $attributes
     */
    protected function renderStyle( $attributes ){

        extract( $attributes );
    
        return "
            #{$uid}.kiwiblocks--classic{
                font-size: {$mobileFontSize}px;
                padding: {$paddingTop}px {$paddingRight}px {$paddingBottom}px {$paddingLeft}px;
                margin-top: {$marginTop}px;
                margin-bottom: {$marginBottom}px;
                background-color: {$backgroundColor};
            }

            #{$uid}.kiwiblocks--classic .kiwiblocks__entry{
                border-color: {$bottomBorderColor};
            }

            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__title a,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__title a:focus,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__title a:hover,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__title a:visited{
                color: {$titleColor};
            }
    
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__meta{
                color: {$dateColor};
            }
    
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__meta .kiwiblocks__entry__author,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__meta .kiwiblocks__entry__author:hover,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__meta .kiwiblocks__entry__author:focus,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__meta .kiwiblocks__entry__author:visited{
                color: {$authorColor};
            }

            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__categories a,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__categories a:hover,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__categories a:focus,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__categories a:visited{
                color: {$categoryColor};
            }
    
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__excerpt{
                color: {$excerptColor};
            }
    
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__readmore,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__readmore:hover,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__readmore:focus,
            #{$uid}.kiwiblocks--classic .kiwiblocks__entry__readmore:visited{
                color: {$readmoreColor};
                background-color: {$readmoreBGColor};
            }   

            #{$uid}.kiwiblocks--classic .kiwiblocks__pagination span{
                color: {$paginationColor};
                background-color: {$paginationBgColor};
            }
    
            #{$uid}.kiwiblocks--classic .kiwiblocks__pagination span.__active{
                color: {$paginationActiveColor};
                background-color: {$paginationActiveBgColor};
            }

            @media all and (min-width: 768px) {
                #{$uid}.kiwiblocks--classic{
                    font-size: {$tabletFontSize}px;
                }
            }
    
            @media all and (min-width: 992px) {
                #{$uid}.kiwiblocks--classic{
                    font-size: {$fontSize}px;
                }
            }
        ";
    
    }

}

new Kiwiblocks_Classic;
