import SearchListControl from './SearchList';

const { 
    PanelBody,
    RangeControl,
    SelectControl,
} = wp.components;

const { __ } = wp.i18n;

const CategoriesSettings = ({ attributes, categories, setAttributes }) => {

    return (

        <PanelBody
            title={ __('Posts & Categories', 'kiwiblocks') }
            initialOpen={ true }
        >

            <RangeControl
                label = { __( 'Number of Posts', 'kiwiblocks' ) }
                value = { attributes.postsNumber }
                min = { 1 }
                max = { 100 }
                step = { 1 }
                onChange = { postsNumber => setAttributes({ postsNumber }) } 
            />

            {attributes.hasOwnProperty('readmoreColor') &&(
                <SelectControl
                    label = { __( 'Posts Order', 'kiwiblocks' ) }
                    value = { attributes.postsOrder }
                    options={ [
                        { label: __('Latest', 'kiwiblocks'), value: 'date' },
                        { label: __('Author', 'kiwiblocks'), value: 'author' },
                        { label: __('Modified', 'kiwiblocks'), value: 'modified' },
                        { label: __('Title', 'kiwiblocks'), value: 'title' },
                        { label: __('Random (Only Frontend)', 'kiwiblocks'), value: 'rand' },
                    ] }
                    onChange = { postsOrder => setAttributes({ postsOrder }) } 
                />
            )}

            <SearchListControl 
                label={ __('Select Categories', 'kiwiblocks') }
                className={ "kiwiblocks-categories" }
                list = { categories ? categories : [] } 
                selected = { attributes.categoriesSelected ? attributes.categoriesSelected : [] }
                onChange= { ( value = [] ) => setAttributes({ categoriesSelected: value }) }
            ></SearchListControl>

        </PanelBody>
        
    );

}

export default CategoriesSettings;
