import ColorControl from './ColorControl';

const { 
    PanelBody,
} = wp.components;

const { __ } = wp.i18n;

const ColorSettings = ({ attributes, setAttributes }) => {

    return (

        <PanelBody
            title={ __('Color Settings', 'kiwiblocks') }
            initialOpen={ false }
        >

            {attributes.hasOwnProperty('backgroundColor') &&(
                <ColorControl
                    label = { __('Background', 'kiwiblocks') }
                    value = { attributes.backgroundColor }
                    onChange={ ( backgroundColor ) => setAttributes({ backgroundColor }) } 
                />
            )}

            {attributes.hasOwnProperty('borderColor') &&(
                <ColorControl
                    label = { __('Border', 'kiwiblocks') }
                    value = { attributes.borderColor }
                    onChange={ ( borderColor ) => setAttributes({ borderColor }) } 
                />
            )}

            {attributes.hasOwnProperty('bottomBorderColor') &&(
                <ColorControl
                    label = { __('Bottom Border', 'kiwiblocks') }
                    value = { attributes.bottomBorderColor }
                    onChange={ ( bottomBorderColor ) => setAttributes({ bottomBorderColor }) } 
                />
            )}

            <ColorControl
                label = { __('Title', 'kiwiblocks') }
                value = { attributes.titleColor }
                onChange={ ( titleColor ) => setAttributes({ titleColor }) } 
            />

            <ColorControl
                label = { __('Author', 'kiwiblocks') }
                value = { attributes.authorColor }
                onChange={ ( authorColor ) => setAttributes({ authorColor }) } 
            />

            <ColorControl
                label = { __('Date', 'kiwiblocks') }
                value = { attributes.dateColor }
                onChange={ ( dateColor ) => setAttributes({ dateColor }) } 
            />

            <ColorControl
                label = { __('Categories', 'kiwiblocks') }
                value = { attributes.categoryColor }
                onChange={ ( categoryColor ) => setAttributes({ categoryColor }) } 
            />

            <ColorControl
                label = { __('Excerpt', 'kiwiblocks') }
                value = { attributes.excerptColor }
                onChange={ ( excerptColor ) => setAttributes({ excerptColor }) } 
            />

            {attributes.hasOwnProperty('readmoreColor') &&(
                <ColorControl
                    label = { __('Read More Button', 'kiwiblocks') }
                    value = { attributes.readmoreColor }
                    onChange={ ( readmoreColor ) => setAttributes({ readmoreColor }) } 
                />
            )}

            {attributes.hasOwnProperty('readmoreBGColor') &&(
                <ColorControl
                    label = { __('Read More Button Background', 'kiwiblocks') }
                    value = { attributes.readmoreBGColor }
                    onChange={ ( readmoreBGColor ) => setAttributes({ readmoreBGColor }) } 
                />
            )}

        </PanelBody>

    );

}

export default ColorSettings;
