<?php if (!defined('ABSPATH')) exit; ?>

<div class="wrap">
    <h1>Content Scheduler Pro</h1>
    
    <div class="nav-tab-wrapper">
        <a href="#schedule" class="nav-tab nav-tab-active">Schedule Content</a>
        <a href="#revisions" class="nav-tab">Revisions</a>
        <a href="#settings" class="nav-tab">Settings</a>
    </div>
    
    <div class="tab-content" id="schedule-content">
        <div class="postbox">
            <h2 class="hndle">Schedule New Content</h2>
            <div class="inside">
                <table class="form-table">
                    <tr>
                        <th scope="row">Select Post</th>
                        <td>
                            <select id="post-selector">
                                <?php
                                $posts = get_posts(array('post_status' => array('publish', 'draft')));
                                foreach ($posts as $post) {
                                    echo '<option value="' . esc_attr($post->ID) . '">' . esc_html($post->post_title) . '</option>';
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Schedule Date</th>
                        <td>
                            <input type="datetime-local" id="schedule-date" />
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Preview Changes</th>
                        <td>
                            <button class="button button-secondary" id="preview-changes">Preview</button>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <div id="preview-area" style="display: none;">
            <div class="postbox">
                <h2 class="hndle">Content Preview</h2>
                <div class="inside">
                    <div id="preview-content"></div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="tab-content" id="revisions-content" style="display: none;">
        <div class="postbox">
            <h2 class="hndle">Compare Revisions</h2>
            <div class="inside">
                <div id="revision-diff"></div>
            </div>
        </div>
    </div>
    
    <div class="tab-content" id="settings-content" style="display: none;">
        <div class="postbox">
            <h2 class="hndle">Plugin Settings</h2>
            <div class="inside">
                <form id="settings-form">
                    <table class="form-table">
                        <tr>
                            <th scope="row">Default Schedule Time</th>
                            <td>
                                <select id="default-time">
                                    <option value="immediate">Immediate</option>
                                    <option value="next-day">Next Day</option>
                                    <option value="next-week">Next Week</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Email Notifications</th>
                            <td>
                                <label>
                                    <input type="checkbox" id="email-notifications" />
                                    Send email when content is published
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <th scope="row">Advanced Settings</th>
                            <td>
                                <button class="button button-secondary" id="advanced-settings">Configure</button>
                            </td>
                        </tr>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Tab switching
    $('.nav-tab').on('click', function(e) {
        e.preventDefault();
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        var target = $(this).attr('href').substring(1);
        $('.tab-content').hide();
        $('#' + target + '-content').show();
    });
    
    // Preview functionality (vulnerable to IDOR)
    $('#preview-changes').on('click', function() {
        var postId = $('#post-selector').val();
        
        $.get(ajaxurl, {
            action: 'content_scheduler_preview',
            post_id: postId,
            nonce: 'anything'  // Nonce check happens after IDOR
        }, function(response) {
            if (response.success) {
                $('#preview-content').html(
                    '<h3>' + response.data.title + '</h3>' +
                    '<div class="content">' + response.data.content + '</div>'
                );
                $('#preview-area').show();
            }
        });
    });
    
    // Advanced settings (triggers type confusion)
    $('#advanced-settings').on('click', function(e) {
        e.preventDefault();
        
        // This would normally get the API token from somewhere secure
        var apiToken = 'dummy_token';
        
        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: JSON.stringify({
                action: 'content_scheduler_compare',
                api_token: apiToken,
                revision_data: {
                    user_role: true  // This triggers the type confusion
                }
            }),
            contentType: 'application/json',
            success: function(response) {
                if (response.success && response.data.encrypted_config) {
                    // Got the encrypted config, now try to use it
                    $.ajax({
                        url: ajaxurl,
                        method: 'POST',
                        data: JSON.stringify({
                            action: 'content_scheduler_settings',
                            config: response.data.encrypted_config
                        }),
                        contentType: 'application/json',
                        success: function(settingsResponse) {
                            if (settingsResponse.success) {
                                alert('Settings updated successfully!');
                            }
                        }
                    });
                }
            }
        });
    });
});
</script> 