( function( $ ){
    $( document ).ready( function(){
        let element, textareaVal, copyTextFromTextarea;

        $( '.login-customizer-snackbar-close' ).on( 'click', function( e ){
            e.preventDefault();

            $( '.login-customizer-snackbar-hide-2000' ).hide();
        } );

        copyTextFromTextarea = ( object ) => {
            object.select();
            document.execCommand( 'copy' );
            return $( object ).val();
        };

        $( '#login-customizer-export-btn' ).on( 'click', function( e ){
            e.preventDefault();

            element = $( this ).attr( 'data-login-customizer-export-element' );
            $( element ).show( 'slow' );
            $( '#login-customizer-import-container' ).hide( 'slow' );

            $.get( ajaxurl, { method: 'get_latest_json', _wpnonce: login_customizer_file_import_object.nonce, action: 'login_customizer_import_json' }, function( response ){
                textareaVal = $( '#login-customizer-export-textarea' ).val( response.data.jsonContent );
            } );
        } );

        $( '#login-customizer-export-btn' ).on( 'click', function( e ){
            e.preventDefault();

            element = $( this ).attr( 'data-login-customizer-copy-element' );
            textareaVal = copyTextFromTextarea( $( element ) );

            $( '.login-customizer-snackbar-hide-2000' ).show();

            setTimeout( function(){
                $( '.login-customizer-snackbar-hide-2000' ).hide(  );
            }, 2000);
        } );

        $( '#login-customizer-import-btn' ).on( 'click', function( e ){
            e.preventDefault();

            element = $( this ).attr( 'data-login-customizer-import-element' );
            $( element ).show( 'slow' );
            $( '#login-customizer-export-container' ).hide( 'slow' );
        } );

        $( '#login-customizer-import-btn' ).on( 'click', function( e ){
            e.preventDefault();

            element = $( this ).attr( 'data-login-customizer-import-json-element' );
            textareaVal = $( element ).val();

            $.post( ajaxurl, { method: 'import', _wpnonce: login_customizer_file_import_object.nonce, jsonFile: textareaVal, action: 'login_customizer_import_json' }, function( response ){
                window.location.href = window.location.href;
            } );
        } );
    } );
}( jQuery ) );