/**
 * Customizer Events Communicator.
 */
( function ( exports, $ ) {
	"use strict";

	var api = wp.customize, LoginCustomizerOldPreviewer;

	var all_controls = {
		'logo' : [
			'login_customizer[logo_title]',
			'login_customizer[logo]',
			'login_customizer[logo_width]',
			'login_customizer[logo_height]',
			'login_customizer[logo_margin_bottom]',
			'login_customizer_settings[logo_url]',
			'login_customizer[disable_logo]',
		],
		'form' : [
			'login_customizer[form_title]',
			'login_customizer[form_width]',
			'login_customizer[form_radius]',
			'login_customizer[form_bg]',
			'login_customizer[form_bg_transparency]',
			'login_customizer[form_vertical_padding]',
			'login_customizer[form_side_padding]',
			'login_customizer[form_shadow]',
			'login_customizer[form_shadow_opacity]',
		],
		'fields' : [
			'login_customizer[fields_title]',
			'login_customizer[field_bg]',
			'login_customizer[field_border]',
			'login_customizer[field_border_color]',
			'login_customizer[field_radius]',
			'login_customizer[field_padding_top]',
			'login_customizer[field_padding_bottom]',
			'login_customizer[field_side_padding]',
			'login_customizer[field_margin_bottom]',
			'login_customizer[field_shadow]',
			'login_customizer[field_shadow_opacity]',
			'login_customizer[field_shadow_inset]',
			'login_customizer[field_text_title]',
			'login_customizer[field_font]',
			'login_customizer[field_font_size]',
			'login_customizer[field_color]',
		],
		'labels' : [
			'login_customizer[labels_title]',
			'login_customizer[label_font]',
			'login_customizer[label_font_size]',
			'login_customizer[label_color]',
			'login_customizer[label_position]',
			'login_customizer[username_label]',
			'login_customizer[password_label]',
		],
		'button' : [
			'login_customizer[button_title]',
			'login_customizer[button_bg]',
			'login_customizer[button_padding_top]',
			'login_customizer[button_padding_bottom]',
			'login_customizer[button_side_padding]',
			'login_customizer[button_border]',
			'login_customizer[button_border_color]',
			'login_customizer[button_radius]',
			'login_customizer[button_shadow]',
			'login_customizer[button_shadow_opacity]',
			'login_customizer[button_text_title]',
			'login_customizer[button_font]',
			'login_customizer[button_font_size]',
			'login_customizer[button_color]',
		],
		'background' : [
			'login_customizer[bg_title]',
			'login_customizer[bg_image]',
			'login_customizer[bg_color]',
			'login_customizer[bg_repeat]',
			'login_customizer[bg_size]',
			'login_customizer[bg_attach]',
			'login_customizer[bg_position]',
			'login_customizer[bg_image_gallery]',
		],
		'remember' : [
			'login_customizer[remember_title]',
			'login_customizer[remember_color]',
			'login_customizer[remember_font]',
			'login_customizer[remember_font_size]',
			'login_customizer[remember_position]',
			'login_customizer[remember_hide]',
		],
		'checkbox' : [
			'login_customizer[checkbox_title]',
			'login_customizer[checkbox_size]',
			'login_customizer[checkbox_bg]',
			'login_customizer[checkbox_border]',
			'login_customizer[checkbox_border_color]',
			'login_customizer[checkbox_radius]',
		],
		'below' : [
			'login_customizer[below_title]',
			'login_customizer[lost_password]',
			'login_customizer[back_to]',
			'login_customizer[below_color]',
			'login_customizer[below_position]',
			'login_customizer[below_font]',
			'login_customizer[below_font_size]',
		],
	};

	function active_control( section ) {

		all_controls.logo.forEach(function(item, index, array) {
			control_visibility( all_controls.logo, 'deactivate' );
		});

		all_controls.form.forEach(function(item, index, array) {
			control_visibility( all_controls.form, 'deactivate' );
		});

		all_controls.fields.forEach(function(item, index, array) {
			control_visibility( all_controls.fields, 'deactivate' );
		});

		all_controls.labels.forEach(function(item, index, array) {
			control_visibility( all_controls.labels, 'deactivate' );
		});

		all_controls.button.forEach(function(item, index, array) {
			control_visibility( all_controls.button, 'deactivate' );
		});

		all_controls.background.forEach(function(item, index, array) {
			control_visibility( all_controls.background, 'deactivate' );
		});

		all_controls.remember.forEach(function(item, index, array) {
			control_visibility( all_controls.remember, 'deactivate' );
		});

		all_controls.checkbox.forEach(function(item, index, array) {
			control_visibility( all_controls.checkbox, 'deactivate' );
		});

		all_controls.below.forEach(function(item, index, array) {
			control_visibility( all_controls.below, 'deactivate' );
		});

		control_visibility( section, 'activate' );
	}

	/**
	 * Function to hide/show Customizer options, based on another control.
	 *
	 * Parent option, Affected Control, Value which affects the control.
	 */
	function customizer_image_option_display( parent_setting, affected_control, custom_logic ) {
		wp.customize( parent_setting, function( setting ) {
			wp.customize.control( affected_control, function( control ) {
				var visibility = function() {
					if ( setting.get() && 'none' !== setting.get() && '0' !== setting.get() ) {
						control.activate( { duration: 0 } );
						control.container.slideDown( 0 );
					} else {
						control.container.slideUp( 0 );
						control.deactivate( { duration: 0 } );
					}

					if ( custom_logic ) {
						if ( 'cover' === wp.customize( 'login_customizer[bg_size]' ).get() ) {
							console.log( 'clicked' )
							control.activate( { duration: 0 } );
							control.container.slideUp( 0 );
						} else {
							control.container.slideDown( 0 );
							control.deactivate( { duration: 0 } );
						}
					}
				};

				visibility();
				setting.bind( visibility );
			});
		});
	}

	/**
	 * Function to hide/show Customizer options, based on another control.
	 *
	 * Parent option, Affected Control, Value which affects the control.
	 */
	function customizer_no_image_option_display( parent_setting, affected_control ) {
		wp.customize( parent_setting, function( setting ) {
			wp.customize.control( affected_control, function( control ) {
				var visibility = function() {
					if ( setting.get() ) {
						control.container.slideUp( 0 );
						control.deactivate( { duration: 0 } );
					}  else {
						control.container.slideDown( 0 );
						control.activate( { duration: 0 } );
					}
				};

				visibility();
				setting.bind( visibility );
			});
		});
	}

	/**
	 * Function to hide/show Customizer options, based on a range control value.
	 *
	 * Parent option, Affected Control, Value which affects the control.
	 */
	function customizer_range_option_display( parent_setting, affected_control, value ) {
		wp.customize( parent_setting, function( setting ) {
			wp.customize.control( affected_control, function( control ) {
				var visibility = function() {
					if ( setting.get() && '0' !== setting.get() ) {
						control.container.slideDown( 0 );
					} else {
						control.container.slideUp( 180 );
					}
				};

				visibility();
				setting.bind( visibility );
			});
		});
	}

	/**
	 * Function to hide/show Customizer options, based on a checkbox value.
	 *
	 * Parent option, Affected Control, Value which affects the control.
	 */
	function customizer_checkbox_option_display( parent_setting, affected_control, value ) {
		wp.customize( parent_setting, function( setting ) {
			wp.customize.control( affected_control, function( control ) {
				var visibility = function() {
					if ( value === setting.get() ) {
						control.container.slideDown( 0 );
					} else {
						control.container.slideUp( 0 );
					}
				};

				visibility();
				setting.bind( visibility );
			});
		});
	}

	/**
	 * Function to hide/show Customizer options, based on a select value.
	 *
	 * Parent option, Affected Control, Value which affects the control.
	 */
	function customizer_select_option_display( parent_setting, affected_control, value ) {
		wp.customize( parent_setting, function( setting ) {
			wp.customize.control( affected_control, function( control ) {
				var visibility = function() {
					if ( value !== setting.get() ) {
						control.container.slideDown( 100 );
					} else {
						control.container.slideUp( 100 );
					}
				};

				visibility();
				setting.bind( visibility );
			});
		});
	}

	function control_visibility( controls, action ) {

		controls.forEach( function( item, index, array ) {

			if ( action === 'activate' ) {

				// For this particular control, let's check to see if corresponding options are visible.
				// We only want to show relevant options based on the user's contextual design decisions.
				if ( item === 'login_customizer[logo_margin_bottom]' ) {

					customizer_checkbox_option_display( 'login_customizer[disable_logo]', 'login_customizer[logo_margin_bottom]', false );

					wp.customize( 'login_customizer[disable_logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								} else {
									// If there's no custom background image, let's show the gallery.
									wp.customize.control( item ).activate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[logo_height]' ) {

					// Only show the logo height option, if there is a logo uploaded.
					customizer_image_option_display( 'login_customizer[logo]', 'login_customizer[logo_height]' );

					wp.customize( 'login_customizer[disable_logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									// If not, let's quickly hide it.
									wp.customize.control( item ).deactivate( { duration: 0 } );
								} else {
									// Only show the width if there is a logo uploaded.
									if ( wp.customize.control( 'login_customizer[logo]' ).setting.get() ) {
										wp.customize.control( item ).activate( { duration: 0 } );
									}
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

					wp.customize( 'login_customizer[logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( setting.get() ) {
									// If there is a background image or gallery image, but neither are set to "none".
									wp.customize.control( item ).activate( { duration: 0 } );
								} else {
									// If not, let's quickly hide it.
									wp.customize.control( item ).deactivate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[logo_width]' ) {

					// Only show the logo width option, if there is a logo uploaded.
					customizer_image_option_display( 'login_customizer[logo]', 'login_customizer[logo_width]' );

					wp.customize( 'login_customizer[disable_logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									wp.customize.control( item ).deactivate( { duration: 0 } );
								} else {

									// Only show the width if there is a logo uploaded.
									if ( wp.customize.control( 'login_customizer[logo]' ).setting.get() ) {
										wp.customize.control( item ).activate( { duration: 0 } );
									}
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

					wp.customize( 'login_customizer[logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( setting.get() ) {
									// If there is a background image or gallery image, but neither are set to "none".
									wp.customize.control( item ).activate( { duration: 0 } );
								} else {
									// If not, let's quickly hide it.
									wp.customize.control( item ).deactivate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[logo]' ) {

					customizer_checkbox_option_display( 'login_customizer[disable_logo]', 'login_customizer[logo]', false );

					wp.customize( 'login_customizer[disable_logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								} else {
									// If there's no custom background image, let's show the gallery.
									wp.customize.control( item ).activate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[logo_title]' ) {

					customizer_checkbox_option_display( 'login_customizer[disable_logo]', 'login_customizer[logo_title]', false );

					wp.customize( 'login_customizer[disable_logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								} else {
									// If there's no custom background image, let's show the gallery.
									wp.customize.control( item ).activate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer_settings[logo_url]' ) {

					customizer_checkbox_option_display( 'login_customizer[disable_logo]', 'login_customizer_settings[logo_url]', false );

					wp.customize( 'login_customizer[disable_logo]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								} else {
									// If there's no custom background image, let's show the gallery.
									wp.customize.control( item ).activate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[form_bg]' ) {

					customizer_checkbox_option_display( 'login_customizer[form_bg_transparency]', 'login_customizer[form_bg]', false );

					wp.customize( 'login_customizer[form_bg_transparency]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( true === setting.get() ) {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								} else {
									// If there's no custom background image, let's show the gallery.
									wp.customize.control( item ).activate( { duration: 0 } );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[bg_image_gallery]' ) {
						customizer_no_image_option_display( 'login_customizer[bg_image]', 'login_customizer[bg_image_gallery]' );

						wp.customize( 'login_customizer[bg_image]', function( setting ) {
							wp.customize.control( item, function( control ) {
								var visibility = function() {

									if ( ! setting.get() ) {
										// If there's no custom background image, let's show the gallery.
										wp.customize.control( item ).activate( { duration: 0 } );
									} else {
										// If not, let's quickly hide it.
										control.container.slideUp( 0 );
									}
								};

								visibility();
								setting.bind( visibility );
							});
						});
				} else if ( item === 'login_customizer[bg_repeat]' ) {

					// Only show the background options, if there is a background image uploaded.
					customizer_image_option_display( 'login_customizer[bg_image]', 'login_customizer[bg_repeat]' );
					customizer_image_option_display( 'login_customizer[bg_image_gallery]', 'login_customizer[bg_repeat]' );

					$.each( [ 'login_customizer[bg_image]', 'login_customizer[bg_image_gallery]' ], function( index, settingId ) {
						wp.customize( settingId, function( setting ) {
							wp.customize.control( item, function( control ) {
								var visibility = function() {

									if ( setting.get() && 'none' !== setting.get() ) {
										// If there is a background image or gallery image, but neither are set to "none".
										wp.customize.control( item ).activate( { duration: 0 } );
									} else {
										// If not, let's quickly hide it.
										control.container.slideUp( 0 );
									}
								};

								visibility();
								setting.bind( visibility );
							} );
						} );
					} );

				} else if ( item === 'login_customizer[bg_size]' ) {

					customizer_image_option_display( 'login_customizer[bg_image]', 'login_customizer[bg_size]' );
					customizer_image_option_display( 'login_customizer[bg_image_gallery]', 'login_customizer[bg_size]' );

					$.each( [ 'login_customizer[bg_image]', 'login_customizer[bg_image_gallery]' ], function( index, settingId ) {

						wp.customize( settingId, function( setting ) {
							wp.customize.control( item, function( control ) {
								var visibility = function() {

									if ( setting.get() && 'none' !== setting.get() ) {
										// If there is a background image or gallery image, but neither are set to "none".
										wp.customize.control( item ).activate( { duration: 0 } );
									} else {
										// If not, let's quickly hide it.
										control.container.slideUp( 0 );
									}
								};

								visibility();
								setting.bind( visibility );
							} );
						} );
					} );

				} else if ( item === 'login_customizer[bg_attach]' ) {

					customizer_image_option_display( 'login_customizer[bg_image]', 'login_customizer[bg_attach]' );
					customizer_image_option_display( 'login_customizer[bg_image_gallery]', 'login_customizer[bg_attach]' );

					$.each( [ 'login_customizer[bg_image]', 'login_customizer[bg_image_gallery]' ], function( index, settingId ) {

						wp.customize( settingId, function( setting ) {
							wp.customize.control( item, function( control ) {
								var visibility = function() {

									if ( setting.get() && 'none' !== setting.get() ) {
										// If there is a background image or gallery image, but neither are set to "none".
										wp.customize.control( item ).activate( { duration: 0 } );
									} else {
										// If not, let's quickly hide it.
										control.container.slideUp( 0 );
									}
								};

								visibility();
								setting.bind( visibility );
							} );
						} );
					} );

				} else if ( item === 'login_customizer[bg_position]' ) {

					customizer_image_option_display( 'login_customizer[bg_image]', 'login_customizer[bg_position]' );
					customizer_image_option_display( 'login_customizer[bg_image_gallery]', 'login_customizer[bg_position]', true );

					customizer_select_option_display( 'login_customizer[bg_size]', 'login_customizer[bg_position]', 'cover' );

					$.each( [ 'login_customizer[bg_image]', 'login_customizer[bg_image_gallery]' ], function( index, settingId ) {

						wp.customize( settingId, function( setting ) {
							wp.customize.control( item, function( control ) {
								var visibility = function() {

									if ( setting.get() && 'none' !== setting.get() ) {
										// If there is a background image or gallery image, but neither are set to "none".
										wp.customize.control( item ).activate( { duration: 0 } );
									} else {
										// If not, let's quickly hide it.
										control.container.slideUp( 0 );
									}
								};

								visibility();
								setting.bind( visibility );
							} );
						} );
					} );

				} else if ( item === 'login_customizer[form_shadow_opacity]' ) {

					customizer_range_option_display( 'login_customizer[form_shadow]', 'login_customizer[form_shadow_opacity]', '0' );

					wp.customize( 'login_customizer[form_shadow]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[field_shadow_opacity]' ) {

					customizer_range_option_display( 'login_customizer[field_shadow]', 'login_customizer[field_shadow_opacity]', '0' );

					wp.customize( 'login_customizer[field_shadow]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[field_shadow_inset]' ) {

					customizer_range_option_display( 'login_customizer[field_shadow]', 'login_customizer[field_shadow_inset]', '0' );

					wp.customize( 'login_customizer[field_shadow]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
									// console.log( 'has a shadow' );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
									// console.log( 'no shadow' );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				}

				else if ( item === 'login_customizer[field_border_color]' ) {

					customizer_range_option_display( 'login_customizer[field_border]', 'login_customizer[field_border_color]', '0' );

					wp.customize( 'login_customizer[field_border]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
									// console.log( 'border' );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
									// console.log( 'no border' );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[button_border_color]' ) {

					customizer_range_option_display( 'login_customizer[button_border]', 'login_customizer[button_border_color]', '0' );

					wp.customize( 'login_customizer[button_border]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
									// console.log( 'border' );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
									// console.log( 'no border' );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[button_shadow_opacity]' ) {

					customizer_range_option_display( 'login_customizer[button_shadow]', 'login_customizer[button_shadow_opacity]', '0' );

					wp.customize( 'login_customizer[button_shadow]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				} else if ( item === 'login_customizer[checkbox_border_color]' ) {

					customizer_range_option_display( 'login_customizer[checkbox_border]', 'login_customizer[checkbox_border_color]', '0' );

					wp.customize( 'login_customizer[checkbox_border]', function( setting ) {
						wp.customize.control( item, function( control ) {
							var visibility = function() {

								if ( '0' < setting.get() ) {
									// If there is a custom logo uploaded, let's show the bottom positioning option.
									wp.customize.control( item ).activate( { duration: 0 } );
								} else {
									// If not, let's quickly hide it.
									control.container.slideUp( 0 );
								}
							};

							visibility();
							setting.bind( visibility );
						});
					});

				}  else {
					wp.customize.control( item ).activate( { duration: 0 } );
				}
			} else {
				wp.customize.control( item ).deactivate( { duration: 0 } );
			}
		});
	}

	//  Customizer Previewer
	api.LoginCustomizerCustomizerPreviewer = {

		init: function () {

			var
				self = this,
				active_state,
				logo_event  		= 'login-customizer-edit-logo',
				form_event  		= 'login-customizer-edit-loginform',
				fields_event 		= 'login-customizer-edit-loginform-fields',
				username_label_event 	= 'login-customizer-edit-loginform-labels-username',
				password_label_event 	= 'login-customizer-edit-loginform-labels-password',
				button_event 		= 'login-customizer-edit-button',
				background_event 	= 'login-customizer-edit-background',
				remember_event 		= 'login-customizer-edit-remember-me',
				checkbox_event 		= 'login-customizer-edit-remember-me-checkbox',
				below_event 		= 'login-customizer-edit-below';

			// Function used for contextually aware Customizer options.
			function bind_control_visibility_event( event, active_controls, focus_control ) {

				api.LoginCustomizerCustomizerPreviewer.preview.bind( event, function() {
					// Visibility.
					active_control( active_controls );

					// Focus.
					wp.customize.control( focus_control ).focus();
				} );
			}

			// Function used for contextually aware Customizer options.
			function bind_logo_control_visibility_event( event, active_controls, focus_control ) {

				api.LoginCustomizerCustomizerPreviewer.preview.bind( event, function() {

					// Visibility.
					active_control( active_controls );

					// Focus.
					wp.customize.control( focus_control ).focus();

					// Only show the width if there is a logo uploaded.
					if ( true === wp.customize.control( 'login_customizer[disable_logo]' ).setting.get() ) {
						wp.customize.control( 'login_customizer[logo_height]' ).deactivate( { duration: 0 } );
						wp.customize.control( 'login_customizer[logo_width]' ).deactivate( { duration: 0 } );
					}

				} );
			}

			// Only show visible options when necessary.
			bind_logo_control_visibility_event( logo_event, all_controls.logo, 'login_customizer[logo]' );
			bind_control_visibility_event( form_event, all_controls.form, 'login_customizer[form_title]' );
			bind_control_visibility_event( fields_event, all_controls.fields, 'login_customizer[form_title]' );
			bind_control_visibility_event( username_label_event, all_controls.labels, 'login_customizer[username_label]' );
			bind_control_visibility_event( password_label_event, all_controls.labels, 'login_customizer[password_label]' );
			bind_control_visibility_event( button_event, all_controls.button, 'login_customizer[button_title]' );
			bind_control_visibility_event( background_event, all_controls.background, 'login_customizer[bg_title]' );
			bind_control_visibility_event( remember_event, all_controls.remember, 'login_customizer[remember_title]' );
			bind_control_visibility_event( checkbox_event, all_controls.checkbox, 'login_customizer[checkbox_title]' );
			bind_control_visibility_event( below_event, all_controls.below, 'login_customizer[below_title]' );

			// Open settings panel when the settings icon is clicked.
			this.preview.bind( 'login-customizer-edit-settings', function() {
				var section = wp.customize.section( 'login_customizer__section--settings' );
				if ( ! section.expanded() ) {
					section.expand( { duration: 0 } );
				}
			} );

			// Open settings panel when the settings icon is clicked.
			this.preview.bind( 'login-customizer-edit-template', function() {
				var section = wp.customize.section( 'login_customizer__section--templates' );
				if ( ! section.expanded() ) {
					section.expand( { duration: 0 } );
				}
			} );

			// Open settings panel when the Login Customizer badge is clicked.
			this.preview.bind( 'login-customizer-edit-branding', function() {
				var section = wp.customize.section( 'login_customizer__section--settings' );
				if ( ! section.expanded() ) {
					section.expand( { duration: 0 } );
				}
			} );

			this.preview.bind( 'login-customizer-edit-language', function(){
				var section = wp.customize.section( 'login_customizer__section--translations' );
				if ( ! section.expanded() ) {
					section.expand( { duration: 0 } );
				}
			} );
		}
	};

	/**
	 * Capture the instance of the Preview since it is private.
	 */
	LoginCustomizerOldPreviewer = api.Previewer;
	api.Previewer = LoginCustomizerOldPreviewer.extend( {
		initialize: function( params, options ) {

			// Store a reference to the Previewer
			api.LoginCustomizerCustomizerPreviewer.preview = this;

			// Call the old Previewer's initialize function
			LoginCustomizerOldPreviewer.prototype.initialize.call( this, params, options );
		}
	} );

	$( function() {
		// Initialize our Previewer
		api.LoginCustomizerCustomizerPreviewer.init();
	} );

} )( wp, jQuery );
