/**
 * Customizer Live Events.
 */
( function ( wp, $ ) {
	"use strict";

	$( '#login-customizer--username, #login-customizer--password').hover(function() {
		$( '#login form').toggleClass( 'input-hover' );
	});

	$( '#login-customizer--username-label, #login-customizer--password-label').hover(function() {
		$( '#login form').toggleClass( 'label-hover' );
	});

	// Bail if the Customizer isn't initialized
	if ( ! wp || ! wp.customize ) {
		return;
	}

	var api = wp.customize, LoginCustomizerOldPreview;

	// Custom Customizer Preview class (attached to the Customize API)
	api.LoginCustomizerCustomizerPreview = {
		// Init
		init: function () {
			var self = this;

			// When the previewer is active, the "active" event has been triggered (on load)
			this.preview.bind( 'active', function() {

				var
					$body 		= $( 'body'),
					$body_bg 	= $( '#login'),
					$document 	= $( document ),
					$logo	 	= $( '#login-customizer-logo-h1'),
					$loginform	= $( '#login form'),
					$loginform_text	= $( '#login-customizer--username'),
					$loginform_pass	= $( '#login-customizer--password'),
					$username_label	= $( '#login-customizer--username-label'),
					$password_label	= $( '#login-customizer--password-label'),
					$button		= $( '#login-customizer--button'),
					$remember_me	= $( '.forgetmenot'),
					$remember_me_cb	= $( '.forgetmenot label'),
					$below_form	= $( '#login-customizer--below-form'),
					$branding	= $( '.login-customizer-badge__inner'),
					$language_switcher = $( '.login-customizer--translation-switcher' );

				$logo.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-logo"></button>' );

				$loginform.append( '<span class="customize-partial--loginform customize-partial-edit-shortcut"><button class="login-customizer-event-button customize-partial-edit-shortcut-button" data-login-customizer-customizer-event="login-customizer-edit-loginform"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M13.89 3.39l2.71 2.72c.46.46.42 1.24.03 1.64l-8.01 8.02-5.56 1.16 1.16-5.58s7.6-7.63 7.99-8.03c.39-.39 1.22-.39 1.68.07zm-2.73 2.79l-5.59 5.61 1.11 1.11 5.54-5.65zm-2.97 8.23l5.58-5.6-1.07-1.08-5.59 5.6z"></path></svg></button></span>' );

				$loginform_text.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-loginform-fields"></button>' );
				$loginform_pass.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-loginform-fields"></button>' );

				$username_label.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-loginform-labels-username"></button>' );
				$password_label.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-loginform-labels-password"></button>' );

				$body_bg.append( '<span class="customize-partial--login-customizer-background customize-partial-edit-shortcut"><button class="login-customizer-event-button customize-partial-edit-shortcut-button" data-login-customizer-customizer-event="login-customizer-edit-background"></button></span>' );

				$button.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-button"></button>' );

				// Settings
				$body_bg.append( '<span class="customize-partial--login-customizer-settings customize-partial-edit-shortcut"><button class="login-customizer-event-button customize-partial-edit-shortcut-button" data-login-customizer-customizer-event="login-customizer-edit-settings"></button></span>' );

				// Templates
				$body_bg.append( '<span class="customize-partial--login-customizer-template customize-partial-edit-shortcut"><button class="login-customizer-event-button customize-partial-edit-shortcut-button" data-login-customizer-customizer-event="login-customizer-edit-template"></button></span>' );

				if ( login_customizer_customize_live.label_hidden ) {
					$body.append( '<span style="top: 90px;left: 40px;font-size: 10px" class=" customize-partial-edit-shortcut"><button style="font-size: 10px" class="login-customizer-event-button customize-partial-edit-shortcut-button" data-login-customizer-customizer-event="login-customizer-edit-remember-me">label</button></span>' );
				}

				// Remember Me
				$remember_me.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-remember-me"></button>' );

				// Checkbox
				$remember_me_cb.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-remember-me-checkbox"></button>' );

				// Below Form
				$below_form.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-below"></button>' );

				// Below Form
				$branding.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-branding"></button>' );
				$language_switcher.append( '<button class="login-customizer-event-button customizer-event-overlay" data-login-customizer-customizer-event="login-customizer-edit-language"></button>' );

				// Listen for events on the new previewer buttons
				$document.on( 'touch click', '.login-customizer-event-button', function( e ) {
					var $this = $( this );

					// Send the event that we've specified on the HTML5 data attribute ('data-login-customizer-customizer-event') to the Customizer
					self.preview.send( $this.attr( 'data-login-customizer-customizer-event' ) );
				} );

			} );
		}
	};

	/**
	 * Capture the instance of the Preview since it is private (this has changed in WordPress 4.0)
	 */
	LoginCustomizerOldPreview = api.Preview;
	api.Preview = LoginCustomizerOldPreview.extend( {
		initialize: function( params, options ) {
			// Store a reference to the Preview
			api.LoginCustomizerCustomizerPreview.preview = this;

			// Call the old Preview's initialize function
			LoginCustomizerOldPreview.prototype.initialize.call( this, params, options );
		}
	} );

	$( function () {
		// Initialize our Preview
		api.LoginCustomizerCustomizerPreview.init();
	} );

} )( window.wp, jQuery );
