<?php
/**
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Login_Customizer_Customizer_Scripts' ) ) :

	/**
	 * Enqueues JS & CSS assets
	 */
	class Login_Customizer_Customizer_Scripts {

		/**
		 * The class constructor.
		 * Adds actions to enqueue our assets.
		 */
		public function __construct() {
			add_action( 'customize_controls_print_styles', array( $this, 'control_styles' ), 99 );
			add_action( 'customize_preview_init', array( $this, 'customize_preview' ) );
			add_action( 'login_enqueue_scripts', array( $this, 'customize_styles' ), 99 );
			add_action( 'wp_footer', array( $this, 'preview_data' ), 1000 );
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'customize_controls' ) );
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'custom_controls' ) );
			add_action( 'customize_controls_enqueue_scripts', array( $this, 'localization' ), 99 );	
		}

		/**
		 * Enqueue the stylesheets required.
		 *
		 * @access public
		 */
		public function control_styles() {

			// Define where the asset is loaded from.
			$dir = Login_Customizer()->asset_source( 'css' );

			wp_enqueue_style( 'login-customizer-customize-controls', $dir . 'login-customizer-customize-controls' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.css', null, LOGIN_CUSTOMIZER_VERSION );
			wp_enqueue_style( 'login-customizer-custom-section-styles', LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/css/sections/login-customizer-section.css', array(), LOGIN_CUSTOMIZER_VERSION, 'all' );
		}

		/**
		 * Enqueue the stylesheets required.
		 *
		 * @access public
		 */
		public function customize_styles() {
			if ( ! is_customize_preview() ) {
				return;
			}

			// Define where the asset is loaded from.
			$dir = Login_Customizer()->asset_source( 'css' );

			wp_enqueue_style( 'login-customizer-customize-preview', $dir . 'login-customizer-customize-preview' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.css', LOGIN_CUSTOMIZER_VERSION, 'all' );
			if ( in_array( 'password-protected/password-protected.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
				wp_enqueue_style( 'password-protected-customize-preview', $dir . 'password-protected-customize-preview' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.css', LOGIN_CUSTOMIZER_VERSION, 'all' );
			}
			wp_enqueue_style( 'login-customizer-customize-ripple-effects', $dir . 'login-customizer-ripple-effects' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.css', LOGIN_CUSTOMIZER_VERSION, 'all' );

			wp_enqueue_script( 'login-customizer-customize-ripple-effects', LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/js/src/login-customizer-ripple-effects.js', array( 'jquery' ), LOGIN_CUSTOMIZER_VERSION, true );
		}

		/**
		 * Enqueues scripts in the Customizer.
		 */
		public function customize_preview() {

			// Define where the asset is loaded from.
			$dir = Login_Customizer()->asset_source( 'js' );

			wp_enqueue_script( 'login-customizer-customize-live', $dir . 'login-customizer-customize-live' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-preview' ), LOGIN_CUSTOMIZER_VERSION, true );
			wp_enqueue_script( 'login-customizer-customize-preview', $dir . 'login-customizer-customize-preview' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-preview' ), LOGIN_CUSTOMIZER_VERSION, true );

			// Pull the Login Customizer page from options.
			$page = Login_Customizer()->get_login_customizer_page();

			// Look for extension backgrounds.
			$customizer = new Login_Customizer_Customizer_Output();

			// Localization.
			$localize = array(
				'admin_url'             => admin_url(),
				'ajax_url'              => admin_url( 'admin-ajax.php' ),
				'plugins_url'           => plugins_url(),
				'plugin_url'            => LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/images/backgrounds/',
				'login_customizer_page'   => get_permalink( $page ),
				'font_url'              => esc_url_raw( 'https://fonts.googleapis.com/css' ),
				'font_subset'           => '&latin,latin-ext',
				'extension_backgrounds' => $customizer->extension_backgrounds(),
			);

			if ( in_array( 'password-protected/password-protected.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
				$localize['password_protected_page'] = get_permalink( Login_Customizer_Password_Protected::get_password_protected_id() );
				wp_enqueue_script( 'password-protected-customize-live', $dir . 'password-protected-customize-live' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-preview' ), LOGIN_CUSTOMIZER_VERSION, true );
				wp_enqueue_script( 'password-protected-customize-preview', $dir . 'password-protected-customize-preview' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-preview' ), LOGIN_CUSTOMIZER_VERSION, true );
				wp_localize_script( 'password-protected-customize-preview', 'password_protected_script', $localize );
			}

			$localize = apply_filters( 'login_customizer_customize_preview_localization', $localize );

			wp_localize_script( 'login-customizer-customize-preview', 'login_customizer_script', $localize );

			$localization = array(
				'label_hidden' => false,
			);
			if ( isset( get_option( 'login_customizer' )['remember_hide'] ) && get_option( 'login_customizer' )['remember_hide'] ) {
				$localization['label_hidden'] = true;
			}
			wp_localize_script( 'login-customizer-customize-live', 'login_customizer_customize_live', $localization );
		}

		/**
		 * Add export_preview_data() core function, as its missing on the login page within the Customizer.
		 */
		public function preview_data() {
			if ( ! $this->is_preview_mode() ) {
				return;
			}
			echo '<script>var _customizePartialRefreshExports = "";var _ldAdminNounce = '.wp_create_nonce( 'login-customizer-admin').'"</script>';
		}

		/**
		 * Enqueues scripts in the Customizer.
		 */
		public function customize_controls() {

			// Define where the asset is loaded from.
			$dir = Login_Customizer()->asset_source( 'js' );

			wp_enqueue_script( 'login-customizer-customize-controls', $dir . 'login-customizer-customize-controls' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
			wp_enqueue_script( 'login-customizer-customize-events', $dir . 'login-customizer-customize-events' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );

			// Pull the Login Customizer page from options.
			$page = Login_Customizer()->get_login_customizer_page();

			// Customizer output.
			$customizer = new Login_Customizer_Customizer_Output();

			// Localization.
			$localize = array(
				'plugin_url'          => LOGIN_CUSTOMIZER_PLUGIN_URL . 'assets/images/backgrounds/',
				'login_customizer_page' => get_permalink( $page ),
				'extension_bg_colors' => $customizer->extension_colors(),
			);

			if ( in_array( 'password-protected/password-protected.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
				$localize['password_protected_page'] = get_permalink( Login_Customizer_Password_Protected::get_password_protected_id() );
				wp_enqueue_script( 'password-protected-customize-controls', $dir . 'password-protected-customize-controls' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
				wp_enqueue_script( 'password-protected-customize-events', $dir . 'password-protected-customize-events' . LOGIN_CUSTOMIZER_ASSET_SUFFIX . '.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
				wp_localize_script( 'password-protected-customize-controls', 'password_protected_controls', $localize );
			}

			$localize = apply_filters( 'login_customizer_control_localization', $localize );

			$localize['my_cb'] = function( $t, $x ) use ( $localize ) {
				return $localize;
			};

			wp_localize_script( 'login-customizer-customize-controls', 'login_customizer_controls', $localize );
		}

		/**
		 * Enqueues control scripts for custom controls.
		 *
		 */
		public function custom_controls() {

			if ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && true === LOGIN_CUSTOMIZER_DEBUG ) {
				return;
			}

			// Define where the asset is loaded from.
			$dir = Login_Customizer()->asset_source( 'js' );

			// Enqueue the asset. Note that there is no minified version of this singular asset.
			wp_enqueue_script( 'login-customizer-customize-custom-controls', $dir . 'login-customizer-customize-custom-controls.min.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
		}
		public function is_preview_mode() {
		
			// Check if preview page is the current page.
			if ( isset( $_GET['preview'] ) ) {
				return true;
			}
			else {
				return false;
			}
		}
		/**
		 * Localize Customizer ontrols.
		 *
		 */
		public function localization() {

			// Localization.
			$localize = array(
				'ajaxurl'     => admin_url( 'admin-ajax.php' ),
				'btn_default' => esc_html__( 'Install New Template', 'login-customizer' ),
				'btn_close'   => esc_html__( 'Close', 'login-customizer' ),
				'confirm'     => esc_html__( 'Attention! You are attempting to reset all custom styling added to Login Customizer. Please note that this action is irreversible. Proceed?', 'login-customizer' ),
				'nonce'       => array(
					'activate'   => wp_create_nonce( 'login-customizer-activate-license' ),
					'deactivate' => wp_create_nonce( 'login-customizer-deactivate-license' ),
				),
			);

			// If LOGIN_CUSTOMIZER_DEBUG is active.
			if ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && LOGIN_CUSTOMIZER_DEBUG ) {
				wp_localize_script( 'login-customizer-license-control', 'login_customizer_custom_controls', $localize );
				wp_localize_script( 'login-customizer-template-control', 'login_customizer_custom_controls', $localize );
			} else {
				wp_localize_script( 'login-customizer-customize-custom-controls', 'login_customizer_custom_controls', $localize );
			}
		}
	}

endif;

new Login_Customizer_Customizer_Scripts();
