<?php
/**
 * Range Customizer Control
 *
 * @package Login Customizer
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Exit if WP_Customize_Control does not exsist.
if ( ! class_exists( 'WP_Customize_Control' ) ) {
	return null;
}

/**
 * This class is for the toggle control in the Customizer.
 *
 * @access public
 */
class Login_Customizer_Range_Control extends WP_Customize_Control {

	/**
	 * The type of customize control.
	 * @var    string
	 */
	public $type = 'login-customizer-range';

	/**
	 * Enqueue neccessary custom control scripts.
	 */
	public function enqueue() {

		if ( ! defined( 'LOGIN_CUSTOMIZER_DEBUG' ) || ( defined( 'LOGIN_CUSTOMIZER_DEBUG' ) && false === LOGIN_CUSTOMIZER_DEBUG ) ) {
			return;
		}

		// Define where the asset is loaded from.
		$dir = Login_Customizer()->asset_source( 'js', 'controls/' );

		// Enqueue the asset. Note that there is no minified version of this singular asset.
		wp_enqueue_script( 'login-customizer-range-control', $dir . 'login-customizer-range-control.js', array( 'customize-controls' ), LOGIN_CUSTOMIZER_VERSION, true );
	}

	/**
	 * Add custom parameters to pass to the JS via JSON.
	 * @return void
	 */
	public function to_json() {
		parent::to_json();

		// The setting value.
		$this->json['id']                  = $this->id;
		$this->json['value']               = $this->value();
		$this->json['link']                = $this->get_link();
		$this->json['defaultValue']        = $this->setting->default;
		$this->json['input_attrs']['min']  = ( isset( $this->input_attrs['min'] ) ) ? $this->input_attrs['min'] : '0';
		$this->json['input_attrs']['max']  = ( isset( $this->input_attrs['max'] ) ) ? $this->input_attrs['max'] : '100';
		$this->json['input_attrs']['step'] = ( isset( $this->input_attrs['step'] ) ) ? $this->input_attrs['step'] : '1';
	}

	/**
	 * Don't render the content via PHP.  This control is handled with a JS template.
	 * @return void
	 */
	public function render_content() {}

	/**
	 * @return void
	 */
	protected function content_template() {
		?>

		<div class="login-customizer-range">

			<# if ( data.label ) { #>
				<label class="login-customizer-range__label">
					<span class="customize-control-title">{{ data.label }}</span>
				</label>
			<# } #>

			<div class="login-customizer-range__value">
				<span>{{ data.value }}</span>
				<input id="range-{{ data.id }}" type="number" class="login-customizer-range__number-input" value="{{ data.value }}" data-default-value="{{ data.defaultValue }}" {{{ data.link }}} <# if ( data.value ) { #> checked="checked" <# } #> readonly="readonly" />
				<# if ( data.description ) { #>
					<em>{{ data.description }}</em>
				<# } #>
			</div>

			<input type="range" data-input-type="range" class="login-customizer-range__track" value="{{ data.value }}" data-default-value="{{ data.defaultValue }}"  min="{{ data.input_attrs['min'] }}" max="{{ data.input_attrs['max'] }}" step="{{ data.input_attrs['step'] }}" {{{ data.link }}} />

			<a type="button" value="reset" class="login-customizer-range__reset"></a>

		</div>
		<?php
	}
}
