<?php
/**
 * Theme upgrade control.
 *
 * @package Login Customizer
 */

/**
 * Custom control to display a pro upgrade button in the Customizer.
 *
 * @access public
 */
class Login_Customizer_Upgrade_Control extends WP_Customize_Section {

	/**
	 * @var    string
	 */
	public $type = 'upgrade';

	/**
	 * @var    string
	 */
	public $pro_text = '';

	/**
	 * @var    string
	 */
	public $pro_url = '';

	/**
	 * @access public
	 */
	public function json() {
		$json = parent::json();

		$json['pro_text'] = $this->pro_text;
		$json['pro_url']  = esc_url( $this->pro_url );

		return $json;
	}

	/**
	 * @access public
	 */
	protected function render_template() {
		?>

		<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">

			<h3 class="accordion-section-title">
				{{ data.title }}
				<# if ( data.pro_text && data.pro_url ) { #>
					<a href="{{ data.pro_url }}" class="button button-secondary alignright" target="_blank">{{ data.pro_text }}</a>
				<# } #>
			</h3>
		</li>
		<?php
	}
}
