<?php
/**
 * Filters to exclude the Login Customizer page from external plugins.
 *
 * @package Login Customizer
 */

add_filter( 'wpseo_exclude_from_sitemap_by_post_ids', 'login_customizer_wpseo_exclude_page_id' );
if ( ! function_exists( 'login_customizer_wpseo_exclude_page_id' ) ) {
	/**
	 * Excluding Login designer page ID form WPSEO
	 *
	 * @param array $posts_to_exclude Post|Page Ids.
	 *
	 * @return array
	 */
	function login_customizer_wpseo_exclude_page_id( $posts_to_exclude ) {
		// Pull the Login Customizer page from options.
		$page     = Login_Customizer()->get_login_customizer_page();
		$page_ids = login_customizer_pages( $page->ID );
		return array_merge( $posts_to_exclude, $page_ids );
	}
}

add_filter( 'rank_math/sitemap/posts_to_exclude', 'login_customizer_sitemap_exclude_page_id' );
if ( ! function_exists( 'login_customizer_sitemap_exclude_page_id' ) ) {
	/**
	 * Excluding Login designer page ID form Sitemap
	 *
	 * @param int $posts_to_exclude Post IDs which sre excluding.
	 *
	 * @return array
	 */
	function login_customizer_sitemap_exclude_page_id( $posts_to_exclude ) {
		// Pull the Login Customizer page from options.
		$page     = Login_Customizer()->get_login_customizer_page();
		$page_ids = login_customizer_pages( $page->ID );
		return array_merge( $posts_to_exclude, $page_ids );
	}
}
