<?php
/**
 * Below the Form Customizer Section.
 *
 * @package Login Customizer
 */

$wp_customize->add_setting(
	'login_customizer[below_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer[below_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Below Form', 'login-customizer' ),
			'description' => esc_html__( 'Modify elements below the login form.', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[below_font]',
	array(
		'default'           => $defaults['below_font'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);

$wp_customize->add_control(
	'login_customizer[below_font]',
	array(
		'type'    => 'select',
		'label'   => esc_html__( 'Font', 'login-customizer' ),
		'section' => 'login_customizer__section--styles',
		'choices' => $this->get_fonts(),
	)
);

$wp_customize->add_setting(
	'login_customizer[below_font_size]',
	array(
		'default'           => $defaults['below_font_size'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[below_font_size]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Size', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['below_font_size'],
			'input_attrs' => array(
				'min'  => 13,
				'max'  => 40,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[below_color]',
	array(
		'default'           => $defaults['below_color'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer[below_color]',
		array(
			'label'   => esc_html__( 'Color', 'login-customizer' ),
			'section' => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[below_position]',
	array(
		'default'           => $defaults['below_position'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[below_position]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Position', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['below_position'],
			'input_attrs' => array(
				'min'  => 20,
				'max'  => 80,
				'step' => 2,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[lost_password]',
	array(
		'default'           => $defaults['lost_password'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer[lost_password]',
		array(
			'label'    => esc_html__( 'Lost Password', 'login-customizer' ),
			'section'  => 'login_customizer__section--styles',
			'type'     => 'login-customizer-toggle',
			'settings' => 'login_customizer[lost_password]',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[back_to]',
	array(
		'default'           => $defaults['back_to'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer[back_to]',
		array(
			'label'    => esc_html__( 'Back To', 'login-customizer' ),
			'section'  => 'login_customizer__section--styles',
			'type'     => 'login-customizer-toggle',
			'settings' => 'login_customizer[back_to]',
		)
	)
);
