<?php
/**
 * Branding Customizer Section.
 *
 * @package Login Customizer
 */

$wp_customize->add_setting(
	'login_customizer_settings[branding_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_settings[branding_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Branding', 'login-customizer' ),
			'description' => esc_html__( 'Show some love and add a Powered by Login Customizer badge to your login page.', 'login-customizer' ),
			'section'     => 'login_customizer__section--settings',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_settings[branding]',
	array(
		'default'           => $admin_defaults['branding'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer_settings[branding]',
		array(
			'label'    => esc_html__( 'Enable', 'login-customizer' ),
			'type'     => 'login-customizer-toggle',
			'settings' => 'login_customizer_settings[branding]',
			'section'  => 'login_customizer__section--settings',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_settings[branding_color]',
	array(
		'default'           => $admin_defaults['branding_color'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer_settings[branding_color]',
		array(
			'label'   => esc_html__( 'Text', 'login-customizer' ),
			'section' => 'login_customizer__section--settings',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_settings[branding_icon_color]',
	array(
		'default'           => $admin_defaults['branding_icon_color'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer_settings[branding_icon_color]',
		array(
			'label'   => esc_html__( 'Logo', 'login-customizer' ),
			'section' => 'login_customizer__section--settings',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_settings[branding_position]',
	array(
		'default'           => $admin_defaults['branding_position'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'wp_filter_nohtml_kses',
	)
);

$wp_customize->add_control(
	'login_customizer_settings[branding_position]',
	array(
		'type'    => 'select',
		'label'   => esc_html__( 'Position', 'login-customizer' ),
		'section' => 'login_customizer__section--settings',
		'choices' => array(
			'left'      => esc_html__( 'Bottom Left', 'login-customizer' ),
			'right'     => esc_html__( 'Bottom Right', 'login-customizer' ),
			'middle'    => esc_html__( 'Bottom Middle', 'login-customizer' ),
			'top-right' => esc_html__( 'Upper Right', 'login-customizer' ),
		),
	)
);
