<?php
/**
 * Form Customizer Section.
 *
 * @package Login Customizer
 */

$wp_customize->add_setting(
	'login_customizer[form_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer[form_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Form', 'login-customizer' ),
			'description' => esc_html__( 'Easily customize the login form wrapper default styling.', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_bg]',
	array(
		'default'           => $defaults['form_bg'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);

$wp_customize->add_control(
	new WP_Customize_Color_Control(
		$wp_customize,
		'login_customizer[form_bg]',
		array(
			'label'   => esc_html__( 'Background', 'login-customizer' ),
			'section' => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_radius]',
	array(
		'default'           => $defaults['form_radius'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[form_radius]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Radius', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['form_radius'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 50,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_shadow]',
	array(
		'default'           => $defaults['form_shadow'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[form_shadow]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Shadow', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['form_shadow'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 70,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_shadow_opacity]',
	array(
		'default'           => $defaults['form_shadow_opacity'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[form_shadow_opacity]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Shadow Opacity', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => '%',
			'default'     => $defaults['form_shadow_opacity'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_side_padding]',
	array(
		'default'           => $defaults['form_side_padding'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[form_side_padding]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Horizontal Padding', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['form_side_padding'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 2,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_bg_transparency]',
	array(
		'default'           => $defaults['form_bg_transparency'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer[form_bg_transparency]',
		array(
			'label'    => esc_html__( 'Transparent', 'login-customizer' ),
			'section'  => 'login_customizer__section--styles',
			'type'     => 'login-customizer-toggle',
			'settings' => 'login_customizer[form_bg_transparency]',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_vertical_padding]',
	array(
		'default'           => $defaults['form_vertical_padding'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[form_vertical_padding]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Vertical Padding', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['form_vertical_padding'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 2,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[form_width]',
	array(
		'default'           => $defaults['form_width'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[form_width]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Width', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['form_width'],
			'input_attrs' => array(
				'min'  => 300,
				'max'  => 800,
				'step' => 2,
			),
		)
	)
);
