<?php
/**
 * Import Export Settings
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

$login_customizer          = get_option( 'login_customizer' );
$login_customizer_settings = get_option( 'login_customizer_settings' );
$value                   = array(
	'login_customizer' => $login_customizer,
	'settings'       => $login_customizer_settings,
);
$value                   = wp_json_encode( $value );
$value                   = wp_unslash( $value );

$wp_customize->add_setting(
	'login_customizer_import_export[file_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_import_export[file_title]',
		array(
			'type'    => 'login-customizer-title',
			'label'   => esc_html__( 'File Import Export Settings', 'login-customizer' ),
			'section' => 'login_customizer__section--file-import-export',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_import_export[file_import]',
	array(
		'type'      => 'option',
		'default'   => $value,
		'transport' => 'postMessage',
	)
);

$wp_customize->add_control(
	new Login_Customizer_File_Import_Button_Control(
		$wp_customize,
		'login_customizer_import_export[file_import]',
		array(
			'label'   => 'File Import',
			'section' => 'login_customizer__section--file-import-export',
		)
	)
);
