<?php
/**
 * Login Error Messges.
 *
 * @package Login Customizer
 */

defined( 'ABSPATH' ) || exit;

$wp_customize->add_setting(
	'login_customizer_error_messages[page_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer_error_messages[page_title]',
		array(
			'type'    => 'login-customizer-title',
			'label'   => esc_attr__( 'Login Error Messages', 'login-customizer' ),
			'section' => 'login_customizer__section--error-messages',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_error_messages[username_error]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'              => 'option',
		'transport'         => 'postMessage',
	)
);

$wp_customize->add_control(
	'login_customizer_error_messages[username_error]',
	array(
		'label'       => esc_attr__( 'Enter Username required message', 'login-customizer' ),
		'section'     => 'login_customizer__section--error-messages',
		'description' => esc_attr__( 'Enter the message which will display when Username field is empty', 'login-customizer' ),
		'type'        => 'text',
	)
);

$wp_customize->add_setting(
	'login_customizer_error_messages[password_error]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'              => 'option',
		'transport'         => 'postMessage',
	)
);

$wp_customize->add_control(
	'login_customizer_error_messages[password_error]',
	array(
		'label'       => esc_attr__( 'Enter Password required message', 'login-customizer' ),
		'section'     => 'login_customizer__section--error-messages',
		'description' => esc_attr__( 'Enter the message which will display when Password field is empty', 'login-customizer' ),
		'type'        => 'text',
	)
);

$wp_customize->add_setting(
	'login_customizer_error_messages[username_not_found]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'              => 'option',
		'transport'         => 'postMessage',
	)
);

$wp_customize->add_control(
	'login_customizer_error_messages[username_not_found]',
	array(
		'label'       => esc_attr__( 'Enter Username invalid message', 'login-customizer' ),
		'section'     => 'login_customizer__section--error-messages',
		'description' => esc_attr__( 'Enter the message which will display when Username is invalid', 'login-customizer' ),
		'type'        => 'text',
	)
);

$wp_customize->add_setting(
	'login_customizer_error_messages[password_incorrect]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'type'              => 'option',
		'transport'         => 'postMessage',
	)
);

$wp_customize->add_control(
	'login_customizer_error_messages[password_incorrect]',
	array(
		'label'       => esc_attr__( 'Enter Password invalid message', 'login-customizer' ),
		'section'     => 'login_customizer__section--error-messages',
		'description' => esc_attr__( 'Enter the message which will display when Password is invalid', 'login-customizer' ),
		'type'        => 'text',
	)
);
