<?php
/**
 * Logo Customizer Section.
 *
 * @package Login Customizer
 */

$wp_customize->add_setting(
	'login_customizer[logo_title]',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Title_Control(
		$wp_customize,
		'login_customizer[logo_title]',
		array(
			'type'        => 'login-customizer-title',
			'label'       => esc_html__( 'Logo', 'login-customizer' ),
			'description' => esc_html__( 'Add your own logo. Logos will display at 50% height and width to account for retina devices. Modify the height and width below.', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[logo]',
	array(
		'default'           => $defaults['logo'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new WP_Customize_Media_Control(
		$wp_customize,
		'login_customizer[logo]',
		array(
			'section'  => 'login_customizer__section--styles',
			'settings' => 'login_customizer[logo]',
		)
	)
);

$wp_customize->add_setting(
	'login_customizer_settings[logo_url]',
	array(
		'default'           => $admin_defaults['logo_url'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'login_customizer_settings[logo_url]',
	array(
		'label'          => esc_html__( 'URL', 'login-customizer' ),
		'description'    => esc_html__( 'Select a page for your logo to link to. This is typically your site\'s home page.', 'login-customizer' ),
		'section'        => 'login_customizer__section--styles',
		'type'           => 'dropdown-pages',
		'allow_addition' => false,
	)
);

$wp_customize->add_setting(
	'login_customizer[logo_width]',
	array(
		'default'           => $defaults['logo_width'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[logo_width]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Width', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['logo_width'],
			'input_attrs' => array(
				'min'  => 30,
				'max'  => 400,
				'step' => 2,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[logo_height]',
	array(
		'default'           => $defaults['logo_height'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[logo_height]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Height', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['logo_height'],
			'input_attrs' => array(
				'min'  => 30,
				'max'  => 300,
				'step' => 2,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[logo_margin_bottom]',
	array(
		'default'           => $defaults['logo_margin_bottom'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	new Login_Customizer_Range_Control(
		$wp_customize,
		'login_customizer[logo_margin_bottom]',
		array(
			'type'        => 'login-customizer-range',
			'label'       => esc_html__( 'Position', 'login-customizer' ),
			'section'     => 'login_customizer__section--styles',
			'description' => 'px',
			'default'     => $defaults['logo_margin_bottom'],
			'input_attrs' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 1,
			),
		)
	)
);

$wp_customize->add_setting(
	'login_customizer[disable_logo]',
	array(
		'default'           => $defaults['disable_logo'],
		'type'              => 'option',
		'transport'         => 'postMessage',
		'sanitize_callback' => array( $this, 'sanitize_checkbox' ),
	)
);

$wp_customize->add_control(
	new Login_Customizer_Toggle_Control(
		$wp_customize,
		'login_customizer[disable_logo]',
		array(
			'label'    => esc_html__( 'Disable Logo', 'login-customizer' ),
			'section'  => 'login_customizer__section--styles',
			'type'     => 'login-customizer-toggle',
			'settings' => 'login_customizer[disable_logo]',
		)
	)
);
